/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.sdk;

import cfca.paperless.base.util.StringUtil;
import cfca.paperless.client.util.OutPictureUtil;
import cfca.paperless.dto.ResponseHead;
import cfca.paperless.dto.bean.CircleImageStrategy;
import cfca.paperless.dto.bean.RectangleImageStrategy;
import cfca.paperless.dto.bean.SquareImageStrategy;
import cfca.paperless.dto.request.requestbody.tx20.MakeCircleSealImageRequestBody;
import cfca.paperless.dto.request.requestbody.tx20.MakeRectangleSealImageRequestBody;
import cfca.paperless.dto.request.requestbody.tx20.MakeSquareSealImageRequestBody;
import cfca.paperless.dto.request.tx20.MakeCircleSealImageRequest;
import cfca.paperless.dto.request.tx20.MakeRectangleSealImageRequest;
import cfca.paperless.dto.request.tx20.MakeSquareSealImageRequest;
import cfca.paperless.dto.response.responsebody.tx20.MakeCircleSealImageResponseBody;
import cfca.paperless.dto.response.responsebody.tx20.MakeRectangleSealImageResponseBody;
import cfca.paperless.dto.response.responsebody.tx20.MakeSquareSealImageResponseBody;
import cfca.paperless.dto.response.tx20.MakeCircleSealImageResponse;
import cfca.paperless.dto.response.tx20.MakeRectangleSealImageResponse;
import cfca.paperless.dto.response.tx20.MakeSquareSealImageResponse;
import cfca.sadk.ofd.base.common.ImageUtil;
import cfca.sadk.util.Base64;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MakeSealImageProcess {
    private static final Logger logger = LoggerFactory.getLogger(MakeSealImageProcess.class);

    public MakeSquareSealImageResponse process(MakeSquareSealImageRequest requestBean) throws Exception {
        long start = System.currentTimeMillis();
        logger.info("MakeSealImageProcess.process start.");
        MakeSquareSealImageRequestBody requestBody = requestBean.getBody();
        byte[] imageData = new byte[]{};
        SquareImageStrategy imageStrategy = requestBody.getImageStrategy();
        int fontSize = Integer.parseInt(imageStrategy.getFontSize());
        int newWidth = Integer.parseInt(imageStrategy.getImageWidth());
        int newHeight = Integer.parseInt(imageStrategy.getImageHeight());
        String unit = imageStrategy.getUnit();
        int dpi = Integer.parseInt(imageStrategy.getDpi());
        if ("1".equals(unit)) {
            newWidth = ImageUtil.mmConvertToPx((double)newWidth, (double)dpi);
            newHeight = ImageUtil.mmConvertToPx((double)newHeight, (double)dpi);
        }
        if ("1".equals(imageStrategy.getImageShape())) {
            imageData = OutPictureUtil.getNamePngToByte(imageStrategy.getImageName(), newHeight, newWidth, fontSize, imageStrategy.getColor(), imageStrategy.getFamily(), false, dpi);
        } else if ("11".equals(imageStrategy.getImageShape())) {
            imageData = OutPictureUtil.getNamePngToByte(imageStrategy.getImageName(), newHeight, newWidth, fontSize, imageStrategy.getColor(), imageStrategy.getFamily(), true, dpi);
        }
        String imageBase64String = new String(Base64.encode((byte[])imageData), "UTF-8");
        ResponseHead head = new ResponseHead();
        head.setTransactionNo(requestBean.getHead().getTransactionNo());
        MakeSquareSealImageResponseBody body = new MakeSquareSealImageResponseBody();
        body.setImage(imageBase64String);
        MakeSquareSealImageResponse responseBean = new MakeSquareSealImageResponse();
        responseBean.setHead(head);
        responseBean.setBody(body);
        long end = System.currentTimeMillis();
        logger.info("MakeSealImageProcess.process end. time-taken={}ms", (Object)(end - start));
        return responseBean;
    }

    public MakeRectangleSealImageResponse process(MakeRectangleSealImageRequest requestBean) throws Exception {
        long start = System.currentTimeMillis();
        logger.info("MakeSealImageProcess.process start.");
        MakeRectangleSealImageRequestBody requestBody = requestBean.getBody();
        byte[] imageData = new byte[]{};
        RectangleImageStrategy imageStrategy = requestBody.getImageStrategy();
        int fontSize = Integer.parseInt(imageStrategy.getFontSize());
        int newWidth = Integer.parseInt(imageStrategy.getImageWidth());
        int newHeight = Integer.parseInt(imageStrategy.getImageHeight());
        String unit = imageStrategy.getUnit();
        int dpi = Integer.parseInt(imageStrategy.getDpi());
        if ("1".equals(unit)) {
            newWidth = ImageUtil.mmConvertToPx((double)newWidth, (double)dpi);
            newHeight = ImageUtil.mmConvertToPx((double)newHeight, (double)dpi);
        }
        if ("2".equals(imageStrategy.getImageShape())) {
            imageData = OutPictureUtil.getRectanglePng(imageStrategy.getImageName(), newWidth, newHeight, fontSize, imageStrategy.getColor(), imageStrategy.getFamily(), false, dpi);
        } else if ("21".equals(imageStrategy.getImageShape())) {
            imageData = OutPictureUtil.getRectanglePng(imageStrategy.getImageName(), newWidth, newHeight, fontSize, imageStrategy.getColor(), imageStrategy.getFamily(), true, dpi);
        }
        String imageBase64String = new String(Base64.encode((byte[])imageData), "UTF-8");
        ResponseHead head = new ResponseHead();
        head.setTransactionNo(requestBean.getHead().getTransactionNo());
        MakeRectangleSealImageResponseBody body = new MakeRectangleSealImageResponseBody();
        body.setImage(imageBase64String);
        MakeRectangleSealImageResponse responseBean = new MakeRectangleSealImageResponse();
        responseBean.setHead(head);
        responseBean.setBody(body);
        long end = System.currentTimeMillis();
        logger.info("MakeSealImageProcess.process end. time-taken={}ms", (Object)(end - start));
        return responseBean;
    }

    public MakeCircleSealImageResponse process(MakeCircleSealImageRequest requestBean, Map<String, String> parameterMap) throws Exception {
        long start = System.currentTimeMillis();
        logger.info("MakeSealImageProcess.process start.");
        String sealModelImageFilePath = parameterMap.get("sealModelImageFilePath");
        MakeCircleSealImageRequestBody requestBody = requestBean.getBody();
        byte[] imageData = new byte[]{};
        CircleImageStrategy imageStrategy = requestBody.getImageStrategy();
        int fontSize = Integer.parseInt(imageStrategy.getFontSize());
        int newWidth = Integer.parseInt(imageStrategy.getImageWidth());
        int newHeight = Integer.parseInt(imageStrategy.getImageHeight());
        String unit = imageStrategy.getUnit();
        int dpi = Integer.parseInt(imageStrategy.getDpi());
        if ("1".equals(unit)) {
            newWidth = ImageUtil.mmConvertToPx((double)newWidth, (double)dpi);
            newHeight = ImageUtil.mmConvertToPx((double)newHeight, (double)dpi);
        }
        String centFont = imageStrategy.getFamily();
        int centFontSize = Integer.parseInt(imageStrategy.getFontSize());
        int centHeight = 0;
        int centWidth = 0;
        if (StringUtil.isNotEmpty((String)imageStrategy.getImageName2())) {
            centWidth = (int)(-180.0 + 460.0 * Double.parseDouble(imageStrategy.getImageName2RatioX()));
            centHeight = (int)(-380.0 + (460.0 * Double.parseDouble(imageStrategy.getImageName2RatioY()) + 30.0));
        }
        if ("3".equals(imageStrategy.getImageShape())) {
            imageData = StringUtil.isNotEmpty((String)imageStrategy.getBusinessCode()) ? OutPictureUtil.getCirclePngToByte(imageStrategy.getImageName(), imageStrategy.getFamily(), imageStrategy.getImageName2(), centFont, centFontSize, centHeight, centWidth, newHeight, newWidth, fontSize, imageStrategy.getBusinessCode(), imageStrategy.getBusinessFamily(), Float.parseFloat(imageStrategy.getBusinessFontSize()), Float.parseFloat(imageStrategy.getBusinessRatioX()), Float.parseFloat(imageStrategy.getBusinessRatioY()), sealModelImageFilePath, dpi) : OutPictureUtil.getCirclePngToByte(imageStrategy.getImageName(), imageStrategy.getFamily(), imageStrategy.getImageName2(), centFont, centFontSize, centHeight, centWidth, newHeight, newWidth, fontSize, sealModelImageFilePath, dpi);
        } else if ("4".equals(imageStrategy.getImageShape())) {
            imageData = StringUtil.isNotEmpty((String)imageStrategy.getBusinessCode()) ? OutPictureUtil.getCircleStarPngToByte(imageStrategy.getImageName(), imageStrategy.getFamily(), imageStrategy.getImageName2(), centFont, centFontSize, centHeight, centWidth, newHeight, newWidth, fontSize, imageStrategy.getBusinessCode(), imageStrategy.getBusinessFamily(), Float.parseFloat(imageStrategy.getBusinessFontSize()), Float.parseFloat(imageStrategy.getBusinessRatioX()), Float.parseFloat(imageStrategy.getBusinessRatioY()), sealModelImageFilePath, dpi) : OutPictureUtil.getCircleStarPngToByte(imageStrategy.getImageName(), imageStrategy.getFamily(), imageStrategy.getImageName2(), centFont, centFontSize, centHeight, centWidth, newHeight, newWidth, fontSize, sealModelImageFilePath, dpi);
        } else {
            throw new Exception("imageShape \u53d6\u503c\u53ea\u80fd\u662f3\u6216\u80054");
        }
        String imageBase64String = new String(Base64.encode((byte[])imageData), "UTF-8");
        ResponseHead head = new ResponseHead();
        head.setTransactionNo(requestBean.getHead().getTransactionNo());
        MakeCircleSealImageResponseBody body = new MakeCircleSealImageResponseBody();
        body.setImage(imageBase64String);
        MakeCircleSealImageResponse responseBean = new MakeCircleSealImageResponse();
        responseBean.setHead(head);
        responseBean.setBody(body);
        long end = System.currentTimeMillis();
        logger.info("MakeSealImageProcess.process end. time-taken={}ms", (Object)(end - start));
        return responseBean;
    }
}

