/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.layout.minmaxwidth;

import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import cfca.sadk.com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;

public class RotationMinMaxWidth
extends MinMaxWidth {
    private double minWidthOrigin;
    private double maxWidthOrigin;
    private double minWidthHeight;
    private double maxWidthHeight;

    public RotationMinMaxWidth(double minWidth, double maxWidth, double minWidthOrigin, double maxWidthOrigin, double minWidthHeight, double maxWidthHeight) {
        super(0.0f, MinMaxWidthUtils.getMax(), (float)minWidth, (float)maxWidth);
        this.maxWidthOrigin = maxWidthOrigin;
        this.minWidthOrigin = minWidthOrigin;
        this.minWidthHeight = minWidthHeight;
        this.maxWidthHeight = maxWidthHeight;
    }

    public double getMinWidthOrigin() {
        return this.minWidthOrigin;
    }

    public double getMaxWidthOrigin() {
        return this.maxWidthOrigin;
    }

    public double getMinWidthHeight() {
        return this.minWidthHeight;
    }

    public double getMaxWidthHeight() {
        return this.maxWidthHeight;
    }

    public static RotationMinMaxWidth calculate(double angle, double area, MinMaxWidth elementMinMaxWidth) {
        WidthFunction function = new WidthFunction(angle, area);
        return RotationMinMaxWidth.calculate(function, (double)elementMinMaxWidth.getMinWidth(), elementMinMaxWidth.getMaxWidth());
    }

    public static RotationMinMaxWidth calculate(double angle, double area, MinMaxWidth elementMinMaxWidth, double availableWidth) {
        WidthFunction function = new WidthFunction(angle, area);
        WidthFunction.Interval validArguments = function.getValidOriginalWidths(availableWidth);
        if (validArguments == null) {
            return null;
        }
        double xMin = Math.max((double)elementMinMaxWidth.getMinWidth(), validArguments.getMin());
        double xMax = Math.min((double)elementMinMaxWidth.getMaxWidth(), validArguments.getMax());
        if (xMax < xMin) {
            double rotatedWidth = function.getRotatedWidth(xMin);
            double rotatedHeight = function.getRotatedHeight(xMin);
            return new RotationMinMaxWidth(rotatedWidth, rotatedWidth, xMin, xMin, rotatedHeight, rotatedHeight);
        }
        return RotationMinMaxWidth.calculate(function, xMin, xMax);
    }

    public static double calculateRotatedWidth(Rectangle area, double angle) {
        return (double)area.getWidth() * RotationMinMaxWidth.cos(angle) + (double)area.getHeight() * RotationMinMaxWidth.sin(angle);
    }

    private static RotationMinMaxWidth calculate(WidthFunction func, double xMin, double xMax) {
        double maxWidthOrigin;
        double minWidthOrigin;
        double x0 = func.getWidthDerivativeZeroPoint();
        if (x0 < xMin) {
            minWidthOrigin = xMin;
            maxWidthOrigin = xMax;
        } else if (x0 > xMax) {
            minWidthOrigin = xMax;
            maxWidthOrigin = xMin;
        } else {
            minWidthOrigin = x0;
            maxWidthOrigin = func.getRotatedWidth(xMax) > func.getRotatedWidth(xMin) ? xMax : xMin;
        }
        return new RotationMinMaxWidth(func.getRotatedWidth(minWidthOrigin), func.getRotatedWidth(maxWidthOrigin), minWidthOrigin, maxWidthOrigin, func.getRotatedHeight(minWidthOrigin), func.getRotatedHeight(maxWidthOrigin));
    }

    private static double sin(double angle) {
        return RotationMinMaxWidth.correctSinCos(Math.abs(Math.sin(angle)));
    }

    private static double cos(double angle) {
        return RotationMinMaxWidth.correctSinCos(Math.abs(Math.cos(angle)));
    }

    private static double correctSinCos(double value) {
        if (MinMaxWidthUtils.isEqual(value, 0.0)) {
            return 0.0;
        }
        if (MinMaxWidthUtils.isEqual(value, 1.0)) {
            return 1.0;
        }
        return value;
    }

    private static class WidthFunction {
        private double sin;
        private double cos;
        private double area;

        public WidthFunction(double angle, double area) {
            this.sin = RotationMinMaxWidth.sin(angle);
            this.cos = RotationMinMaxWidth.cos(angle);
            this.area = area;
        }

        public double getRotatedWidth(double x) {
            return x * this.cos + this.area * this.sin / x;
        }

        public double getRotatedHeight(double x) {
            return x * this.sin + this.area * this.cos / x;
        }

        public Interval getValidOriginalWidths(double availableWidth) {
            double maxWidth;
            double minWidth;
            if (this.cos == 0.0) {
                minWidth = this.area * this.sin / availableWidth;
                maxWidth = MinMaxWidthUtils.getMax();
            } else if (this.sin == 0.0) {
                minWidth = 0.0;
                maxWidth = availableWidth / this.cos;
            } else {
                double D = availableWidth * availableWidth - 4.0 * this.area * this.sin * this.cos;
                if (D < 0.0) {
                    return null;
                }
                minWidth = (availableWidth - Math.sqrt(D)) / (2.0 * this.cos);
                maxWidth = (availableWidth + Math.sqrt(D)) / (2.0 * this.cos);
            }
            return new Interval(minWidth, maxWidth);
        }

        public double getWidthDerivativeZeroPoint() {
            return Math.sqrt(this.area * this.sin / this.cos);
        }

        public static class Interval {
            private double min;
            private double max;

            public Interval(double min, double max) {
                this.min = min;
                this.max = max;
            }

            public double getMin() {
                return this.min;
            }

            public double getMax() {
                return this.max;
            }
        }
    }
}

