/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.pdfa;

import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.log.Counter;
import cfca.sadk.com.itextpdf.kernel.log.CounterFactory;
import cfca.sadk.com.itextpdf.kernel.pdf.IsoKey;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfOutputIntent;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfResources;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfStream;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfVersion;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import cfca.sadk.com.itextpdf.kernel.pdf.StampingProperties;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import cfca.sadk.com.itextpdf.kernel.pdf.tagutils.TagStructureContext;
import cfca.sadk.com.itextpdf.kernel.xmp.XMPException;
import cfca.sadk.com.itextpdf.kernel.xmp.XMPMeta;
import cfca.sadk.com.itextpdf.kernel.xmp.XMPMetaFactory;
import cfca.sadk.com.itextpdf.kernel.xmp.XMPUtils;
import cfca.sadk.com.itextpdf.pdfa.PdfAConformanceException;
import cfca.sadk.com.itextpdf.pdfa.checker.PdfA1Checker;
import cfca.sadk.com.itextpdf.pdfa.checker.PdfA2Checker;
import cfca.sadk.com.itextpdf.pdfa.checker.PdfA3Checker;
import cfca.sadk.com.itextpdf.pdfa.checker.PdfAChecker;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfADocument
extends PdfDocument {
    private static final long serialVersionUID = -5908390625367471894L;
    protected PdfAChecker checker;

    public PdfADocument(PdfWriter writer, PdfAConformanceLevel conformanceLevel, PdfOutputIntent outputIntent) {
        super(writer);
        this.setChecker(conformanceLevel);
        this.addOutputIntent(outputIntent);
    }

    public PdfADocument(PdfReader reader, PdfWriter writer) {
        this(reader, writer, new StampingProperties());
    }

    public PdfADocument(PdfReader reader, PdfWriter writer, StampingProperties properties) {
        super(reader, writer, properties);
        XMPMeta meta;
        byte[] existingXmpMetadata = this.getXmpMetadata();
        if (existingXmpMetadata == null) {
            throw new PdfAConformanceException("Document to read from shall be a pdfa conformant file with valid xmp metadata");
        }
        try {
            meta = XMPMetaFactory.parseFromBuffer(existingXmpMetadata);
        }
        catch (XMPException exc) {
            throw new PdfAConformanceException("Document to read from shall be a pdfa conformant file with valid xmp metadata");
        }
        PdfAConformanceLevel conformanceLevel = PdfAConformanceLevel.getConformanceLevel(meta);
        if (conformanceLevel == null) {
            throw new PdfAConformanceException("Document to read from shall be a pdfa conformant file with valid xmp metadata");
        }
        this.setChecker(conformanceLevel);
    }

    @Override
    public void checkIsoConformance(Object obj, IsoKey key) {
        this.checkIsoConformance(obj, key, null);
    }

    @Override
    public void checkShowTextIsoConformance(Object obj, PdfResources resources) {
        CanvasGraphicsState gState = (CanvasGraphicsState)obj;
        boolean fill = false;
        boolean stroke = false;
        switch (gState.getTextRenderingMode()) {
            case 1: 
            case 5: {
                stroke = true;
                break;
            }
            case 0: 
            case 4: {
                fill = true;
                break;
            }
            case 2: 
            case 6: {
                stroke = true;
                fill = true;
            }
        }
        IsoKey drawMode = IsoKey.DRAWMODE_FILL;
        if (fill && stroke) {
            drawMode = IsoKey.DRAWMODE_FILL_STROKE;
        } else if (fill) {
            drawMode = IsoKey.DRAWMODE_FILL;
        } else if (stroke) {
            drawMode = IsoKey.DRAWMODE_STROKE;
        }
        if (fill || stroke) {
            this.checkIsoConformance(gState, drawMode, resources);
        }
    }

    @Override
    public void checkIsoConformance(Object obj, IsoKey key, PdfResources resources) {
        PdfDictionary currentColorSpaces = null;
        if (resources != null) {
            currentColorSpaces = ((PdfDictionary)resources.getPdfObject()).getAsDictionary(PdfName.ColorSpace);
        }
        switch (key) {
            case CANVAS_STACK: {
                this.checker.checkCanvasStack(((Character)obj).charValue());
                break;
            }
            case PDF_OBJECT: {
                this.checker.checkPdfObject((PdfObject)obj);
                break;
            }
            case RENDERING_INTENT: {
                this.checker.checkRenderingIntent((PdfName)obj);
                break;
            }
            case INLINE_IMAGE: {
                this.checker.checkInlineImage((PdfStream)obj, currentColorSpaces);
                break;
            }
            case GRAPHIC_STATE_ONLY: {
                CanvasGraphicsState gState = (CanvasGraphicsState)obj;
                this.checker.checkExtGState(gState);
                break;
            }
            case DRAWMODE_FILL: {
                CanvasGraphicsState gState = (CanvasGraphicsState)obj;
                this.checker.checkColor(gState.getFillColor(), currentColorSpaces, true);
                this.checker.checkExtGState(gState);
                break;
            }
            case DRAWMODE_STROKE: {
                CanvasGraphicsState gState = (CanvasGraphicsState)obj;
                this.checker.checkColor(gState.getStrokeColor(), currentColorSpaces, false);
                this.checker.checkExtGState(gState);
                break;
            }
            case DRAWMODE_FILL_STROKE: {
                CanvasGraphicsState gState = (CanvasGraphicsState)obj;
                this.checker.checkColor(gState.getFillColor(), currentColorSpaces, true);
                this.checker.checkColor(gState.getStrokeColor(), currentColorSpaces, false);
                this.checker.checkExtGState(gState);
                break;
            }
            case PAGE: {
                this.checker.checkSinglePage((PdfPage)obj);
                break;
            }
            case TAG_STRUCTURE_ELEMENT: {
                this.checker.checkTagStructureElement((PdfObject)obj);
            }
        }
    }

    public PdfAConformanceLevel getConformanceLevel() {
        return this.checker.getConformanceLevel();
    }

    @Override
    protected void addCustomMetadataExtensions(XMPMeta xmpMeta) {
        if (this.isTagged()) {
            try {
                XMPMeta taggedExtensionMeta = XMPMetaFactory.parseFromString("    <x:xmpmeta xmlns:x=\"adobe:ns:meta/\">\n      <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n        <rdf:Description rdf:about=\"\" xmlns:pdfaExtension=\"http://www.aiim.org/pdfa/ns/extension/\" xmlns:pdfaSchema=\"http://www.aiim.org/pdfa/ns/schema#\" xmlns:pdfaProperty=\"http://www.aiim.org/pdfa/ns/property#\">\n          <pdfaExtension:schemas>\n            <rdf:Bag>\n              <rdf:li rdf:parseType=\"Resource\">\n                <pdfaSchema:namespaceURI>http://www.aiim.org/pdfua/ns/id/</pdfaSchema:namespaceURI>\n                <pdfaSchema:prefix>pdfuaid</pdfaSchema:prefix>\n                <pdfaSchema:schema>PDF/UA identification schema</pdfaSchema:schema>\n                <pdfaSchema:property>\n                  <rdf:Seq>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:category>internal</pdfaProperty:category>\n                      <pdfaProperty:description>PDF/UA version identifier</pdfaProperty:description>\n                      <pdfaProperty:name>part</pdfaProperty:name>\n                      <pdfaProperty:valueType>Integer</pdfaProperty:valueType>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:category>internal</pdfaProperty:category>\n                      <pdfaProperty:description>PDF/UA amendment identifier</pdfaProperty:description>\n                      <pdfaProperty:name>amd</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:category>internal</pdfaProperty:category>\n                      <pdfaProperty:description>PDF/UA corrigenda identifier</pdfaProperty:description>\n                      <pdfaProperty:name>corr</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                    </rdf:li>\n                  </rdf:Seq>\n                </pdfaSchema:property>\n              </rdf:li>\n            </rdf:Bag>\n          </pdfaExtension:schemas>\n        </rdf:Description>\n      </rdf:RDF>\n    </x:xmpmeta>");
                XMPUtils.appendProperties(taggedExtensionMeta, xmpMeta, true, false);
            }
            catch (XMPException exc) {
                Logger logger = LoggerFactory.getLogger(PdfADocument.class);
                logger.error("Exception while updating XmpMetadata", (Throwable)exc);
            }
        }
    }

    @Override
    protected void updateXmpMetadata() {
        try {
            XMPMeta xmpMeta = this.updateDefaultXmpMetadata();
            xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", this.checker.getConformanceLevel().getPart());
            xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", this.checker.getConformanceLevel().getConformance());
            this.addCustomMetadataExtensions(xmpMeta);
            this.setXmpMetadata(xmpMeta);
        }
        catch (XMPException e) {
            Logger logger = LoggerFactory.getLogger(PdfADocument.class);
            logger.error("Exception while updating XmpMetadata", (Throwable)e);
        }
    }

    @Override
    protected void checkIsoConformance() {
        this.checker.checkDocument(this.catalog);
    }

    @Override
    protected void flushObject(PdfObject pdfObject, boolean canBeInObjStm) throws IOException {
        this.markObjectAsMustBeFlushed(pdfObject);
        if (this.isClosing || this.checker.objectIsChecked(pdfObject)) {
            super.flushObject(pdfObject, canBeInObjStm);
        }
    }

    @Override
    protected void flushFonts() {
        for (PdfFont pdfFont : this.getDocumentFonts()) {
            this.checker.checkFont(pdfFont);
        }
        super.flushFonts();
    }

    protected void setChecker(PdfAConformanceLevel conformanceLevel) {
        String part = conformanceLevel.getPart();
        if ("1".equals(part)) {
            this.checker = new PdfA1Checker(conformanceLevel);
        } else if ("2".equals(part)) {
            this.checker = new PdfA2Checker(conformanceLevel);
        } else if ("3".equals(part)) {
            this.checker = new PdfA3Checker(conformanceLevel);
        }
    }

    @Override
    protected void initTagStructureContext() {
        this.tagStructureContext = new TagStructureContext(this, PdfADocument.getPdfVersionForPdfA(this.checker.getConformanceLevel()));
    }

    @Override
    protected Counter getCounter() {
        return CounterFactory.getCounter(PdfADocument.class);
    }

    private static PdfVersion getPdfVersionForPdfA(PdfAConformanceLevel conformanceLevel) {
        String part = conformanceLevel.getPart();
        PdfVersion version = "1".equals(part) ? PdfVersion.PDF_1_4 : ("2".equals(part) ? PdfVersion.PDF_1_7 : ("3".equals(part) ? PdfVersion.PDF_1_7 : PdfVersion.PDF_1_4));
        return version;
    }
}

