/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf.security;

import cfca.com.itextpdf.text.pdf.security.VerificationException;
import cfca.sadk.org.bouncycastle.cert.ocsp.BasicOCSPResp;
import cfca.sadk.org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import cfca.sadk.org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import cfca.sadk.org.bouncycastle.tsp.TimeStampToken;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateVerification {
    public static String verifyCertificate(X509Certificate cert, Collection<CRL> crls, Calendar calendar) {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        if (cert.hasUnsupportedCriticalExtension()) {
            for (String oid : cert.getCriticalExtensionOIDs()) {
                if ("2.5.29.15".equals(oid) && cert.getKeyUsage()[0]) continue;
                try {
                    if ("2.5.29.37".equals(oid) && cert.getExtendedKeyUsage().contains("1.3.6.1.5.5.7.3.8")) {
                        continue;
                    }
                }
                catch (CertificateParsingException e) {
                    // empty catch block
                }
                return "Has unsupported critical extension";
            }
        }
        try {
            cert.checkValidity(calendar.getTime());
        }
        catch (Exception e) {
            return e.getMessage();
        }
        if (crls != null) {
            for (CRL crl : crls) {
                if (!crl.isRevoked(cert)) continue;
                return "Certificate revoked";
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static List<VerificationException> verifyCertificates(Certificate[] certs, KeyStore keystore, Collection<CRL> crls, Calendar calendar) {
        ArrayList<VerificationException> result = new ArrayList<VerificationException>();
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        for (int k = 0; k < certs.length; ++k) {
            int j;
            X509Certificate cert = (X509Certificate)certs[k];
            String err = CertificateVerification.verifyCertificate(cert, crls, calendar);
            if (err != null) {
                result.add(new VerificationException(cert, err));
            }
            try {
                Enumeration<String> aliases = keystore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (!keystore.isCertificateEntry(alias)) continue;
                    X509Certificate certStoreX509 = (X509Certificate)keystore.getCertificate(alias);
                    if (CertificateVerification.verifyCertificate(certStoreX509, crls, calendar) != null) continue;
                    {
                        catch (Exception ex) {}
                    }
                    try {
                        cert.verify(certStoreX509.getPublicKey());
                        return result;
                    }
                    catch (Exception e) {
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            for (j = 0; j < certs.length; ++j) {
                if (j == k) continue;
                X509Certificate certNext = (X509Certificate)certs[j];
                try {
                    cert.verify(certNext.getPublicKey());
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (j != certs.length) continue;
            result.add(new VerificationException(cert, "Cannot be verified against the KeyStore or the certificate chain"));
        }
        if (result.size() == 0) {
            result.add(new VerificationException(null, "Invalid state. Possible circular certificate chain"));
        }
        return result;
    }

    public static List<VerificationException> verifyCertificates(Certificate[] certs, KeyStore keystore, Calendar calendar) {
        return CertificateVerification.verifyCertificates(certs, keystore, null, calendar);
    }

    public static boolean verifyOcspCertificates(BasicOCSPResp ocsp, KeyStore keystore, String provider) {
        if (provider == null) {
            provider = "BC";
        }
        try {
            Enumeration<String> aliases = keystore.aliases();
            while (aliases.hasMoreElements()) {
                try {
                    String alias = aliases.nextElement();
                    if (!keystore.isCertificateEntry(alias)) continue;
                    X509Certificate certStoreX509 = (X509Certificate)keystore.getCertificate(alias);
                    if (!ocsp.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider(provider).build(certStoreX509.getPublicKey()))) continue;
                    return true;
                }
                catch (Exception ex) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean verifyTimestampCertificates(TimeStampToken ts, KeyStore keystore, String provider) {
        if (provider == null) {
            provider = "BC";
        }
        try {
            Enumeration<String> aliases = keystore.aliases();
            while (aliases.hasMoreElements()) {
                try {
                    String alias = aliases.nextElement();
                    if (!keystore.isCertificateEntry(alias)) continue;
                    X509Certificate certStoreX509 = (X509Certificate)keystore.getCertificate(alias);
                    ts.isSignatureValid(new JcaSimpleSignerInfoVerifierBuilder().setProvider(provider).build(certStoreX509));
                    return true;
                }
                catch (Exception ex) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

