/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk;

import cfca.com.itextpdf.text.BadElementException;
import cfca.com.itextpdf.text.Image;
import cfca.com.itextpdf.text.pdf.PdfName;
import cfca.com.itextpdf.text.pdf.security.DigestAlgorithms;
import cfca.com.itextpdf.text.pdf.security.ExternalDigest;
import cfca.com.itextpdf.text.pdf.security.ExternalSignature;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.seal.maker.util.SealExtracter;
import cfca.seal.sadk.cert.PdfX509Certificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class PrePdfSeal {
    private PrivateKey privateKey;
    private Certificate[] chain;
    private List<Image> imageList = new ArrayList<Image>();
    private List<byte[]> imageBytesList = new ArrayList<byte[]>();
    private int imageCount;
    private int crossPageStyle;
    private float imageScale;
    private boolean ifExternalContainer;
    private String hashAlgorithm = "SHA-1";
    private String encryptionAlgorithm = "RSA";
    private PdfName filter;
    private PdfName subFilter;
    private int deferredType;
    private ExternalDigest externalDigest;
    private ExternalSignature externalSignature;

    public int getDeferredType() {
        return this.deferredType;
    }

    public ExternalDigest getExternalDigest() {
        return this.externalDigest;
    }

    public ExternalSignature getExternalSignature() {
        return this.externalSignature;
    }

    public PrePdfSeal(byte[] keyFileBytes, String keyFilePassword, byte[] imageBytes, float imageScale, String encryptionAlgorithm, String hashAlgorithm) throws BadElementException, MalformedURLException, IOException, PKIException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.hashAlgorithm = hashAlgorithm;
        this.encryptionAlgorithm = encryptionAlgorithm;
        if ("SM2".equals(encryptionAlgorithm) && "SM3".equals(hashAlgorithm)) {
            this.initSM2KeyStore(keyFileBytes, keyFilePassword);
        } else if ("RSA".equals(encryptionAlgorithm) && null != DigestAlgorithms.getAllowedDigests(hashAlgorithm)) {
            this.initRSAKeyStore(keyFileBytes, keyFilePassword);
        } else {
            throw new NoSuchAlgorithmException("Unsupport encryption or hash algorithm!");
        }
        this.initImage(imageBytes, imageScale);
        this.crossPageStyle = 0;
        this.ifExternalContainer = false;
    }

    public PrePdfSeal(byte[] keyFileBytes, String keyFilePassword, String encryptionAlgorithm, String hashAlgorithm) throws BadElementException, MalformedURLException, IOException, PKIException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.hashAlgorithm = hashAlgorithm;
        this.encryptionAlgorithm = encryptionAlgorithm;
        if ("SM2".equals(encryptionAlgorithm) && "SM3".equals(hashAlgorithm)) {
            this.initSM2KeyStore(keyFileBytes, keyFilePassword);
        } else if ("RSA".equals(encryptionAlgorithm) && null != DigestAlgorithms.getAllowedDigests(hashAlgorithm)) {
            this.initRSAKeyStore(keyFileBytes, keyFilePassword);
        } else {
            throw new NoSuchAlgorithmException("Unsupport encryption or hash algorithm!");
        }
        this.crossPageStyle = 0;
        this.ifExternalContainer = false;
    }

    private void initImage(byte[] imageBytes, float imageScale) throws BadElementException, MalformedURLException, IOException {
        if (null == imageBytes || 0 == imageBytes.length) {
            this.imageCount = 0;
        } else {
            this.imageBytesList.add(imageBytes);
            this.imageList.add(Image.getInstance(imageBytes));
            this.imageCount = 1;
            this.imageScale = imageScale;
        }
    }

    private void initSM2KeyStore(byte[] sm2FileBytes, String sm2FilePassword) throws PKIException {
        this.privateKey = KeyUtil.getPrivateKeyFromSM2((byte[])sm2FileBytes, (String)sm2FilePassword);
        X509Cert x509Cert = CertUtil.getCertFromSM2((byte[])sm2FileBytes);
        PdfX509Certificate pdfX509Certificate = new PdfX509Certificate(x509Cert);
        this.chain = new PdfX509Certificate[]{pdfX509Certificate};
    }

    public PrePdfSeal(byte[] sealFileBytes, String sealFilePassword, float imageScale, String encryptionAlgorithm, String hashAlgorithm) throws PKIException, IOException, BadElementException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
        SealExtracter ex = new SealExtracter(sealFileBytes, sealFilePassword);
        byte[] imageBytes = ex.getImageData();
        this.imageBytesList.add(imageBytes);
        this.imageList.add(Image.getInstance(imageBytes));
        this.imageCount = 1;
        this.crossPageStyle = 0;
        this.imageScale = imageScale;
        byte[] p12FileData = ex.getPKCS12Data();
        int keyType = ex.getKeyType();
        if (1 == keyType) {
            this.initRSAKeyStore(p12FileData, sealFilePassword);
        } else if (2 == keyType) {
            this.initSM2KeyStore(p12FileData, sealFilePassword);
        }
        this.ifExternalContainer = false;
    }

    public String getSealEncryptionAlgorithm(byte[] sealFileBytes, String sealFilePassword) throws PKIException, IOException, NoSuchAlgorithmException {
        SealExtracter ex = new SealExtracter(sealFileBytes, sealFilePassword);
        int keyType = ex.getKeyType();
        if (1 == keyType) {
            return "RSA";
        }
        if (2 == keyType) {
            return "SM2";
        }
        throw new NoSuchAlgorithmException("Unsupported encryption algorithm!");
    }

    public PrePdfSeal(PrivateKey privateKey, Certificate[] chain, byte[] imageBytes, float imageScale, String encryptionAlgorithm, String hashAlgorithm) throws BadElementException, MalformedURLException, IOException, NoSuchAlgorithmException {
        this.hashAlgorithm = hashAlgorithm;
        this.encryptionAlgorithm = encryptionAlgorithm;
        if ("SM2".equals(encryptionAlgorithm) && "SM3".equals(hashAlgorithm)) {
            this.privateKey = privateKey;
            this.chain = chain;
        } else if ("RSA".equals(encryptionAlgorithm) && null != DigestAlgorithms.getAllowedDigests(hashAlgorithm)) {
            this.privateKey = privateKey;
            this.chain = chain;
        }
        this.initImage(imageBytes, imageScale);
        this.crossPageStyle = 0;
        this.ifExternalContainer = false;
    }

    public PrePdfSeal(PrivateKey privateKey, Certificate[] chain, byte[] imageBytes, float imageScale, String encryptionAlgorithm, String hashAlgorithm, int signDeferredType) throws BadElementException, MalformedURLException, IOException, NoSuchAlgorithmException {
        this.hashAlgorithm = hashAlgorithm;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.deferredType = signDeferredType;
        if (signDeferredType != 4) {
            if ("SM2".equals(encryptionAlgorithm) && "SM3".equals(hashAlgorithm)) {
                this.privateKey = privateKey;
                this.chain = chain;
            } else if ("RSA".equals(encryptionAlgorithm) && null != DigestAlgorithms.getAllowedDigests(hashAlgorithm)) {
                this.privateKey = privateKey;
                this.chain = chain;
            }
        } else {
            this.privateKey = null;
            chain = null;
        }
        this.initImage(imageBytes, imageScale);
        this.crossPageStyle = 0;
        this.ifExternalContainer = false;
    }

    public PrePdfSeal(PrivateKey privateKey, Certificate[] chain, String encryptionAlgorithm, String hashAlgorithm, int signDeferredType) throws BadElementException, MalformedURLException, IOException, NoSuchAlgorithmException {
        this.hashAlgorithm = hashAlgorithm;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.deferredType = signDeferredType;
        if (signDeferredType != 4) {
            if ("SM2".equals(encryptionAlgorithm) && "SM3".equals(hashAlgorithm)) {
                this.privateKey = privateKey;
                this.chain = chain;
            } else if ("RSA".equals(encryptionAlgorithm) && null != DigestAlgorithms.getAllowedDigests(hashAlgorithm)) {
                this.privateKey = privateKey;
                this.chain = chain;
            }
        } else {
            this.privateKey = null;
            chain = null;
        }
        this.crossPageStyle = 0;
        this.ifExternalContainer = false;
    }

    public PrePdfSeal(PdfName filter, PdfName subFilter, ExternalDigest externalDigest, ExternalSignature externalSignature, byte[] imageBytes, float imageScale, String encryptionAlgorithm, String hashAlgorithm, int deferredType) throws BadElementException, MalformedURLException, IOException {
        this.filter = filter;
        this.subFilter = subFilter;
        this.externalDigest = externalDigest;
        this.externalSignature = externalSignature;
        this.initImage(imageBytes, imageScale);
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
        this.deferredType = deferredType;
        this.crossPageStyle = 0;
        this.ifExternalContainer = true;
    }

    public PrePdfSeal(PdfName filter, PdfName subFilter, ExternalDigest externalDigest, ExternalSignature externalSignature, String encryptionAlgorithm, String hashAlgorithm, int deferredType) throws BadElementException, MalformedURLException, IOException {
        this.filter = filter;
        this.subFilter = subFilter;
        this.externalDigest = externalDigest;
        this.externalSignature = externalSignature;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
        this.deferredType = deferredType;
        this.crossPageStyle = 0;
        this.ifExternalContainer = true;
    }

    public PdfName getFilter() {
        return this.filter;
    }

    public PdfName getSubFilter() {
        return this.subFilter;
    }

    private void initRSAKeyStore(byte[] pfxFileData, String pfxOrSealFilePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ByteArrayInputStream is = new ByteArrayInputStream(pfxFileData);
        char[] passwordCharArray = pfxOrSealFilePassword.toCharArray();
        ks.load(is, passwordCharArray);
        Enumeration<String> iter = ks.aliases();
        String keyAilas = null;
        while (iter.hasMoreElements() && !ks.isKeyEntry(keyAilas = iter.nextElement())) {
        }
        this.privateKey = (PrivateKey)ks.getKey(keyAilas, passwordCharArray);
        this.chain = ks.getCertificateChain(keyAilas);
    }

    public boolean IfExternalContainer() {
        return this.ifExternalContainer;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public Certificate[] getCertificateChain() {
        return this.chain;
    }

    public void setCertificateChain(Certificate[] chain) {
        this.chain = chain;
    }

    public void addImage(byte[] imageBytes, int imageIndex, int crossPageStyle) throws BadElementException, MalformedURLException, IOException {
        this.crossPageStyle = crossPageStyle;
        if (0 == crossPageStyle) {
            throw new BadElementException("only for cross page operation!");
        }
        if (2 == crossPageStyle || 1 == crossPageStyle) {
            if (imageIndex < 3) {
                this.imageBytesList.add(imageIndex, imageBytes);
                this.imageList.add(imageIndex, Image.getInstance(imageBytes));
                this.imageCount = imageIndex + 1;
            }
        } else {
            this.imageBytesList.add(imageIndex, imageBytes);
            this.imageList.add(imageIndex, Image.getInstance(imageBytes));
            this.imageCount = imageIndex + 1;
        }
    }

    public int getImageCount() {
        return this.imageCount;
    }

    public int getCrossPageStyle() {
        return this.crossPageStyle;
    }

    public Image getImage(int imageIndex) throws BadElementException {
        if (this.imageCount == 0) {
            return null;
        }
        if (0 == this.crossPageStyle && imageIndex > 0) {
            throw new BadElementException("param imageIndex must be 0 when not cross page seal!");
        }
        if ((2 == this.crossPageStyle || 1 == this.crossPageStyle) && imageIndex > 0) {
            imageIndex = 2 - imageIndex % 2;
        }
        return this.imageList.get(imageIndex);
    }

    public byte[] getImageAsBytes(int imageIndex) throws BadElementException {
        if (this.imageCount == 0) {
            return null;
        }
        if (0 == this.crossPageStyle && imageIndex > 0) {
            throw new BadElementException("param imageIndex must be 0 when not cross page seal!");
        }
        if ((2 == this.crossPageStyle || 1 == this.crossPageStyle) && imageIndex > 0) {
            imageIndex = 2 - imageIndex % 2;
        }
        return this.imageBytesList.get(imageIndex);
    }

    public float getImageScale() {
        return this.imageScale;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static interface EncryptionAlgorithm {
        public static final String RSA = "RSA";
        public static final String SM2 = "SM2";
        public static final String RSA_CUSTOM_COMMBANK = "RSA_CUSTOM_COMMBANK";
    }

    public static interface HashAlgorithm {
        public static final String SHA1 = "SHA1";
        public static final String SHA256 = "SHA256";
        public static final String SHA384 = "SHA384";
        public static final String SHA512 = "SHA512";
        public static final String MD5 = "MD5";
        public static final String SHA_1 = "SHA-1";
        public static final String SHA_256 = "SHA-256";
        public static final String SHA_384 = "SHA-384";
        public static final String SHA_512 = "SHA-512";
        public static final String MD_5 = "MD-5";
        public static final String SM3 = "SM3";
    }
}

