/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.table.opentype;

import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.ClassDefTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.CoverageTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.SubstSubtable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.component.NumRecordList;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.contextsubst.DoubleRecordTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.contextsubst.SubClassSetArray;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.contextsubst.SubGenericRuleSet;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.contextsubst.SubRuleSetArray;

public class ContextSubst
extends SubstSubtable {
    private final SubRuleSetArray ruleSets;
    private SubClassSetArray classSets;

    ContextSubst(ReadableFontData data, int base, boolean dataIsCanonical) {
        super(data, base, dataIsCanonical);
        switch (this.format) {
            case 1: {
                this.ruleSets = new SubRuleSetArray(data, this.headerSize(), dataIsCanonical);
                this.classSets = null;
                break;
            }
            case 2: {
                this.ruleSets = null;
                this.classSets = new SubClassSetArray(data, this.headerSize(), dataIsCanonical);
                break;
            }
            default: {
                throw new IllegalStateException("Subt format value is " + this.format + " (should be 1 or 2).");
            }
        }
    }

    public SubRuleSetArray fmt1Table() {
        switch (this.format) {
            case 1: {
                return this.ruleSets;
            }
        }
        throw new IllegalArgumentException("unexpected format table requested: " + this.format);
    }

    public SubClassSetArray fmt2Table() {
        switch (this.format) {
            case 2: {
                return this.classSets;
            }
        }
        throw new IllegalArgumentException("unexpected format table requested: " + this.format);
    }

    public NumRecordList recordList() {
        return this.format == 1 ? this.ruleSets.recordList : this.classSets.recordList;
    }

    public SubGenericRuleSet<? extends DoubleRecordTable> subTableAt(int index) {
        return this.format == 1 ? (SubGenericRuleSet)this.ruleSets.subTableAt(index) : (SubGenericRuleSet)this.classSets.subTableAt(index);
    }

    public CoverageTable coverage() {
        return this.format == 1 ? this.ruleSets.coverage : this.classSets.coverage;
    }

    public ClassDefTable classDef() {
        return this.format == 2 ? this.classSets.classDef : null;
    }

    public static class Builder
    extends SubstSubtable.Builder<SubstSubtable> {
        private final SubRuleSetArray.Builder arrayBuilder;

        protected Builder() {
            this.arrayBuilder = new SubRuleSetArray.Builder();
        }

        protected Builder(ReadableFontData data, boolean dataIsCanonical) {
            super(data, dataIsCanonical);
            this.arrayBuilder = new SubRuleSetArray.Builder(data, dataIsCanonical);
        }

        protected Builder(SubstSubtable subTable) {
            ContextSubst ligSubst = (ContextSubst)subTable;
            this.arrayBuilder = new SubRuleSetArray.Builder(ligSubst.ruleSets);
        }

        @Override
        public int subDataSizeToSerialize() {
            return this.arrayBuilder.subDataSizeToSerialize();
        }

        @Override
        public int subSerialize(WritableFontData newData) {
            return this.arrayBuilder.subSerialize(newData);
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }

        @Override
        public void subDataSet() {
            this.arrayBuilder.subDataSet();
        }

        @Override
        public ContextSubst subBuildTable(ReadableFontData data) {
            return new ContextSubst(data, 0, true);
        }
    }
}

