/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.signatures;

import cfca.sadk.com.itextpdf.io.util.DateTimeUtil;
import cfca.sadk.com.itextpdf.io.util.MessageFormatUtil;
import cfca.sadk.com.itextpdf.signatures.CRLVerifier;
import cfca.sadk.com.itextpdf.signatures.CertificateUtil;
import cfca.sadk.com.itextpdf.signatures.CertificateVerifier;
import cfca.sadk.com.itextpdf.signatures.OcspClientBouncyCastle;
import cfca.sadk.com.itextpdf.signatures.RootStoreVerifier;
import cfca.sadk.com.itextpdf.signatures.SignUtils;
import cfca.sadk.com.itextpdf.signatures.VerificationException;
import cfca.sadk.com.itextpdf.signatures.VerificationOK;
import cfca.sadk.org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import cfca.sadk.org.bouncycastle.cert.ocsp.BasicOCSPResp;
import cfca.sadk.org.bouncycastle.cert.ocsp.CertificateStatus;
import cfca.sadk.org.bouncycastle.cert.ocsp.OCSPException;
import cfca.sadk.org.bouncycastle.cert.ocsp.SingleResp;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPVerifier
extends RootStoreVerifier {
    protected static final Logger LOGGER = LoggerFactory.getLogger(OCSPVerifier.class);
    protected static final String id_kp_OCSPSigning = "1.3.6.1.5.5.7.3.9";
    protected List<BasicOCSPResp> ocsps;

    public OCSPVerifier(CertificateVerifier verifier, List<BasicOCSPResp> ocsps) {
        super(verifier);
        this.ocsps = ocsps;
    }

    @Override
    public List<VerificationOK> verify(X509Certificate signCert, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException, IOException {
        ArrayList<VerificationOK> result = new ArrayList<VerificationOK>();
        int validOCSPsFound = 0;
        if (this.ocsps != null) {
            for (BasicOCSPResp ocspResp : this.ocsps) {
                if (!this.verify(ocspResp, signCert, issuerCert, signDate)) continue;
                ++validOCSPsFound;
            }
        }
        boolean online = false;
        if (this.onlineCheckingAllowed && validOCSPsFound == 0 && this.verify(this.getOcspResponse(signCert, issuerCert), signCert, issuerCert, signDate)) {
            ++validOCSPsFound;
            online = true;
        }
        LOGGER.info("Valid OCSPs found: " + validOCSPsFound);
        if (validOCSPsFound > 0) {
            result.add(new VerificationOK(signCert, this.getClass(), "Valid OCSPs Found: " + validOCSPsFound + (online ? " (online)" : "")));
        }
        if (this.verifier != null) {
            result.addAll(this.verifier.verify(signCert, issuerCert, signDate));
        }
        return result;
    }

    public boolean verify(BasicOCSPResp ocspResp, X509Certificate signCert, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException, IOException {
        if (ocspResp == null) {
            return false;
        }
        SingleResp[] resp = ocspResp.getResponses();
        for (int i = 0; i < resp.length; ++i) {
            CertificateStatus status;
            if (!signCert.getSerialNumber().equals(resp[i].getCertID().getSerialNumber())) continue;
            try {
                if (issuerCert == null) {
                    issuerCert = signCert;
                }
                if (!SignUtils.checkIfIssuersMatch(resp[i].getCertID(), issuerCert)) {
                    LOGGER.info("OCSP: Issuers doesn't match.");
                }
            }
            catch (OCSPException e) {}
            continue;
            if (resp[i].getNextUpdate() == null) {
                Date nextUpdate = SignUtils.add180Sec(resp[i].getThisUpdate());
                LOGGER.info(MessageFormatUtil.format("No 'next update' for OCSP Response; assuming {0}", nextUpdate));
                if (signDate.after(nextUpdate)) {
                    LOGGER.info(MessageFormatUtil.format("OCSP no longer valid: {0} after {1}", signDate, nextUpdate));
                    continue;
                }
            } else if (signDate.after(resp[i].getNextUpdate())) {
                LOGGER.info(MessageFormatUtil.format("OCSP no longer valid: {0} after {1}", signDate, resp[i].getNextUpdate()));
                continue;
            }
            if ((status = resp[i].getCertStatus()) != CertificateStatus.GOOD) continue;
            this.isValidResponse(ocspResp, issuerCert);
            return true;
        }
        return false;
    }

    public void isValidResponse(BasicOCSPResp ocspResp, X509Certificate issuerCert) throws GeneralSecurityException, IOException {
        X509Certificate responderCert = null;
        if (this.isSignatureValid(ocspResp, issuerCert)) {
            responderCert = issuerCert;
        }
        if (responderCert == null) {
            if (ocspResp.getCerts() != null) {
                Iterable<X509Certificate> certs = SignUtils.getCertsFromOcspResponse(ocspResp);
                Iterator<X509Certificate> iterator = certs.iterator();
                while (iterator.hasNext()) {
                    X509Certificate cert = iterator.next();
                    List<String> keyPurposes = null;
                    try {
                        keyPurposes = cert.getExtendedKeyUsage();
                        if (keyPurposes == null || !keyPurposes.contains(id_kp_OCSPSigning) || !this.isSignatureValid(ocspResp, cert)) continue;
                        responderCert = cert;
                        break;
                    }
                    catch (CertificateParsingException certificateParsingException) {
                    }
                }
                if (responderCert == null) {
                    throw new VerificationException(issuerCert, "OCSP response could not be verified");
                }
            } else {
                if (this.rootStore != null) {
                    try {
                        for (X509Certificate anchor : SignUtils.getCertificates(this.rootStore)) {
                            if (!this.isSignatureValid(ocspResp, anchor)) continue;
                            responderCert = anchor;
                            break;
                        }
                    }
                    catch (Exception e) {
                        responderCert = null;
                    }
                }
                if (responderCert == null) {
                    throw new VerificationException(issuerCert, "OCSP response could not be verified");
                }
            }
        }
        responderCert.verify(issuerCert.getPublicKey());
        if (responderCert.getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nocheck.getId()) == null) {
            CRL crl;
            try {
                crl = CertificateUtil.getCRL(responderCert);
            }
            catch (Exception ignored) {
                crl = null;
            }
            if (crl != null && crl instanceof X509CRL) {
                CRLVerifier crlVerifier = new CRLVerifier(null, null);
                crlVerifier.setRootStore(this.rootStore);
                crlVerifier.setOnlineCheckingAllowed(this.onlineCheckingAllowed);
                crlVerifier.verify((X509CRL)crl, responderCert, issuerCert, DateTimeUtil.getCurrentTimeDate());
                return;
            }
        }
        responderCert.checkValidity();
    }

    @Deprecated
    public boolean verifyResponse(BasicOCSPResp ocspResp, X509Certificate issuerCert) {
        try {
            this.isValidResponse(ocspResp, issuerCert);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isSignatureValid(BasicOCSPResp ocspResp, Certificate responderCert) {
        try {
            return SignUtils.isSignatureValid(ocspResp, responderCert, "BC");
        }
        catch (Exception e) {
            return false;
        }
    }

    public BasicOCSPResp getOcspResponse(X509Certificate signCert, X509Certificate issuerCert) {
        SingleResp[] resps;
        if (signCert == null && issuerCert == null) {
            return null;
        }
        OcspClientBouncyCastle ocsp = new OcspClientBouncyCastle(null);
        BasicOCSPResp ocspResp = ocsp.getBasicOCSPResp(signCert, issuerCert, null);
        if (ocspResp == null) {
            return null;
        }
        for (SingleResp resp : resps = ocspResp.getResponses()) {
            CertificateStatus status = resp.getCertStatus();
            if (status != CertificateStatus.GOOD) continue;
            return ocspResp;
        }
        return null;
    }
}

