/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.signatures;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.forms.PdfAcroForm;
import cfca.sadk.com.itextpdf.forms.fields.PdfFormField;
import cfca.sadk.com.itextpdf.io.font.PdfEncodings;
import cfca.sadk.com.itextpdf.io.source.RASInputStream;
import cfca.sadk.com.itextpdf.io.source.RandomAccessFileOrArray;
import cfca.sadk.com.itextpdf.io.source.RandomAccessSourceFactory;
import cfca.sadk.com.itextpdf.io.source.WindowRandomAccessSource;
import cfca.sadk.com.itextpdf.kernel.PdfException;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDate;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;
import cfca.sadk.com.itextpdf.signatures.PdfPKCS7;
import cfca.sadk.com.itextpdf.signatures.PdfSignature;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SignatureUtil {
    private static Logger businessLog = LoggerFactory.getLogger(SignatureUtil.class);
    private PdfDocument document;
    private PdfAcroForm acroForm;
    private Map<String, int[]> sigNames;
    private Map<String, PdfArray> sigByteRanges;
    private List<String> orderedSignatureNames;
    private int totalRevisions;

    public SignatureUtil(PdfDocument document) {
        this.document = document;
        this.acroForm = PdfAcroForm.getAcroForm(document, true);
    }

    public SignatureUtil(PdfDocument document, boolean isForVerify) {
        this.document = document;
        this.acroForm = PdfAcroForm.getAcroForm(document, false, isForVerify);
    }

    public PdfPKCS7 verifySignature(String name) {
        return this.verifySignature(name, null);
    }

    public PdfPKCS7 verifySignature(String name, String provider) {
        long start = System.currentTimeMillis();
        PdfSignature signature = this.getSignature(name);
        if (signature == null) {
            return null;
        }
        try {
            String location;
            PdfName sub = signature.getSubFilter();
            PdfString contents = signature.getContents();
            PdfPKCS7 pk = null;
            if (sub.equals(PdfName.Adbe_x509_rsa_sha1)) {
                PdfString cert = ((PdfDictionary)signature.getPdfObject()).getAsString(PdfName.Cert);
                if (cert == null) {
                    cert = ((PdfDictionary)signature.getPdfObject()).getAsArray(PdfName.Cert).getAsString(0);
                }
                pk = new PdfPKCS7(PdfEncodings.convertToBytes(contents.getValue(), null), cert.getValueBytes(), provider);
            } else {
                pk = new PdfPKCS7(PdfEncodings.convertToBytes(contents.getValue(), null), sub, provider);
            }
            long end = System.currentTimeMillis();
            this.checkAttack(signature, contents);
            long end1 = System.currentTimeMillis();
            businessLog.info("verifySignature checkAttack cost= " + (end1 - end) + " ms");
            this.updateByteRange(pk, signature);
            long end2 = System.currentTimeMillis();
            businessLog.info("verifySignature updateByteRange cost= " + (end2 - end1) + " ms");
            PdfString date = signature.getDate();
            if (date != null) {
                pk.setSignDate(PdfDate.decode(date.toString()));
            }
            String signName = signature.getName();
            pk.setSignName(signName);
            String reason = signature.getReason();
            if (reason != null) {
                pk.setReason(reason);
            }
            if ((location = signature.getLocation()) != null) {
                pk.setLocation(location);
            }
            PdfPKCS7 pdfPKCS7 = pk;
            return pdfPKCS7;
        }
        catch (Exception e) {
            throw new PdfException(e.getMessage(), e);
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("verifySignature construct PKCS7 cost= " + (end - start) + " ms");
        }
    }

    public PdfSignature getSignature(String name) {
        PdfDictionary sigDict = this.getSignatureDictionary(name);
        return sigDict != null ? new PdfSignature(sigDict) : null;
    }

    public PdfDictionary getSignatureDictionary(String name) {
        this.getSignatureNames();
        if (!this.sigNames.containsKey(name)) {
            return null;
        }
        PdfFormField field = this.acroForm.getField(name);
        PdfDictionary merged = (PdfDictionary)field.getPdfObject();
        return merged.getAsDictionary(PdfName.V);
    }

    private void updateByteRange(PdfPKCS7 pkcs7, PdfSignature signature) {
        PdfArray b = signature.getByteRange();
        RandomAccessFileOrArray rf = this.document.getReader().getSafeFile();
        InputStream rg = null;
        try {
            int rd;
            rg = new RASInputStream(new RandomAccessSourceFactory().createRanged(rf.createSourceView(), SignatureUtil.asLongArray(b)));
            byte[] buf = new byte[8192];
            while ((rd = rg.read(buf, 0, buf.length)) > 0) {
                pkcs7.update(buf, 0, rd);
            }
        }
        catch (Exception e) {
            throw new PdfException(e);
        }
        finally {
            try {
                if (rg != null) {
                    rg.close();
                }
            }
            catch (IOException e) {
                throw new PdfException(e);
            }
        }
    }

    public List<String> getSignatureNames() {
        if (this.sigNames != null) {
            return new ArrayList<String>(this.orderedSignatureNames);
        }
        this.sigNames = new HashMap<String, int[]>();
        this.sigByteRanges = new HashMap<String, PdfArray>();
        this.orderedSignatureNames = new ArrayList<String>();
        ArrayList<Object[]> sorter = new ArrayList<Object[]>();
        if (null == this.acroForm) {
            return this.orderedSignatureNames;
        }
        for (Map.Entry<String, PdfFormField> entry : this.acroForm.getFormFields(true).entrySet()) {
            int rangeSize;
            PdfString contents;
            PdfDictionary v;
            PdfFormField field = entry.getValue();
            PdfDictionary merged = (PdfDictionary)field.getPdfObject();
            if (!PdfName.Sig.equals(merged.get(PdfName.FT)) && !PdfName.Btn.equals(merged.get(PdfName.FT)) || (v = merged.getAsDictionary(PdfName.V)) == null || (contents = v.getAsString(PdfName.Contents)) == null) continue;
            contents.markAsUnencryptedObject();
            PdfArray ro = v.getAsArray(PdfName.ByteRange);
            if (ro == null || (rangeSize = ro.size()) < 2) continue;
            this.sigByteRanges.put(entry.getKey(), ro);
            int length = ro.getAsNumber(rangeSize - 1).intValue() + ro.getAsNumber(rangeSize - 2).intValue();
            sorter.add(new Object[]{entry.getKey(), new int[]{length, 0}});
        }
        Collections.sort(sorter, new SorterComparator());
        if (sorter.size() > 0) {
            try {
                this.totalRevisions = (long)((int[])((Object[])sorter.get(sorter.size() - 1))[1])[0] == this.document.getReader().getFileLength() ? sorter.size() : sorter.size() + 1;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (int k = 0; k < sorter.size(); ++k) {
                Object[] objs = (Object[])sorter.get(k);
                String name = (String)objs[0];
                int[] p = (int[])objs[1];
                p[1] = k + 1;
                this.sigNames.put(name, p);
                this.orderedSignatureNames.add(name);
            }
        }
        return new ArrayList<String>(this.orderedSignatureNames);
    }

    public List<String> getBlankSignatureNames() {
        this.getSignatureNames();
        ArrayList<String> sigs = new ArrayList<String>();
        for (Map.Entry<String, PdfFormField> entry : this.acroForm.getFormFields().entrySet()) {
            PdfFormField field = entry.getValue();
            PdfDictionary merged = (PdfDictionary)field.getPdfObject();
            if (!PdfName.Sig.equals(merged.getAsName(PdfName.FT)) || this.sigNames.containsKey(entry.getKey())) continue;
            sigs.add(entry.getKey());
        }
        return sigs;
    }

    public int getTotalRevisions() {
        this.getSignatureNames();
        return this.totalRevisions;
    }

    public int getRevision(String field) {
        this.getSignatureNames();
        field = this.getTranslatedFieldName(field);
        if (!this.sigNames.containsKey(field)) {
            return 0;
        }
        return this.sigNames.get(field)[1];
    }

    public String getTranslatedFieldName(String name) {
        String namex;
        if (this.acroForm.getXfaForm().isXfaPresent() && (namex = this.acroForm.getXfaForm().findFieldName(name)) != null) {
            name = namex;
        }
        return name;
    }

    public InputStream extractRevision(String field) throws IOException {
        this.getSignatureNames();
        if (!this.sigNames.containsKey(field)) {
            return null;
        }
        int length = this.sigNames.get(field)[0];
        RandomAccessFileOrArray raf = this.document.getReader().getSafeFile();
        return new RASInputStream(new WindowRandomAccessSource(raf.createSourceView(), 0L, length));
    }

    public boolean signatureCoversWholeDocument(String name) {
        this.getSignatureNames();
        if (!this.sigNames.containsKey(name)) {
            return false;
        }
        try {
            return (long)this.sigNames.get(name)[0] == this.document.getReader().getFileLength();
        }
        catch (IOException e) {
            throw new PdfException(e);
        }
    }

    public boolean doesSignatureFieldExist(String name) {
        return this.getBlankSignatureNames().contains(name) || this.getSignatureNames().contains(name);
    }

    public static long[] asLongArray(PdfArray pdfArray) {
        long[] rslt = new long[pdfArray.size()];
        for (int k = 0; k < rslt.length; ++k) {
            rslt[k] = pdfArray.getAsNumber(k).longValue();
        }
        return rslt;
    }

    public Map<String, int[]> getSigNames() {
        return this.sigNames;
    }

    public Map<String, PdfArray> getSigByteRanges() {
        return this.sigByteRanges;
    }

    private final void checkAttack(PdfSignature signature, PdfString contents) throws Exception {
        long[] byteArray = SignatureUtil.asLongArray(signature.getByteRange());
        if (byteArray.length != 4) {
            throw new Exception("ByteRange is wrong,PDF has been corrupted or tampered!");
        }
        long rangeA = byteArray[0];
        long rangeB = byteArray[1];
        long rangeC = byteArray[2];
        long rangeD = byteArray[3];
        if (rangeA != 0L || rangeB <= 0L || rangeC <= rangeB || rangeD <= 0L) {
            throw new Exception("ByteRange is wrong,PDF has been corrupted or tampered!");
        }
        long signatureLength = rangeC - (rangeA + rangeB) - 2L;
        if ((long)(contents.getValueBytes().length * 2) < signatureLength) {
            throw new Exception("SignatureWrappingAttack,PDF has been corrupted or tampered!");
        }
    }

    public PdfDocument getDocument() {
        return this.document;
    }

    public PdfAcroForm getAcroForm() {
        return this.acroForm;
    }

    private static class SorterComparator
    implements Comparator<Object[]> {
        private SorterComparator() {
        }

        @Override
        public int compare(Object[] o1, Object[] o2) {
            int n1 = ((int[])o1[1])[0];
            int n2 = ((int[])o2[1])[0];
            return n1 - n2;
        }
    }
}

