/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.styledxmlparser.jsoup.parser;

import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.helper.Validate;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.nodes.Attributes;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.nodes.Document;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.nodes.Element;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.parser.CharacterReader;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.parser.ParseErrorList;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.parser.Token;
import cfca.sadk.com.itextpdf.styledxmlparser.jsoup.parser.Tokeniser;
import java.util.ArrayList;

public abstract class TreeBuilder {
    CharacterReader reader;
    Tokeniser tokeniser;
    protected Document doc;
    protected ArrayList<Element> stack;
    protected String baseUri;
    Token currentToken;
    ParseErrorList errors;
    private Token.StartTag start = new Token.StartTag();
    private Token.EndTag end = new Token.EndTag();

    void initialiseParse(String input, String baseUri, ParseErrorList errors) {
        Validate.notNull(input, "String input must not be null");
        Validate.notNull(baseUri, "BaseURI must not be null");
        this.doc = new Document(baseUri);
        this.reader = new CharacterReader(input);
        this.errors = errors;
        this.tokeniser = new Tokeniser(this.reader, errors);
        this.stack = new ArrayList(32);
        this.baseUri = baseUri;
    }

    Document parse(String input, String baseUri) {
        return this.parse(input, baseUri, ParseErrorList.noTracking());
    }

    Document parse(String input, String baseUri, ParseErrorList errors) {
        this.initialiseParse(input, baseUri, errors);
        this.runParser();
        return this.doc;
    }

    protected void runParser() {
        Token token;
        do {
            token = this.tokeniser.read();
            this.process(token);
            token.reset();
        } while (token.type != Token.TokenType.EOF);
    }

    abstract boolean process(Token var1);

    protected boolean processStartTag(String name) {
        if (this.currentToken == this.start) {
            return this.process(new Token.StartTag().name(name));
        }
        return this.process(((Token.Tag)this.start.reset()).name(name));
    }

    public boolean processStartTag(String name, Attributes attrs) {
        if (this.currentToken == this.start) {
            return this.process(new Token.StartTag().nameAttr(name, attrs));
        }
        this.start.reset();
        this.start.nameAttr(name, attrs);
        return this.process(this.start);
    }

    protected boolean processEndTag(String name) {
        if (this.currentToken == this.end) {
            return this.process(new Token.EndTag().name(name));
        }
        return this.process(((Token.Tag)this.end.reset()).name(name));
    }

    protected Element currentElement() {
        int size = this.stack.size();
        return size > 0 ? this.stack.get(size - 1) : null;
    }
}

