/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.svg.renderers.impl;

import cfca.sadk.com.itextpdf.kernel.geom.AffineTransform;
import cfca.sadk.com.itextpdf.kernel.geom.NoninvertibleTransformException;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.styledxmlparser.css.util.CssUtils;
import cfca.sadk.com.itextpdf.svg.css.impl.SvgNodeRendererInheritanceResolver;
import cfca.sadk.com.itextpdf.svg.renderers.ISvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.SvgDrawContext;
import cfca.sadk.com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import org.slf4j.LoggerFactory;

public class UseSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null) {
            String normalizedName;
            String elementToReUse = (String)this.attributesAndStyles.get("xlink:href");
            if (elementToReUse == null) {
                elementToReUse = (String)this.attributesAndStyles.get("href");
            }
            if (elementToReUse != null && !elementToReUse.isEmpty() && this.isValidHref(elementToReUse) && !context.isIdUsedByUseTagBefore(normalizedName = this.normalizeName(elementToReUse))) {
                ISvgNodeRenderer template = context.getNamedObject(normalizedName);
                ISvgNodeRenderer namedObject = template == null ? null : template.createDeepCopy();
                SvgNodeRendererInheritanceResolver iresolver = new SvgNodeRendererInheritanceResolver();
                iresolver.applyInheritanceToSubTree(this, namedObject);
                if (namedObject != null) {
                    if (namedObject instanceof AbstractSvgNodeRenderer) {
                        ((AbstractSvgNodeRenderer)namedObject).setPartOfClipPath(this.partOfClipPath);
                    }
                    PdfCanvas currentCanvas = context.getCurrentCanvas();
                    float x = 0.0f;
                    float y = 0.0f;
                    if (this.attributesAndStyles.containsKey("x")) {
                        x = CssUtils.parseAbsoluteLength((String)this.attributesAndStyles.get("x"));
                    }
                    if (this.attributesAndStyles.containsKey("y")) {
                        y = CssUtils.parseAbsoluteLength((String)this.attributesAndStyles.get("y"));
                    }
                    AffineTransform inverseMatrix = null;
                    if (!CssUtils.compareFloats(x, 0.0f) || !CssUtils.compareFloats(y, 0.0f)) {
                        AffineTransform translation = AffineTransform.getTranslateInstance(x, y);
                        currentCanvas.concatMatrix(translation);
                        if (this.partOfClipPath) {
                            try {
                                inverseMatrix = translation.createInverse();
                            }
                            catch (NoninvertibleTransformException ex) {
                                LoggerFactory.getLogger(UseSvgNodeRenderer.class).warn("Non-invertible transformation matrix was used in a clipping path context. Clipped elements may show undefined behavior.", (Throwable)ex);
                            }
                        }
                    }
                    namedObject.setParent(this);
                    namedObject.draw(context);
                    namedObject.setParent(null);
                    if (inverseMatrix != null) {
                        currentCanvas.concatMatrix(inverseMatrix);
                    }
                }
            }
        }
    }

    @Override
    void postDraw(SvgDrawContext context) {
    }

    private boolean isValidHref(String name) {
        return name.startsWith("#");
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        UseSvgNodeRenderer copy = new UseSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }
}

