/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.com.itextpdf.forms.PdfAcroForm;
import cfca.sadk.com.itextpdf.forms.fields.PdfSignatureFormField;
import cfca.sadk.com.itextpdf.io.image.ImageData;
import cfca.sadk.com.itextpdf.io.image.ImageDataFactory;
import cfca.sadk.com.itextpdf.io.source.RASInputStream;
import cfca.sadk.com.itextpdf.io.util.StreamUtil;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.PdfKeywordCanvasProcessor;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.ILocationExtractionStrategy;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.ILocationMapExtractionStrategy;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.IPdfTextLocation;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.KeywordListLocationExtractionStrategy;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.KeywordLocationExtractionStrategy;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.OldKeywordLocationExtractionStrategy;
import cfca.sadk.com.itextpdf.signatures.SignatureUtil;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.seal.base.config.SysEnv;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.BytesUtil;
import cfca.sadk.seal.base.util.KMPUtil;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import cfca.sadk.seal.base.util.ParamsCheckUtil;
import cfca.sadk.seal.base.util.SVGUtil;
import cryptokit.jni.JNIInit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;

public class PDFUtil {
    private static Logger businessLog = LoggerFactory.getLogger(PDFUtil.class);
    private static final String[] INTEGER_RULE = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static final String[] REX_KEYWORD = new String[]{"\\", "$", "(", ")", "*", "+", ".", "[", "]", "?", "^", "{", "}", "|"};
    private static final int POUNDS_PER_INCH = 72;

    public static HashMap<Integer, List<Rectangle>> locationExtraction(InputStream inputStream, String keyword) throws SealException {
        try {
            PdfReader reader = new PdfReader(inputStream);
            return PDFUtil.locationExtraction(reader, keyword);
        }
        catch (Exception e) {
            businessLog.error("locationExtraction failed ", (Throwable)e);
            throw new SealException("locationExtraction failed ", e);
        }
    }

    private static HashMap<Integer, List<Rectangle>> locationExtraction(PdfReader reader, String keyword) throws SealException {
        return PDFUtil.locationExtraction(reader, keyword, true);
    }

    private static HashMap<Integer, List<Rectangle>> locationExtraction(PdfReader reader, String keyword, boolean replaceSpace) throws SealException {
        PdfDocument pdfDocument = null;
        try {
            HashMap<Integer, List<Rectangle>> rectanglesMap = new HashMap<Integer, List<Rectangle>>();
            pdfDocument = new PdfDocument(reader);
            int pages = pdfDocument.getNumberOfPages();
            String newKeyword = keyword;
            if (replaceSpace) {
                newKeyword = keyword.replaceAll(" ", "").replaceAll("\u00a0", "");
            }
            int[] kmpnext = KMPUtil.kmpnext(newKeyword);
            ILocationExtractionStrategy strategy = null;
            strategy = replaceSpace ? new KeywordLocationExtractionStrategy(newKeyword, kmpnext, keyword) : new OldKeywordLocationExtractionStrategy(newKeyword, kmpnext, keyword);
            PdfKeywordCanvasProcessor parser = new PdfKeywordCanvasProcessor(strategy);
            for (int i = 1; i <= pages; ++i) {
                PdfPage page = pdfDocument.getPage(i);
                List<Rectangle> rectangleCollection = PDFUtil.processPage(parser, page);
                ArrayList<Rectangle> newRectangleCollection = new ArrayList<Rectangle>();
                if (!rectangleCollection.isEmpty()) {
                    int size = rectangleCollection.size();
                    for (int j = 0; j < size; ++j) {
                        Rectangle originalRectangle = rectangleCollection.get(j);
                        PdfPage pdfPage = pdfDocument.getPage(i);
                        Rectangle newRectangle = PDFUtil.rectangleFromDocumentToView(pdfPage, originalRectangle);
                        newRectangleCollection.add(newRectangle);
                    }
                    rectanglesMap.put(i, newRectangleCollection);
                }
                parser.reset();
            }
            pdfDocument.close();
            HashMap<Integer, List<Rectangle>> hashMap = rectanglesMap;
            return hashMap;
        }
        catch (SealException e) {
            businessLog.error("locationExtraction failed ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("locationExtraction failed ", (Throwable)e);
            throw new SealException("locationExtraction failed ", e);
        }
        finally {
            if (pdfDocument != null) {
                pdfDocument.close();
            }
        }
    }

    public static HashMap<String, List<Rectangle>> mutiLocationExtraction(byte[] sourceData, List<String> keywordList) throws SealException {
        try {
            if (null == sourceData) {
                throw new SealException("sourceData is null");
            }
            PdfReader pdfReader = new PdfReader(sourceData);
            return PDFUtil.mutiLocationExtraction(pdfReader, keywordList);
        }
        catch (SealException e) {
            businessLog.error("locationExtraction failed ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("locationExtraction failed ", (Throwable)e);
            throw new SealException("locationExtraction failed ", e);
        }
    }

    public static HashMap<String, List<Rectangle>> mutiLocationExtraction(InputStream inputStream, List<String> keywordList) throws SealException {
        try {
            PdfReader reader = new PdfReader(inputStream);
            return PDFUtil.mutiLocationExtraction(reader, keywordList);
        }
        catch (Exception e) {
            businessLog.error("locationExtraction failed ", (Throwable)e);
            throw new SealException("locationExtraction failed ", e);
        }
    }

    private static HashMap<String, List<Rectangle>> mutiLocationExtraction(PdfReader reader, List<String> keywordList) throws SealException {
        PdfDocument pdfDocument = null;
        ArrayList<int[]> kmpList = new ArrayList<int[]>();
        HashMap<String, List<Rectangle>> mutiRectangleCollection = new HashMap<String, List<Rectangle>>();
        try {
            pdfDocument = new PdfDocument(reader);
            int pages = pdfDocument.getNumberOfPages();
            int[] kmpnext = null;
            for (int i = 0; i < keywordList.size(); ++i) {
                kmpnext = KMPUtil.kmpnext(keywordList.get(i));
                kmpList.add(kmpnext);
            }
            PdfKeywordCanvasProcessor parser = new PdfKeywordCanvasProcessor(new KeywordListLocationExtractionStrategy(keywordList, kmpList));
            for (int i = 1; i <= pages; ++i) {
                PdfPage page = pdfDocument.getPage(i);
                HashMap<String, List<Rectangle>> tmpMutiRectangleCollection = null;
                tmpMutiRectangleCollection = PDFUtil.mutiProcessPage(parser, page, i);
                for (String keyword : tmpMutiRectangleCollection.keySet()) {
                    List<Rectangle> oneKeywordList = tmpMutiRectangleCollection.get(keyword);
                    if (mutiRectangleCollection.containsKey(keyword)) {
                        mutiRectangleCollection.get(keyword).addAll(oneKeywordList);
                        continue;
                    }
                    mutiRectangleCollection.put(keyword, oneKeywordList);
                }
                parser.reset();
            }
            pdfDocument.close();
            HashMap<String, List<Rectangle>> hashMap = mutiRectangleCollection;
            return hashMap;
        }
        catch (Exception e) {
            businessLog.error("locationExtraction failed ", (Throwable)e);
            throw new SealException("locationExtraction failed ", e);
        }
        finally {
            if (pdfDocument != null) {
                pdfDocument.close();
            }
        }
    }

    private static Rectangle rectangleFromDocumentToView(PdfPage pdfPage, Rectangle rectDocument) {
        int rotationAngle = pdfPage.getRotation();
        if (0 == (rotationAngle %= 360)) {
            return rectDocument;
        }
        Rectangle pageSize = pdfPage.getPageSize();
        float width = pageSize.getWidth();
        float height = pageSize.getHeight();
        float llx = rectDocument.getLeft();
        float lly = rectDocument.getBottom();
        float urx = rectDocument.getRight();
        float ury = rectDocument.getTop();
        float[] llxy = PDFUtil.transformCoord(width, height, new float[]{llx, lly}, rotationAngle);
        llx = llxy[0];
        lly = llxy[1];
        float[] urxy = PDFUtil.transformCoord(width, height, new float[]{urx, ury}, rotationAngle);
        urx = urxy[0];
        ury = urxy[1];
        Rectangle rectView = new Rectangle(llx, lly, urx - llx, ury - lly);
        return rectView;
    }

    private static float[] transformCoord(float width, float height, float[] xy0, int rotationAngle) {
        float[] xy = new float[2];
        if (90 == rotationAngle) {
            float h = width;
            float k = 0.0f;
            float x0 = xy0[0] - h;
            float y0 = xy0[1] - k;
            float xcos = x0 * 0.0f;
            float ysin = y0 * 1.0f;
            xy[0] = xcos + ysin;
            float ycos = y0 * 0.0f;
            float xsin = x0 * 1.0f;
            xy[1] = ycos - xsin;
        } else if (180 == rotationAngle) {
            float xcos = xy0[0] * -1.0f;
            float ysin = xy0[1] * 0.0f;
            xy[0] = xcos + ysin;
            float ycos = xy0[1] * -1.0f;
            float xsin = xy0[0] * 0.0f;
            xy[1] = ycos - xsin;
            float h = -width;
            float k = 0.0f;
            xy[0] = xy[0] - h;
            xy[1] = xy[1] - k;
            h = 0.0f;
            k = -height;
            xy[0] = xy[0] - h;
            xy[1] = xy[1] - k;
        } else if (270 == rotationAngle) {
            float xcos = xy0[0] * 0.0f;
            float ysin = xy0[1] * -1.0f;
            xy[0] = xcos + ysin;
            float ycos = xy0[1] * 0.0f;
            float xsin = xy0[0] * -1.0f;
            xy[1] = ycos - xsin;
            float h = -height;
            float k = 0.0f;
            xy[0] = xy[0] - h;
            xy[1] = xy[1] - k;
        }
        return xy;
    }

    public static HashMap<Integer, List<Rectangle>> locationExtraction(byte[] sourceData, String keyword) throws SealException {
        try {
            PdfReader pdfReader = new PdfReader(sourceData);
            return PDFUtil.locationExtraction(pdfReader, keyword);
        }
        catch (IOException e) {
            businessLog.error("locationExtraction failed ", (Throwable)e);
            throw new SealException("locationExtraction failed ", e);
        }
    }

    public static HashMap<Integer, List<Rectangle>> locationExtraction(byte[] sourceData, byte[] openPassword, String keyword, boolean replaceSpace) throws SealException {
        try {
            PdfReader pdfReader = new PdfReader(sourceData);
            if (null != openPassword) {
                pdfReader.setOpenPassword(openPassword);
            }
            return PDFUtil.locationExtraction(pdfReader, keyword, replaceSpace);
        }
        catch (IOException e) {
            businessLog.error("locationExtraction failed ", (Throwable)e);
            throw new SealException("locationExtraction failed ", e);
        }
    }

    public static HashMap<Integer, List<Rectangle>> locationExtraction(byte[] sourceData, byte[] openPassword, String keyword) throws SealException {
        try {
            PdfReader pdfReader = new PdfReader(sourceData);
            if (null != openPassword) {
                pdfReader.setOpenPassword(openPassword);
            }
            return PDFUtil.locationExtraction(pdfReader, keyword);
        }
        catch (IOException e) {
            businessLog.error("locationExtraction failed ", (Throwable)e);
            throw new SealException("locationExtraction failed ", e);
        }
    }

    public static HashMap<Integer, List<Rectangle>> locationExtraction(byte[] sourceData, byte[] openPassword, String keyword, int pageNum) throws SealException {
        return PDFUtil.locationExtraction(sourceData, openPassword, keyword, pageNum, true);
    }

    public static HashMap<Integer, List<Rectangle>> locationExtraction(byte[] sourceData, byte[] openPassword, String keyword, int pageNum, boolean replaceSpace) throws SealException {
        try {
            PdfReader pdfReader = new PdfReader(sourceData);
            if (null != openPassword) {
                pdfReader.setOpenPassword(openPassword);
            }
            List<Rectangle> keywordPositions = PDFUtil.locationExtraction(pdfReader, keyword, pageNum, replaceSpace);
            HashMap<Integer, List<Rectangle>> positionMap = new HashMap<Integer, List<Rectangle>>();
            positionMap.put(pageNum, keywordPositions);
            return positionMap;
        }
        catch (IOException e) {
            businessLog.error("locationExtraction failed ", (Throwable)e);
            throw new SealException("locationExtraction failed ", e);
        }
    }

    public static HashMap<String, List<Rectangle>> mutiLocationsExtraction(byte[] sourceData, List<String> keywordList) throws SealException {
        return PDFUtil.mutiLocationExtraction(sourceData, keywordList);
    }

    public static HashMap<Integer, List<Rectangle>> locationExtraction(InputStream inputStream, String keyword, int startPage, int endPage) throws SealException {
        PdfDocument document = null;
        try {
            PdfReader reader = new PdfReader(inputStream);
            document = new PdfDocument(reader);
            HashMap<Integer, List<Rectangle>> keywordsMap = PDFUtil.locationExtraction(document, keyword, startPage, endPage);
            document.close();
            HashMap<Integer, List<Rectangle>> hashMap = keywordsMap;
            return hashMap;
        }
        catch (Exception e) {
            businessLog.error("locationExtraction failed ", (Throwable)e);
            throw new SealException("locationExtraction failed ", e);
        }
        finally {
            if (null != document) {
                document.close();
            }
        }
    }

    public static HashMap<Integer, List<Rectangle>> locationExtraction(PdfDocument pdfDocument, String keyword, int startPage, int endPage) throws SealException {
        return PDFUtil.locationExtraction(pdfDocument, keyword, startPage, endPage, null, true);
    }

    public static HashMap<Integer, List<Rectangle>> locationExtraction(PdfDocument pdfDocument, String keyword, int startPage, int endPage, boolean replaceSpace) throws SealException {
        return PDFUtil.locationExtraction(pdfDocument, keyword, startPage, endPage, null, replaceSpace);
    }

    public static HashMap<Integer, List<Rectangle>> locationExtraction(PdfDocument pdfDocument, String keyword, int startPage, int endPage, int[] pageArray, boolean replaceSpace) throws SealException {
        try {
            HashMap<Integer, List<Rectangle>> rectanglesMap = new HashMap<Integer, List<Rectangle>>();
            int totalPages = pdfDocument.getNumberOfPages();
            if (endPage == -1) {
                endPage = totalPages;
            }
            if (pageArray == null) {
                ParamsCheckUtil.checkPageNum(pdfDocument, startPage, endPage);
            }
            String newKeyword = keyword;
            if (replaceSpace) {
                newKeyword = keyword.replaceAll(" ", "").replaceAll("\u00a0", "");
            }
            int[] kmpnext = KMPUtil.kmpnext(newKeyword);
            ILocationExtractionStrategy strategy = null;
            strategy = replaceSpace ? new KeywordLocationExtractionStrategy(newKeyword, kmpnext, keyword) : new OldKeywordLocationExtractionStrategy(newKeyword, kmpnext, keyword);
            PdfKeywordCanvasProcessor parser = new PdfKeywordCanvasProcessor(strategy);
            if (pageArray == null) {
                PdfPage page;
                for (int i = startPage; i <= endPage && (page = pdfDocument.getPage(i)) != null; ++i) {
                    List<Rectangle> rectangleCollection = PDFUtil.processPage(parser, page);
                    if (!rectangleCollection.isEmpty()) {
                        rectanglesMap.put(i, rectangleCollection);
                    }
                    parser.reset();
                }
            } else {
                int onePageNum;
                PdfPage page;
                ParamsCheckUtil.checkPageNum(pdfDocument, pageArray);
                for (int j = 0; j < pageArray.length && (page = pdfDocument.getPage(onePageNum = pageArray[j])) != null; ++j) {
                    List<Rectangle> rectangleCollection = PDFUtil.processPage(parser, page);
                    if (!rectangleCollection.isEmpty()) {
                        rectanglesMap.put(onePageNum, rectangleCollection);
                    }
                    parser.reset();
                }
            }
            return rectanglesMap;
        }
        catch (SealException e) {
            businessLog.error("locationExtraction failed ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("locationExtraction failed ", (Throwable)e);
            throw new SealException("locationExtraction failed ", e);
        }
    }

    public static HashMap<Integer, List<Rectangle>> locationExtraction(PdfReader pdfReader, String keyword, int startPage, int endPage) throws SealException {
        PdfDocument pdfDocument = null;
        try {
            String methodName = MethodCostTimeUtil.recordStartTime("keyword locationExtraction total");
            pdfDocument = new PdfDocument(pdfReader, true);
            HashMap<Integer, List<Rectangle>> result = PDFUtil.locationExtraction(pdfDocument, keyword, startPage, endPage);
            MethodCostTimeUtil.recordEndTime(methodName);
            pdfDocument.close();
            HashMap<Integer, List<Rectangle>> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            businessLog.error("locationExtraction failed keyword=" + keyword, (Throwable)e);
            throw new SealException("locationExtraction failed keyword=" + keyword, e);
        }
        finally {
            if (pdfDocument != null) {
                pdfDocument.close();
            }
        }
    }

    public static HashMap<Integer, List<Rectangle>> locationExtraction(byte[] sourceData, String keyword, int startPage, int endPage, boolean repalceSpace) throws SealException {
        PdfDocument pdfDocument = null;
        try {
            String methodName = MethodCostTimeUtil.recordStartTime("keyword locationExtraction total");
            PdfReader pdfReader = new PdfReader(sourceData);
            pdfDocument = new PdfDocument(pdfReader, true);
            HashMap<Integer, List<Rectangle>> result = PDFUtil.locationExtraction(pdfDocument, keyword, startPage, endPage, repalceSpace);
            MethodCostTimeUtil.recordEndTime(methodName);
            pdfDocument.close();
            HashMap<Integer, List<Rectangle>> hashMap = result;
            return hashMap;
        }
        catch (IOException e) {
            businessLog.error("locationExtraction failed keyword=" + keyword, (Throwable)e);
            throw new SealException("locationExtraction failed keyword=" + keyword, e);
        }
        finally {
            if (pdfDocument != null) {
                pdfDocument.close();
            }
        }
    }

    public static HashMap<Integer, List<Rectangle>> locationExtraction(byte[] sourceData, String keyword, int startPage, int endPage, int[] pageArray, boolean repalceSpace) throws SealException {
        PdfDocument pdfDocument = null;
        try {
            String methodName = MethodCostTimeUtil.recordStartTime("keyword locationExtraction total");
            PdfReader pdfReader = new PdfReader(sourceData);
            pdfDocument = new PdfDocument(pdfReader, true);
            HashMap<Integer, List<Rectangle>> result = PDFUtil.locationExtraction(pdfDocument, keyword, startPage, endPage, pageArray, repalceSpace);
            MethodCostTimeUtil.recordEndTime(methodName);
            pdfDocument.close();
            HashMap<Integer, List<Rectangle>> hashMap = result;
            return hashMap;
        }
        catch (IOException e) {
            businessLog.error("locationExtraction failed keyword=" + keyword, (Throwable)e);
            throw new SealException("locationExtraction failed keyword=" + keyword, e);
        }
        finally {
            if (pdfDocument != null) {
                pdfDocument.close();
            }
        }
    }

    public static HashMap<Integer, List<Rectangle>> locationExtraction(byte[] sourceData, String keyword, int startPage, int endPage) throws SealException {
        PdfDocument pdfDocument = null;
        try {
            String methodName = MethodCostTimeUtil.recordStartTime("keyword locationExtraction total");
            PdfReader pdfReader = new PdfReader(sourceData);
            pdfDocument = new PdfDocument(pdfReader, true);
            HashMap<Integer, List<Rectangle>> result = PDFUtil.locationExtraction(pdfDocument, keyword, startPage, endPage);
            MethodCostTimeUtil.recordEndTime(methodName);
            pdfDocument.close();
            HashMap<Integer, List<Rectangle>> hashMap = result;
            return hashMap;
        }
        catch (IOException e) {
            businessLog.error("locationExtraction failed keyword=" + keyword, (Throwable)e);
            throw new SealException("locationExtraction failed keyword=" + keyword, e);
        }
        finally {
            if (pdfDocument != null) {
                pdfDocument.close();
            }
        }
    }

    public static List<Rectangle> locationExtraction(byte[] sourceData, String keyword, int pageNum) throws SealException {
        PdfReader pdfReader = null;
        try {
            pdfReader = new PdfReader(sourceData);
            return PDFUtil.locationExtraction(pdfReader, keyword, pageNum);
        }
        catch (IOException e) {
            businessLog.error("locationExtraction failed pageNum=" + pageNum, (Throwable)e);
            throw new SealException("locationExtraction failed pageNum=" + pageNum, e);
        }
    }

    public static List<Rectangle> locationExtraction(InputStream input, String keyword, int pageNum) throws SealException {
        try {
            return PDFUtil.locationExtraction(new PdfReader(input), keyword, pageNum);
        }
        catch (IOException e) {
            businessLog.error("locationExtraction failed pageNum=" + pageNum, (Throwable)e);
            throw new SealException("locationExtraction failed pageNum=" + pageNum, e);
        }
    }

    private static List<Rectangle> locationExtraction(PdfReader reader, String keyword, int pageNum) throws SealException {
        return PDFUtil.locationExtraction(reader, keyword, pageNum, true);
    }

    public static List<Rectangle> locationExtraction(PdfReader reader, String keyword, int pageNum, boolean replaceSpace) throws SealException {
        PdfDocument pdfDocument = null;
        try {
            pdfDocument = new PdfDocument(reader);
            ParamsCheckUtil.checkPageNum(pdfDocument, pageNum);
            PdfPage page = pdfDocument.getPage(pageNum);
            String newKeyword = keyword;
            if (replaceSpace) {
                newKeyword = keyword.replaceAll(" ", "").replaceAll("\u00a0", "");
            }
            int[] kmpnext = KMPUtil.kmpnext(newKeyword);
            ILocationExtractionStrategy strategy = null;
            strategy = replaceSpace ? new KeywordLocationExtractionStrategy(newKeyword, kmpnext, keyword) : new OldKeywordLocationExtractionStrategy(newKeyword, kmpnext, keyword);
            PdfKeywordCanvasProcessor parser = new PdfKeywordCanvasProcessor(strategy);
            List<Rectangle> rectangleCollection = PDFUtil.processPage(parser, page);
            ArrayList<Rectangle> newRectangleCollection = new ArrayList<Rectangle>();
            if (!rectangleCollection.isEmpty()) {
                int size = rectangleCollection.size();
                for (int j = 0; j < size; ++j) {
                    Rectangle originalRectangle = rectangleCollection.get(j);
                    Rectangle newRectangle = PDFUtil.rectangleFromDocumentToView(page, originalRectangle);
                    newRectangleCollection.add(newRectangle);
                }
            }
            parser.reset();
            ArrayList<Rectangle> arrayList = newRectangleCollection;
            return arrayList;
        }
        catch (Exception e) {
            businessLog.error("locationExtraction failed pageNum=" + pageNum, (Throwable)e);
            throw new SealException("locationExtraction failed pageNum=" + pageNum, e);
        }
        finally {
            if (pdfDocument != null) {
                pdfDocument.close();
            }
        }
    }

    public static List<Rectangle> processPage(ILocationExtractionStrategy strategy, PdfPage page) throws SealException {
        try {
            PdfKeywordCanvasProcessor parser = new PdfKeywordCanvasProcessor(strategy);
            parser.processPageContent(page);
            ArrayList<Rectangle> retval = new ArrayList<Rectangle>();
            for (IPdfTextLocation location : strategy.getResultantLocations()) {
                retval.add(location.getRectangle());
            }
            return retval;
        }
        catch (Exception e) {
            businessLog.error("processPage failed ", (Throwable)e);
            throw new SealException("processPage failed ", e);
        }
    }

    public static List<Rectangle> processPage(PdfKeywordCanvasProcessor parser, PdfPage page) throws SealException {
        try {
            parser.processPageContent(page);
            ArrayList<Rectangle> retval = new ArrayList<Rectangle>();
            ILocationExtractionStrategy strategy = (ILocationExtractionStrategy)parser.getEventListener();
            for (IPdfTextLocation location : strategy.getResultantLocations()) {
                retval.add(location.getRectangle());
            }
            return retval;
        }
        catch (Exception e) {
            businessLog.error("processPage failed ", (Throwable)e);
            throw new SealException("processPage failed ", e);
        }
    }

    public static HashMap<String, List<Rectangle>> mutiProcessPage(ILocationMapExtractionStrategy strategy, PdfPage page, int pageNum) throws SealException {
        try {
            PdfKeywordCanvasProcessor parser = new PdfKeywordCanvasProcessor(strategy);
            parser.processPageContent(page);
            HashMap<String, List<Rectangle>> keywordsLocations = new HashMap<String, List<Rectangle>>();
            HashMap<String, List<IPdfTextLocation>> map = strategy.getResultantLocations();
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                ArrayList<Rectangle> retval = new ArrayList<Rectangle>();
                String keyword = iterator.next();
                List<IPdfTextLocation> locations = map.get(keyword);
                for (IPdfTextLocation location : locations) {
                    Rectangle newRectangle = PDFUtil.rectangleFromDocumentToView(page, location.getRectangle());
                    newRectangle.setPageNum(pageNum);
                    retval.add(newRectangle);
                }
                keywordsLocations.put(keyword, retval);
            }
            return keywordsLocations;
        }
        catch (Exception e) {
            businessLog.error("processPage failed ", (Throwable)e);
            throw new SealException("processPage failed ", e);
        }
    }

    public static HashMap<String, List<Rectangle>> mutiProcessPage(PdfKeywordCanvasProcessor parser, PdfPage page, int pageNum) throws SealException {
        try {
            ILocationMapExtractionStrategy strategy = (ILocationMapExtractionStrategy)parser.getEventListener();
            parser.processPageContent(page);
            HashMap<String, List<Rectangle>> keywordsLocations = new HashMap<String, List<Rectangle>>();
            HashMap<String, List<IPdfTextLocation>> map = strategy.getResultantLocations();
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                ArrayList<Rectangle> retval = new ArrayList<Rectangle>();
                String keyword = iterator.next();
                List<IPdfTextLocation> locations = map.get(keyword);
                for (IPdfTextLocation location : locations) {
                    Rectangle newRectangle = PDFUtil.rectangleFromDocumentToView(page, location.getRectangle());
                    newRectangle.setPageNum(pageNum);
                    retval.add(newRectangle);
                }
                keywordsLocations.put(keyword, retval);
            }
            return keywordsLocations;
        }
        catch (Exception e) {
            businessLog.error("processPage failed ", (Throwable)e);
            throw new SealException("processPage failed ", e);
        }
    }

    public static byte[] getSourceData(RASInputStream rg) throws Exception {
        int rd;
        ByteArrayOutputStream result = new ByteArrayOutputStream(65536);
        byte[] buf = new byte[65536];
        while ((rd = rg.read(buf, 0, buf.length)) > 0) {
            result.write(buf, 0, rd);
        }
        return result.toByteArray();
    }

    public static ImageData[] subImages(InputStream imgInputStream, String formatName, int n) throws IOException {
        ImageData[] nImage = new ImageData[n];
        ByteArrayOutputStream out = new ByteArrayOutputStream(65536);
        BufferedImage img = ImageIO.read(imgInputStream);
        int h = img.getHeight();
        int w = img.getWidth();
        int sw = w / n;
        for (int i = 0; i < n; ++i) {
            BufferedImage subImg = i == n - 1 ? img.getSubimage(i * sw, 0, w - i * sw, h) : img.getSubimage(i * sw, 0, sw, h);
            ImageIO.write((RenderedImage)subImg, formatName, out);
            nImage[i] = ImageDataFactory.create(out.toByteArray());
            out.flush();
            out.reset();
        }
        return nImage;
    }

    public static ArrayList<SplittedImage> splitImage(PdfDocument pdfDocument, InputStream inputStream, String format, int startPageNo, int endPageNo, int crosspageStyle) throws IOException {
        return PDFUtil.splitImage(pdfDocument, inputStream, format, startPageNo, endPageNo, crosspageStyle, 0, null);
    }

    public static ArrayList<SplittedImage> splitRectangle(PdfDocument pdfDocument, byte[] imageBytes, String format, int startPageNo, int endPageNo, int crosspageStyle, int pageRangeOption, int dpi, Rectangle rect) throws IOException {
        int step = 1;
        int pages = endPageNo - startPageNo + 1;
        if (pageRangeOption != 0) {
            step = 2;
            int oddNum = 0;
            int evenNum = 0;
            if (pageRangeOption == 1) {
                if (startPageNo % 2 == 0) {
                    ++startPageNo;
                }
            } else if (pageRangeOption == 2 && startPageNo % 2 != 0) {
                ++startPageNo;
            }
            for (int i = startPageNo; i <= endPageNo; ++i) {
                if (i % 2 == 0) {
                    ++evenNum;
                    continue;
                }
                ++oddNum;
            }
            if (pageRangeOption == 1) {
                pages = oddNum;
            } else if (pageRangeOption == 2) {
                pages = evenNum;
            }
        }
        ArrayList<SplittedImage> splittedImages = new ArrayList<SplittedImage>();
        int pixelsWidth = 0;
        int pixelsHeight = 0;
        int dpiX = SysEnv.getDefaultDPI();
        if (BytesUtil.isContainsBytes(imageBytes, "</svg>".getBytes("UTF8"))) {
            try {
                float[] svgRect = SVGUtil.getSVGPixel(imageBytes);
                pixelsWidth = (int)svgRect[0];
                pixelsHeight = (int)svgRect[1];
            }
            catch (Exception e) {
                businessLog.error("getSVGPixel failed:", (Throwable)e);
            }
        } else {
            BufferedImage bufImage = ImageIO.read(new ByteArrayInputStream(imageBytes));
            pixelsWidth = bufImage.getWidth();
            pixelsHeight = bufImage.getHeight();
            ImageData imageData = ImageDataFactory.create(imageBytes, true);
            dpiX = imageData.getDpiX();
        }
        dpiX = dpi <= 0 ? (0 == dpiX ? SysEnv.getDefaultDPI() : dpiX) : dpi;
        float poundsWidth0 = (float)pixelsWidth / (float)dpiX * 72.0f;
        int poundsWidth = (int)(poundsWidth0 + 0.5f);
        float poundsHeight0 = (float)pixelsHeight / (float)dpiX * 72.0f;
        int poundsHeight = (int)(poundsHeight0 + 0.5f);
        if (!SysEnv.isUseDPIChangeSize() && rect != null) {
            float objectWidth = rect.getWidth();
            float objectHeight = rect.getHeight();
            float max = Math.max(objectWidth, objectHeight);
            float originRadio = poundsWidth / poundsHeight;
            float realRadio = objectWidth / objectHeight;
            poundsWidth = (int)rect.getWidth();
            poundsHeight = (int)rect.getHeight();
            if (!((double)Math.abs(originRadio - realRadio) < 1.0E-7)) {
                poundsWidth = (int)max;
                poundsHeight = (int)(max * originRadio);
            }
            dpiX = (int)(poundsWidth0 / max * (float)dpiX);
        }
        switch (crosspageStyle) {
            case 2: {
                float x;
                float splittedPoundsWidth = poundsWidth0 / 2.0f;
                for (int i = startPageNo; i < endPageNo; ++i) {
                    SplittedImage splittedImage = new SplittedImage();
                    splittedImage.pageNo = i;
                    PdfPage pdfPage = pdfDocument.getPage(i);
                    Rectangle pageRect = pdfPage.getPageSizeWithRotation();
                    x = pageRect.getWidth() - splittedPoundsWidth;
                    float y = (pageRect.getHeight() - (float)poundsHeight) / 2.0f;
                    float width = splittedPoundsWidth;
                    float height = poundsHeight;
                    splittedImage.imageRect = new Rectangle(x, y, width, height);
                    splittedImages.add(splittedImage);
                    splittedImage = new SplittedImage();
                    splittedImage.pageNo = i + 1;
                    pdfPage = pdfDocument.getPage(i + 1);
                    pageRect = pdfPage.getPageSizeWithRotation();
                    x = 0.0f;
                    y = (pageRect.getHeight() - (float)poundsHeight) / 2.0f;
                    width = splittedPoundsWidth;
                    height = poundsHeight;
                    splittedImage.imageRect = new Rectangle(x, y, width, height);
                    splittedImages.add(splittedImage);
                }
                break;
            }
            case 4: {
                float x;
                int n = (endPageNo - startPageNo) * 2;
                float splittedPoundsWidth = poundsWidth0 / (float)n;
                boolean j = false;
                for (int i = startPageNo; i < endPageNo; ++i) {
                    SplittedImage splittedImage = new SplittedImage();
                    splittedImage.pageNo = i;
                    PdfPage pdfPage = pdfDocument.getPage(i);
                    Rectangle pageRect = pdfPage.getPageSizeWithRotation();
                    x = pageRect.getWidth() - splittedPoundsWidth;
                    float y = (pageRect.getHeight() - (float)poundsHeight) / 2.0f;
                    float width = splittedPoundsWidth;
                    float height = poundsHeight;
                    splittedImage.imageRect = new Rectangle(x, y, width, height);
                    splittedImages.add(splittedImage);
                    splittedImage = new SplittedImage();
                    splittedImage.pageNo = i + 1;
                    pdfPage = pdfDocument.getPage(i + 1);
                    pageRect = pdfPage.getPageSizeWithRotation();
                    x = 0.0f;
                    y = (pageRect.getHeight() - (float)poundsHeight) / 2.0f;
                    width = splittedPoundsWidth;
                    height = poundsHeight;
                    splittedImage.imageRect = new Rectangle(x, y, width, height);
                    splittedImages.add(splittedImage);
                }
                break;
            }
            case 1: {
                float x;
                float splittedPoundsHeight = poundsHeight0 / 2.0f;
                for (int i = startPageNo; i < endPageNo; ++i) {
                    SplittedImage splittedImage = new SplittedImage();
                    splittedImage.pageNo = i;
                    PdfPage pdfPage = pdfDocument.getPage(i);
                    Rectangle pageRect = pdfPage.getPageSizeWithRotation();
                    x = (pageRect.getWidth() - (float)poundsWidth) / 2.0f;
                    float y = 0.0f;
                    float width = poundsWidth;
                    float height = splittedPoundsHeight;
                    splittedImage.imageRect = new Rectangle(x, y, width, height);
                    splittedImages.add(splittedImage);
                    splittedImage = new SplittedImage();
                    splittedImage.pageNo = i + 1;
                    pdfPage = pdfDocument.getPage(i + 1);
                    pageRect = pdfPage.getPageSizeWithRotation();
                    x = (pageRect.getWidth() - (float)poundsWidth) / 2.0f;
                    y = pageRect.getHeight() - splittedPoundsHeight;
                    width = poundsWidth;
                    height = splittedPoundsHeight;
                    splittedImage.imageRect = new Rectangle(x, y, width, height);
                    splittedImages.add(splittedImage);
                }
                break;
            }
            case 8: {
                PDFUtil.splitRectangleX(pdfDocument, splittedImages, startPageNo, endPageNo, pages, step, poundsHeight, poundsWidth, dpiX, pixelsHeight, format, false, false);
                break;
            }
            case 7: {
                PDFUtil.splitRectangleX(pdfDocument, splittedImages, startPageNo, endPageNo, pages, step, poundsHeight, poundsWidth, dpiX, pixelsHeight, format, false, true);
                break;
            }
            case 3: {
                float x;
                int n = (endPageNo - startPageNo) * 2;
                float splittedPoundsHeight = poundsHeight0 / (float)n;
                boolean j = false;
                for (int i = startPageNo; i < endPageNo; ++i) {
                    SplittedImage splittedImage = new SplittedImage();
                    splittedImage.pageNo = i;
                    PdfPage pdfPage = pdfDocument.getPage(i);
                    Rectangle pageRect = pdfPage.getPageSizeWithRotation();
                    x = (pageRect.getWidth() - (float)poundsWidth) / 2.0f;
                    float y = 0.0f;
                    float width = poundsWidth;
                    float height = splittedPoundsHeight;
                    splittedImage.imageRect = new Rectangle(x, y, width, height);
                    splittedImages.add(splittedImage);
                    splittedImage = new SplittedImage();
                    splittedImage.pageNo = i + 1;
                    pdfPage = pdfDocument.getPage(i + 1);
                    pageRect = pdfPage.getPageSizeWithRotation();
                    x = (pageRect.getWidth() - (float)poundsWidth) / 2.0f;
                    y = pageRect.getHeight() - splittedPoundsHeight;
                    width = poundsWidth;
                    height = splittedPoundsHeight;
                    splittedImage.imageRect = new Rectangle(x, y, width, height);
                    splittedImages.add(splittedImage);
                }
                break;
            }
            case 5: {
                int n = pages;
                if (pageRangeOption != 2) {
                    PDFUtil.splitRectangle(pdfDocument, splittedImages, startPageNo, endPageNo, pages, step, poundsHeight, dpiX, pixelsWidth, format, false, true);
                    break;
                }
                PDFUtil.splitRectangle(pdfDocument, splittedImages, startPageNo, endPageNo, pages, step, poundsHeight, dpiX, pixelsWidth, format, true, true);
                break;
            }
            case 6: {
                int n = pages;
                if (pageRangeOption != 2) {
                    PDFUtil.splitRectangle(pdfDocument, splittedImages, startPageNo, endPageNo, pages, step, poundsHeight, dpiX, pixelsWidth, format, true, false);
                    break;
                }
                PDFUtil.splitRectangle(pdfDocument, splittedImages, startPageNo, endPageNo, pages, step, poundsHeight, dpiX, pixelsWidth, format, false, false);
                break;
            }
            default: {
                businessLog.error("Unsupportted cross page style!");
                throw new IOException("Unsupportted cross page style!");
            }
        }
        return splittedImages;
    }

    public static ArrayList<SplittedImage> splitImage(PdfDocument pdfDocument, InputStream inputStream, String format, int startPageNo, int endPageNo, int crosspageStyle, int pageRangeOption, int dpi, Rectangle rect) throws IOException {
        int step = 1;
        int pages = endPageNo - startPageNo + 1;
        if (pageRangeOption != 0) {
            step = 2;
            int oddNum = 0;
            int evenNum = 0;
            if (pageRangeOption == 1) {
                if (startPageNo % 2 == 0) {
                    ++startPageNo;
                }
            } else if (pageRangeOption == 2 && startPageNo % 2 != 0) {
                ++startPageNo;
            }
            for (int i = startPageNo; i <= endPageNo; ++i) {
                if (i % 2 == 0) {
                    ++evenNum;
                    continue;
                }
                ++oddNum;
            }
            if (pageRangeOption == 1) {
                pages = oddNum;
            } else if (pageRangeOption == 2) {
                pages = evenNum;
            }
        }
        ArrayList<SplittedImage> splittedImages = new ArrayList<SplittedImage>();
        byte[] imageBytes = StreamUtil.inputStreamToArray(inputStream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(65536);
        BufferedImage bufImage = ImageIO.read(new ByteArrayInputStream(imageBytes));
        ImageData imageData = ImageDataFactory.create(imageBytes, true);
        int dpiX = imageData.getDpiX();
        dpiX = dpi <= 0 ? (0 == dpiX ? SysEnv.getDefaultDPI() : dpiX) : dpi;
        int pixelsWidth = bufImage.getWidth();
        int pixelsHeight = bufImage.getHeight();
        float poundsWidth0 = (float)pixelsWidth / (float)dpiX * 72.0f;
        int poundsWidth = (int)(poundsWidth0 + 0.5f);
        float poundsHeight0 = (float)pixelsHeight / (float)dpiX * 72.0f;
        int poundsHeight = (int)(poundsHeight0 + 0.5f);
        switch (crosspageStyle) {
            case 2: {
                float splittedPoundsWidth = poundsWidth0 / 2.0f;
                float splittedPixelsWidth = pixelsWidth / 2;
                BufferedImage subImage = bufImage.getSubimage(0, 0, (int)(splittedPixelsWidth + 0.5f), pixelsHeight);
                ImageIO.write((RenderedImage)subImage, format, baos);
                byte[] leftHalfBytes = baos.toByteArray();
                baos.reset();
                subImage = bufImage.getSubimage((int)(splittedPixelsWidth + 0.5f), 0, (int)(splittedPixelsWidth + 0.5f), pixelsHeight);
                ImageIO.write((RenderedImage)subImage, format, baos);
                byte[] rightHalfBytes = baos.toByteArray();
                baos.reset();
                for (int i = startPageNo; i < endPageNo; ++i) {
                    SplittedImage splittedImage = new SplittedImage();
                    splittedImage.imageBytes = leftHalfBytes;
                    splittedImage.pageNo = i;
                    PdfPage pdfPage = pdfDocument.getPage(i);
                    Rectangle pageRect = pdfPage.getPageSizeWithRotation();
                    float x = pageRect.getWidth() - splittedPoundsWidth;
                    float y = (pageRect.getHeight() - (float)poundsHeight) / 2.0f;
                    float width = splittedPoundsWidth;
                    float height = poundsHeight;
                    splittedImage.imageRect = new Rectangle(x, y, width, height);
                    splittedImages.add(splittedImage);
                    splittedImage = new SplittedImage();
                    splittedImage.imageBytes = rightHalfBytes;
                    splittedImage.pageNo = i + 1;
                    pdfPage = pdfDocument.getPage(i + 1);
                    pageRect = pdfPage.getPageSizeWithRotation();
                    x = 0.0f;
                    y = (pageRect.getHeight() - (float)poundsHeight) / 2.0f;
                    width = splittedPoundsWidth;
                    height = poundsHeight;
                    splittedImage.imageRect = new Rectangle(x, y, width, height);
                    splittedImages.add(splittedImage);
                }
                break;
            }
            case 4: {
                int n = (endPageNo - startPageNo) * 2;
                float splittedPoundsWidth = poundsWidth0 / (float)n;
                float splittedPixelsWidth = pixelsWidth / n;
                int j = 0;
                for (int i = startPageNo; i < endPageNo; ++i) {
                    BufferedImage subImage = bufImage.getSubimage((int)(splittedPixelsWidth + 0.5f) * j++, 0, (int)(splittedPixelsWidth + 0.5f), pixelsHeight);
                    ImageIO.write((RenderedImage)subImage, format, baos);
                    byte[] stripeImageBytes = baos.toByteArray();
                    baos.reset();
                    SplittedImage splittedImage = new SplittedImage();
                    splittedImage.imageBytes = stripeImageBytes;
                    splittedImage.pageNo = i;
                    PdfPage pdfPage = pdfDocument.getPage(i);
                    Rectangle pageRect = pdfPage.getPageSizeWithRotation();
                    float x = pageRect.getWidth() - splittedPoundsWidth;
                    float y = (pageRect.getHeight() - (float)poundsHeight) / 2.0f;
                    float width = splittedPoundsWidth;
                    float height = poundsHeight;
                    splittedImage.imageRect = new Rectangle(x, y, width, height);
                    splittedImages.add(splittedImage);
                    subImage = bufImage.getSubimage((int)(splittedPixelsWidth + 0.5f) * j++, 0, (int)(splittedPixelsWidth + 0.5f), pixelsHeight);
                    ImageIO.write((RenderedImage)subImage, format, baos);
                    stripeImageBytes = baos.toByteArray();
                    baos.reset();
                    splittedImage = new SplittedImage();
                    splittedImage.imageBytes = stripeImageBytes;
                    splittedImage.pageNo = i + 1;
                    pdfPage = pdfDocument.getPage(i + 1);
                    pageRect = pdfPage.getPageSizeWithRotation();
                    x = 0.0f;
                    y = (pageRect.getHeight() - (float)poundsHeight) / 2.0f;
                    width = splittedPoundsWidth;
                    height = poundsHeight;
                    splittedImage.imageRect = new Rectangle(x, y, width, height);
                    splittedImages.add(splittedImage);
                }
                break;
            }
            case 1: {
                float splittedPoundsHeight = poundsHeight0 / 2.0f;
                float splittedPixelsHeight = pixelsHeight / 2;
                BufferedImage subImage = bufImage.getSubimage(0, 0, pixelsWidth, (int)(splittedPixelsHeight + 0.5f));
                ImageIO.write((RenderedImage)subImage, format, baos);
                byte[] upHalfBytes = baos.toByteArray();
                baos.reset();
                subImage = bufImage.getSubimage(0, (int)(splittedPixelsHeight + 0.5f), pixelsWidth, (int)(splittedPixelsHeight + 0.5f));
                ImageIO.write((RenderedImage)subImage, format, baos);
                byte[] downHalfBytes = baos.toByteArray();
                baos.reset();
                for (int i = startPageNo; i < endPageNo; ++i) {
                    SplittedImage splittedImage = new SplittedImage();
                    splittedImage.imageBytes = upHalfBytes;
                    splittedImage.pageNo = i;
                    PdfPage pdfPage = pdfDocument.getPage(i);
                    Rectangle pageRect = pdfPage.getPageSizeWithRotation();
                    float x = (pageRect.getWidth() - (float)poundsWidth) / 2.0f;
                    float y = 0.0f;
                    float width = poundsWidth;
                    float height = splittedPoundsHeight;
                    splittedImage.imageRect = new Rectangle(x, y, width, height);
                    splittedImages.add(splittedImage);
                    splittedImage = new SplittedImage();
                    splittedImage.imageBytes = downHalfBytes;
                    splittedImage.pageNo = i + 1;
                    pdfPage = pdfDocument.getPage(i + 1);
                    pageRect = pdfPage.getPageSizeWithRotation();
                    x = (pageRect.getWidth() - (float)poundsWidth) / 2.0f;
                    y = pageRect.getHeight() - splittedPoundsHeight;
                    width = poundsWidth;
                    height = splittedPoundsHeight;
                    splittedImage.imageRect = new Rectangle(x, y, width, height);
                    splittedImages.add(splittedImage);
                }
                break;
            }
            case 7: {
                int n = pages;
                float splittedPoundsHeight = poundsHeight0 / (float)n;
                int splitedWidth = 0;
                float floatSingleLength = (float)pixelsHeight / (float)pages;
                int singleLength = (int)Math.floor(floatSingleLength);
                int remainder = pixelsHeight % pages;
                int remainderPixel = 1;
                remainderPixel = remainder < pages ? 1 : remainder / pages;
                for (int i = startPageNo; i <= endPageNo; i += step) {
                    if (remainder > 0) {
                        remainder -= remainderPixel;
                    } else {
                        remainderPixel = 0;
                    }
                    if (i == startPageNo) {
                        splitedWidth = singleLength + remainderPixel;
                    }
                    BufferedImage subImage = PDFUtil.getSubImage(bufImage, singleLength + remainderPixel, false, pixelsWidth, pixelsHeight, false, splitedWidth);
                    ImageIO.write((RenderedImage)subImage, format, baos);
                    byte[] stripeImageBytes = baos.toByteArray();
                    baos.reset();
                    SplittedImage splittedImage = new SplittedImage();
                    splittedImage.imageBytes = stripeImageBytes;
                    splittedImage.pageNo = i;
                    PdfPage pdfPage = pdfDocument.getPage(i);
                    Rectangle pageRect = pdfPage.getPageSizeWithRotation();
                    int singlePixelsHeight = subImage.getHeight();
                    splitedWidth += singlePixelsHeight;
                    float x = (pageRect.getWidth() - (float)poundsWidth) / 2.0f;
                    float y = pageRect.getHeight();
                    float width = poundsWidth;
                    float height = splittedPoundsHeight;
                    splittedImage.imageRect = new Rectangle(x, y - height, width, height);
                    splittedImages.add(splittedImage);
                }
                break;
            }
            case 3: {
                int n = (endPageNo - startPageNo) * 2;
                float splittedPoundsHeight = poundsHeight0 / (float)n;
                float splittedPixelsHeight = pixelsHeight / n;
                int j = 0;
                for (int i = startPageNo; i < endPageNo; ++i) {
                    BufferedImage subImage = bufImage.getSubimage(0, (int)(splittedPixelsHeight + 0.5f) * j++, pixelsWidth, (int)(splittedPixelsHeight + 0.5f));
                    ImageIO.write((RenderedImage)subImage, format, baos);
                    byte[] stripeImageBytes = baos.toByteArray();
                    baos.reset();
                    SplittedImage splittedImage = new SplittedImage();
                    splittedImage.imageBytes = stripeImageBytes;
                    splittedImage.pageNo = i;
                    PdfPage pdfPage = pdfDocument.getPage(i);
                    Rectangle pageRect = pdfPage.getPageSizeWithRotation();
                    float x = (pageRect.getWidth() - (float)poundsWidth) / 2.0f;
                    float y = 0.0f;
                    float width = poundsWidth;
                    float height = splittedPoundsHeight;
                    splittedImage.imageRect = new Rectangle(x, y, width, height);
                    splittedImages.add(splittedImage);
                    subImage = bufImage.getSubimage(0, (int)(splittedPixelsHeight + 0.5f) * j++, pixelsWidth, (int)(splittedPixelsHeight + 0.5f));
                    ImageIO.write((RenderedImage)subImage, format, baos);
                    stripeImageBytes = baos.toByteArray();
                    baos.reset();
                    splittedImage = new SplittedImage();
                    splittedImage.imageBytes = stripeImageBytes;
                    splittedImage.pageNo = i + 1;
                    pdfPage = pdfDocument.getPage(i + 1);
                    pageRect = pdfPage.getPageSizeWithRotation();
                    x = (pageRect.getWidth() - (float)poundsWidth) / 2.0f;
                    y = pageRect.getHeight() - splittedPoundsHeight;
                    width = poundsWidth;
                    height = splittedPoundsHeight;
                    splittedImage.imageRect = new Rectangle(x, y, width, height);
                    splittedImages.add(splittedImage);
                }
                break;
            }
            case 5: {
                int n = pages;
                if (pageRangeOption != 2) {
                    PDFUtil.splittImage(pdfDocument, splittedImages, startPageNo, endPageNo, pages, step, poundsHeight, dpiX, bufImage, format, false, true);
                    break;
                }
                PDFUtil.splittImage(pdfDocument, splittedImages, startPageNo, endPageNo, pages, step, poundsHeight, dpiX, bufImage, format, true, true);
                break;
            }
            case 6: {
                int n = pages;
                if (pageRangeOption != 2) {
                    PDFUtil.splittImage(pdfDocument, splittedImages, startPageNo, endPageNo, pages, step, poundsHeight, dpiX, bufImage, format, true, false);
                    break;
                }
                PDFUtil.splittImage(pdfDocument, splittedImages, startPageNo, endPageNo, pages, step, poundsHeight, dpiX, bufImage, format, false, false);
                break;
            }
            default: {
                businessLog.error("Unsupportted cross page style!");
                throw new IOException("Unsupportted cross page style!");
            }
        }
        return splittedImages;
    }

    public static ArrayList<SplittedImage> splitImage(PdfDocument pdfDocument, InputStream inputStream, String format, int startPageNo, int endPageNo, int crosspageStyle, int pageRangeOption, Rectangle rect) throws IOException {
        return PDFUtil.splitImage(pdfDocument, inputStream, format, startPageNo, endPageNo, crosspageStyle, pageRangeOption, 0, rect);
    }

    public static void checkLength(long sourceLength) throws SealException {
        if (sourceLength > 0x6400000L) {
            businessLog.error("Max PDF file length is 20M,current length is " + sourceLength);
            throw new SealException("Max PDF file length is 20M,current length is " + sourceLength);
        }
    }

    public static final X509Certificate certFrom(byte[] certBytes) throws PKIException {
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(certBytes);
            CertificateFactory fact = CertificateFactory.getInstance("X.509", (Provider)new BouncyCastleProvider());
            return (X509Certificate)fact.generateCertificate(bIn);
        }
        catch (CertificateException e) {
            businessLog.error("certFrom failure", (Throwable)e);
            throw new PKIException("certFrom failure", (Throwable)e);
        }
    }

    public static int getSignatureNum(byte[] pdfData) {
        int sigNum = 0;
        try {
            PdfReader reader = new PdfReader(pdfData);
            return PDFUtil.getSignatureNum(reader);
        }
        catch (Exception e) {
            businessLog.error("getSignatureNum failed", (Throwable)e);
            return sigNum;
        }
    }

    public static int getSignatureNum(InputStream inputStream) {
        int sigNum = 0;
        try {
            PdfReader reader = new PdfReader(inputStream);
            return PDFUtil.getSignatureNum(reader);
        }
        catch (Exception e) {
            businessLog.error("getSignatureNum failed", (Throwable)e);
            return sigNum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSignatureNum(PdfReader reader) {
        int sigNum = 0;
        PdfDocument pdfDoc = null;
        try {
            pdfDoc = new PdfDocument(reader);
            SignatureUtil signatureUtil = new SignatureUtil(pdfDoc, true);
            List<String> sigNames = signatureUtil.getSignatureNames();
            sigNum = sigNames.size();
        }
        catch (Exception e) {
            businessLog.error("getSignatureNum failed", (Throwable)e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
        }
        return sigNum;
    }

    public static int getPageNums(InputStream inputStream) throws SealException {
        PdfDocument pdfDoc = null;
        try {
            PdfReader reader = new PdfReader(inputStream);
            int n = PDFUtil.getPageNums(reader);
            return n;
        }
        catch (Exception e) {
            businessLog.error("getPageSize failed", (Throwable)e);
            throw new SealException("getPageSize failed", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
        }
    }

    public static int getPageNums(byte[] pdfData) throws SealException {
        PdfDocument pdfDoc = null;
        try {
            PdfReader reader = new PdfReader(pdfData);
            int n = PDFUtil.getPageNums(reader);
            return n;
        }
        catch (Exception e) {
            businessLog.error("getPageSize failed", (Throwable)e);
            throw new SealException("getPageSize failed", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
        }
    }

    public static int getPageNums(PdfReader reader) throws SealException {
        PdfDocument pdfDoc = null;
        try {
            pdfDoc = new PdfDocument(reader);
            int n = pdfDoc.getNumberOfPages();
            return n;
        }
        catch (Exception e) {
            businessLog.error("getPageSize failed", (Throwable)e);
            throw new SealException("getPageSize failed", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
        }
    }

    public static Rectangle getPageSize(InputStream inputStream) throws SealException {
        return PDFUtil.getPageSize(inputStream, 1);
    }

    public static Rectangle getPageSize(byte[] pdfData, int pageNum) throws SealException {
        try {
            PdfReader reader = new PdfReader(pdfData);
            return PDFUtil.getPageSize(reader, pageNum);
        }
        catch (SealException e) {
            businessLog.error("getPageSize failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("getPageSize failed", (Throwable)e);
            throw new SealException("getPageSize failed", e);
        }
    }

    public static Rectangle getPageSize(InputStream inputStream, int pageNum) throws SealException {
        try {
            PdfReader reader = new PdfReader(inputStream);
            return PDFUtil.getPageSize(reader, pageNum);
        }
        catch (SealException e) {
            businessLog.error("getPageSize failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("getPageSize failed", (Throwable)e);
            throw new SealException("getPageSize failed", e);
        }
    }

    public static Rectangle getPageSize(PdfReader reader, int pageNum) throws SealException {
        PdfDocument pdfDoc = null;
        try {
            pdfDoc = new PdfDocument(reader);
            Rectangle rectangle = pdfDoc.getPage(pageNum).getPageSizeWithRotation();
            return rectangle;
        }
        catch (Exception e) {
            businessLog.error("getPageSize failed", (Throwable)e);
            throw new SealException("getPageSize failed", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
        }
    }

    public static PdfSignatureFormField getSignatureFormField(InputStream inputStream, String sigFieldName) throws SealException {
        PdfSignatureFormField sigField = null;
        PdfDocument pdfDoc = null;
        try {
            PdfReader reader = new PdfReader(inputStream);
            pdfDoc = new PdfDocument(reader);
            SignatureUtil signatureUtil = new SignatureUtil(pdfDoc);
            List<String> sigNames = signatureUtil.getSignatureNames();
            PdfAcroForm form = PdfAcroForm.getAcroForm(pdfDoc, true);
            for (int i = 0; i < sigNames.size(); ++i) {
                String sigName = sigNames.get(i);
                if (!sigName.equals(sigFieldName)) continue;
                sigField = (PdfSignatureFormField)form.getField(sigFieldName);
            }
        }
        catch (Exception e) {
            businessLog.error("getSignatureFormField failed", (Throwable)e);
            throw new SealException("getSignatureFormField failed", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
        }
        return sigField;
    }

    public static boolean isInteger(String str) {
        boolean result = false;
        if (str != null && !str.trim().isEmpty()) {
            for (String key : INTEGER_RULE) {
                if (!str.contains(key)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static String escapeExprSpecialWord(String keyword) {
        if (keyword != null && !keyword.trim().isEmpty()) {
            for (String key : REX_KEYWORD) {
                if (!keyword.contains(key)) continue;
                keyword = keyword.replace(key, "\\" + key);
            }
        }
        return keyword;
    }

    public static boolean containsUCS4Glyph(String content) {
        boolean containUcs4 = false;
        if (null != content) {
            for (int i = 0; i < content.length(); ++i) {
                if (content.codePointAt(i) == content.charAt(i)) continue;
                containUcs4 = true;
                break;
            }
        }
        return containUcs4;
    }

    private static void splitRectangle(PdfDocument pdfDocument, ArrayList<SplittedImage> splittedImages, int startPageNo, int endPageNo, int pages, int step, int poundsHeight, float dpi, int pixelsWidth, String format, boolean startFromLeft, boolean isLeft) throws IOException {
        int remainder = pixelsWidth % pages;
        int singleLength = (pixelsWidth - remainder) / pages;
        int remainderPixel = 1;
        remainderPixel = remainder < pages ? 1 : remainder / pages;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        for (int i = startPageNo; i <= endPageNo; i += step) {
            if (remainder > 0) {
                remainder -= remainderPixel;
            } else {
                remainderPixel = 0;
            }
            SplittedImage splittedImage = new SplittedImage();
            splittedImage.pageNo = i;
            PdfPage pdfPage = pdfDocument.getPage(i);
            Rectangle pageRect = pdfPage.getPageSizeWithRotation();
            float x = 0.0f;
            int splittedPixelsWidth = singleLength + remainderPixel;
            float y = (pageRect.getHeight() - (float)poundsHeight) / 2.0f;
            float width = (float)splittedPixelsWidth / dpi * 72.0f;
            int height = poundsHeight;
            if (!isLeft) {
                x = pageRect.getWidth() - (float)splittedPixelsWidth / dpi * 72.0f;
            }
            if (startFromLeft) {
                if (i > startPageNo) {
                    offsetX -= width;
                }
            } else {
                if (i == startPageNo) {
                    offsetX -= (float)pixelsWidth / dpi * 72.0f;
                }
                offsetX += width;
            }
            splittedImage.offsetX = offsetX;
            splittedImage.offsetY = offsetY;
            splittedImage.imageRect = new Rectangle(x, y, width, height);
            splittedImages.add(splittedImage);
        }
    }

    private static void splitRectangleX(PdfDocument pdfDocument, ArrayList<SplittedImage> splittedImages, int startPageNo, int endPageNo, int pages, int step, int poundsHeight, int poundsWidth, float dpi, int pixelsHeight, String format, boolean startFromLeft, boolean isTop) {
        int n = pages;
        int splitedheight = 0;
        float floatSingleLength = (float)pixelsHeight / (float)pages;
        int singleLength = (int)Math.floor(floatSingleLength);
        int remainder = pixelsHeight % pages;
        int remainderPixel = 1;
        remainderPixel = remainder < pages ? 1 : remainder / pages;
        float offsetY = 0.0f;
        for (int i = startPageNo; i <= endPageNo; i += step) {
            if (remainder > 0) {
                remainder -= remainderPixel;
            } else {
                remainderPixel = 0;
            }
            if (i == startPageNo) {
                splitedheight = singleLength + remainderPixel;
            }
            SplittedImage splittedImage = new SplittedImage();
            splittedImage.pageNo = i;
            PdfPage pdfPage = pdfDocument.getPage(i);
            Rectangle pageRect = pdfPage.getPageSizeWithRotation();
            splitedheight = singleLength + remainderPixel;
            float x = (pageRect.getWidth() - (float)poundsWidth) / 2.0f;
            float y = pageRect.getHeight();
            int width = poundsWidth;
            float height = (float)splitedheight / dpi * 72.0f;
            y = !isTop ? 0.0f : (y -= height);
            splittedImage.imageRect = new Rectangle(x, y, width, height);
            if (isTop) {
                if (i > startPageNo) {
                    offsetY -= height;
                }
            } else {
                if (i == startPageNo) {
                    offsetY -= (float)poundsHeight;
                }
                offsetY += height;
            }
            splittedImage.offsetY = offsetY;
            splittedImages.add(splittedImage);
        }
    }

    private static void splittImage(PdfDocument pdfDocument, ArrayList<SplittedImage> splittedImages, int startPageNo, int endPageNo, int pages, int step, int poundsHeight, float dpi, BufferedImage bufImage, String format, boolean startFromLeft, boolean isLeft) throws IOException {
        int pixelsHeight = bufImage.getHeight();
        int pixelsWidth = bufImage.getWidth();
        int splitedWidth = 0;
        int remainder = pixelsWidth % pages;
        int singleLength = (pixelsWidth - remainder) / pages;
        int remainderPixel = 1;
        remainderPixel = remainder < pages ? 1 : remainder / pages;
        for (int i = startPageNo; i <= endPageNo; i += step) {
            if (remainder > 0) {
                remainder -= remainderPixel;
            } else {
                remainderPixel = 0;
            }
            if (!startFromLeft && i == startPageNo) {
                splitedWidth = singleLength + remainderPixel;
            }
            BufferedImage subImage = PDFUtil.getSubImage(bufImage, singleLength + remainderPixel, startFromLeft, pixelsWidth, pixelsHeight, true, splitedWidth);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)subImage, format, baos);
            byte[] stripeImageBytes = baos.toByteArray();
            baos.reset();
            SplittedImage splittedImage = new SplittedImage();
            splittedImage.imageBytes = stripeImageBytes;
            splittedImage.pageNo = i;
            PdfPage pdfPage = pdfDocument.getPage(i);
            Rectangle pageRect = pdfPage.getPageSizeWithRotation();
            float x = 0.0f;
            int splittedPixelsWidth = subImage.getWidth();
            splitedWidth += splittedPixelsWidth;
            if (!isLeft) {
                x = pageRect.getWidth() - (float)splittedPixelsWidth / dpi * 72.0f;
            }
            float y = (pageRect.getHeight() - (float)poundsHeight) / 2.0f;
            float width = (float)splittedPixelsWidth / dpi * 72.0f;
            int height = poundsHeight;
            splittedImage.imageRect = new Rectangle(x, y, width, height);
            splittedImages.add(splittedImage);
        }
    }

    private static BufferedImage getSubImage(BufferedImage bufImage, int singleLength, boolean isFromLeft, int totalWidth, int totalHeight, boolean verticalCut, int splittedWidth) {
        if (verticalCut) {
            int x = splittedWidth;
            if (!isFromLeft && (x = totalWidth - splittedWidth) < 0) {
                x = 0;
            }
            BufferedImage subImage = bufImage.getSubimage(x, 0, singleLength, totalHeight);
            return subImage;
        }
        int y = splittedWidth;
        if (!isFromLeft && (y = totalHeight - splittedWidth) < 0) {
            y = 0;
        }
        BufferedImage subImage = bufImage.getSubimage(0, y, totalWidth, singleLength);
        return subImage;
    }

    public static float div(float f, float divisor) {
        BigDecimal a = new BigDecimal(f);
        BigDecimal b = new BigDecimal(divisor);
        return a.divide(b, RoundingMode.HALF_UP).floatValue();
    }

    static {
        try {
            if (SysEnv.isUseJNIForHash()) {
                JNIInit.initOpenSSL();
            }
        }
        catch (Exception e) {
            businessLog.warn("initOpenSSL failed", (Object)e.getMessage());
        }
        catch (Error e) {
            businessLog.warn("initOpenSSL failed", (Object)e.getMessage());
        }
    }

    public static class SplittedImage {
        public byte[] imageBytes;
        public int pageNo;
        public Rectangle imageRect;
        public float offsetX = 0.0f;
        public float offsetY = 0.0f;
    }
}

