/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.signatures.PdfPKCS7;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.seal.base.bean.sign.SealVerifyResult;
import cfca.sadk.seal.base.bean.sign.VerifyInfo;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.VerifyProxy;
import cfca.sadk.seal.cert.PdfX509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;

public class VerifyUtil {
    private static Logger businessLog = LoggerFactory.getLogger(VerifyUtil.class);
    public static final BouncyCastleProvider provider = new BouncyCastleProvider();

    public static SealVerifyResult verify(byte[] sourceData) throws SealException {
        return VerifyUtil.verify(sourceData, null);
    }

    public static SealVerifyResult verify(InputStream inputStream) throws SealException {
        return VerifyUtil.verify(inputStream, null);
    }

    public static SealVerifyResult verify(byte[] sourceData, boolean checkSignature, boolean checkModified) throws SealException {
        if (null == sourceData) {
            throw new SealException("sourceData is null");
        }
        try {
            VerifyProxy verifyInfo = new VerifyProxy(sourceData);
            return verifyInfo.verifySignature(checkSignature, checkModified);
        }
        catch (GeneralSecurityException e) {
            businessLog.error("GeneralSecurityException:", (Throwable)e);
            throw new SealException(e.getMessage());
        }
        catch (IOException e) {
            businessLog.error("IOException:", (Throwable)e);
            throw new SealException(e.getMessage());
        }
    }

    public static byte[] getUncoveredBytes(byte[] sourceData) throws SealException {
        return VerifyUtil.getUncoveredBytes(sourceData, null);
    }

    public static boolean checkUncoveredBytes(byte[] sourceData) throws SealException {
        return VerifyUtil.checkUncoveredBytes(sourceData, null);
    }

    private static SealVerifyResult verify(InputStream inputStream, byte[] openPassword) throws SealException {
        businessLog.info("verify begin...");
        if (null == inputStream) {
            throw new SealException("inputStream is null");
        }
        try {
            VerifyProxy verifyInfo = new VerifyProxy(inputStream, openPassword);
            SealVerifyResult sealVerifyResult = verifyInfo.verifySignature();
            return sealVerifyResult;
        }
        catch (GeneralSecurityException e) {
            businessLog.error("GeneralSecurityException:", (Throwable)e);
            throw new SealException(e.getMessage());
        }
        catch (IOException e) {
            businessLog.error("IOException:", (Throwable)e);
            throw new SealException(e.getMessage());
        }
        finally {
            businessLog.info("verify end...");
        }
    }

    public static SealVerifyResult verify(byte[] sourceData, byte[] openPassword) throws SealException {
        businessLog.info("verify begin...");
        if (null == sourceData) {
            throw new SealException("sourceData is null");
        }
        try {
            VerifyProxy verifyInfo = new VerifyProxy(sourceData, openPassword);
            SealVerifyResult sealVerifyResult = verifyInfo.verifySignature();
            return sealVerifyResult;
        }
        catch (GeneralSecurityException e) {
            businessLog.error("GeneralSecurityException:", (Throwable)e);
            throw new SealException(e.getMessage());
        }
        catch (IOException e) {
            businessLog.error("IOException:", (Throwable)e);
            throw new SealException(e.getMessage());
        }
        finally {
            businessLog.info("verify end...");
        }
    }

    private static byte[] getUncoveredBytes(byte[] sourceData, byte[] openPassword) throws SealException {
        businessLog.info("getUncoveredBytes begin...");
        if (null == sourceData) {
            throw new SealException("sourceData is null");
        }
        try {
            VerifyProxy verifyInfo = new VerifyProxy(sourceData, openPassword);
            byte[] byArray = verifyInfo.getUncoveredBytes(sourceData);
            return byArray;
        }
        catch (GeneralSecurityException e) {
            businessLog.error("GeneralSecurityException:", (Throwable)e);
            throw new SealException(e.getMessage());
        }
        catch (IOException e) {
            businessLog.error("IOException:", (Throwable)e);
            throw new SealException(e.getMessage());
        }
        finally {
            businessLog.info("getUncoveredBytes end...");
        }
    }

    private static boolean checkUncoveredBytes(byte[] sourceData, byte[] openPassword) throws SealException {
        businessLog.info("checkUncoveredBytes begin...");
        if (null == sourceData) {
            throw new SealException("sourceData is null");
        }
        try {
            VerifyProxy verifyInfo = new VerifyProxy(sourceData, openPassword);
            SealVerifyResult result = verifyInfo.verifySignature(false, true);
            boolean bl = Boolean.FALSE.equals(result.getVerifyResult());
            return bl;
        }
        catch (GeneralSecurityException e) {
            businessLog.error("GeneralSecurityException:", (Throwable)e);
            throw new SealException(e.getMessage());
        }
        catch (IOException e) {
            businessLog.error("IOException:", (Throwable)e);
            throw new SealException(e.getMessage());
        }
        finally {
            businessLog.info("checkUncoveredBytes end...");
        }
    }

    public boolean verifyPKCS7(PdfReader pdfReader, AbstractPreProceedingWithVerifyingPKCS7 preVerifyingPKCS7) throws GeneralSecurityException, IOException, PKIException {
        businessLog.info("verifyPKCS7  begin...");
        boolean isPKCS7Valid = false;
        try {
            VerifyProxy verifyInfo = new VerifyProxy(pdfReader, null);
            SealVerifyResult verifyResult = verifyInfo.verifySignature();
            isPKCS7Valid = verifyResult.getVerifyResult();
            HashMap<String, VerifyInfo> verifyMap = verifyResult.getVerifyInfos();
            for (String key : verifyMap.keySet()) {
                VerifyInfo singleInfo = verifyMap.get(key);
                preVerifyingPKCS7.proceedingWithVerifyingPKCS7(0, singleInfo.getSignatureName(), singleInfo.getPdfX509Certificate(), singleInfo.getPdfPKCS7(), null, null, verifyResult.getFailReason(), singleInfo.getSignOrder(), true, true);
            }
        }
        catch (GeneralSecurityException e) {
            businessLog.error("GeneralSecurityException:", (Throwable)e);
            throw new PKIException(e.getMessage());
        }
        catch (IOException e) {
            businessLog.error("IOException:", (Throwable)e);
            throw new PKIException(e.getMessage());
        }
        finally {
            businessLog.info("verify end...");
        }
        return isPKCS7Valid;
    }

    public class ErrorInfo {
        public static final String CERT_NOT_VALID = "x509Cert is not valid";
        public static final String CERT_IS_EXPIRED = "x509Cert is expired";
        public static final String CERT_IS_REVOKED = "x509Cert is revoked";
        public static final String CERT_IS_NOT_TRUSTED = "x509Cert is not trusted";
        public static final String CERT_KEYUSAGE_WRONG = "keyUsage of x509Cert is wrong";
        public static final String CERT_ISSUER_NOT_FOUND = "can not get the user issuer's cert";
    }

    public static class FieldPositon {
        public int page;
        public Rectangle position;
    }

    public static abstract class AbstractPreProceedingWithVerifyingPKCS7 {
        public abstract boolean proceedingWithVerifyingPKCS7(int var1, String var2, PdfX509Certificate var3, PdfPKCS7 var4, List<FieldPositon> var5, PdfArray var6, String var7, int var8, boolean var9, boolean var10);
    }
}

