/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.sdk;

import cfca.paperless.base.util.ImageToPdfUtil;
import cfca.paperless.base.util.ProofHashUtil;
import cfca.paperless.client.sdk.AddWaterMarkToPdfProcess;
import cfca.paperless.client.util.CheckPdfUtil;
import cfca.paperless.dto.ResponseHead;
import cfca.paperless.dto.bean.ImageBean;
import cfca.paperless.dto.request.requestbody.tx30.TransformImageToPdfRequestBody;
import cfca.paperless.dto.request.tx30.TransformImageToPdfRequest;
import cfca.paperless.dto.response.responsebody.tx30.TransformImageToPdfResponseBody;
import cfca.paperless.dto.response.tx30.TransformImageToPdfResponse;
import cfca.sadk.seal.base.util.PDFUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformImageToPdfProcess {
    private static final Logger logger = LoggerFactory.getLogger(AddWaterMarkToPdfProcess.class);

    public TransformImageToPdfResponse process(TransformImageToPdfRequest requestBean) throws Exception {
        long start = System.currentTimeMillis();
        logger.info("TransformImageToPdfProcess.process start.");
        TransformImageToPdfRequestBody requestBody = requestBean.getBody();
        byte[] pdfData = new byte[]{};
        List imageBeans = requestBody.getImages();
        ArrayList<byte[]> imageDataList = new ArrayList<byte[]>();
        for (ImageBean imageBean : imageBeans) {
            imageDataList.add(imageBean.getImageData());
        }
        pdfData = ImageToPdfUtil.imageToPdf(imageDataList);
        CheckPdfUtil.checkPdfData(pdfData, false);
        int pageCount = PDFUtil.getPageNums((byte[])pdfData);
        logger.info("PDF\u6587\u4ef6\u9875\u6570\uff1a" + pageCount);
        String pdfFileDataHash = ProofHashUtil.digestAndHex((byte[])pdfData);
        ResponseHead head = new ResponseHead();
        head.setTransactionNo(requestBean.getHead().getTransactionNo());
        TransformImageToPdfResponseBody body = new TransformImageToPdfResponseBody();
        body.setPdf(pdfData);
        body.setPdfFileDataHash(pdfFileDataHash);
        TransformImageToPdfResponse responseBean = new TransformImageToPdfResponse();
        responseBean.setHead(head);
        responseBean.setBody(body);
        long end = System.currentTimeMillis();
        logger.info("TransformImageToPdfProcess.process end. time-taken={}ms", (Object)(end - start));
        return responseBean;
    }
}

