/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.conn;

import cfca.sadk.timestamp.client.conf.TscCommonConf;
import cfca.sadk.timestamp.client.conf.TscLayeredConf;
import cfca.sadk.timestamp.client.conn.HTTPRequestResult;
import cfca.sadk.timestamp.client.conn.TimestampHttpClientBuilder;
import cfca.sadk.timestamp.client.logging.TscLogging;
import cfca.sadk.timestamp.client.utils.TscStrings;
import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.EntityUtils;

public final class HTTPRequester {
    private static final String HTTP_SCHEMA = "http";
    private static final String HTTPS_SCHEMA = "https";
    private final URL serverUrl;
    private final SSLContext sslContext;
    private String username;
    private String password;

    HTTPRequester(String serverUrl, SSLContext sslContext) throws TSAException {
        try {
            this.serverUrl = new URL(serverUrl);
        }
        catch (MalformedURLException e) {
            throw new TSAException(TSAErrorCode.serverUrlInvalidMalformedURL, "invalid serverUrl other than start with http or https: " + serverUrl, (Throwable)e);
        }
        String protocol = this.serverUrl.getProtocol();
        if (!protocol.startsWith(HTTP_SCHEMA)) {
            throw new TSAException(TSAErrorCode.serverUrlInvalidMalformedURL, "do not support other than http or https: " + serverUrl);
        }
        if (HTTPS_SCHEMA.equals(protocol) && sslContext == null) {
            throw new TSAException(TSAErrorCode.serverUrlHTTPSRequireSSLContext, "SSLContext missing: " + serverUrl);
        }
        this.sslContext = sslContext;
    }

    public static final HTTPRequester getHttpInstance(String serverUrl) throws TSAException {
        return new HTTPRequester(serverUrl, null);
    }

    public static final HTTPRequester getHttpsInstance(String serverUrl, SSLContext sslContext) throws TSAException {
        return new HTTPRequester(serverUrl, sslContext);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte[] sendRequest(byte[] timestampRequestBytes, TscCommonConf tscCommonConf, TscLayeredConf tscLayeredConf, String tscUUID) throws TSAException {
        long runTime;
        Args.notNull((Object)timestampRequestBytes, (String)"timestampRequestBytes");
        Args.notNull((Object)tscCommonConf, (String)"tscCommonConf");
        Args.notNull((Object)tscLayeredConf, (String)"tscLayeredConf");
        Args.notNull((Object)tscUUID, (String)"tscUUID");
        TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} sendRequest@running", (Object)tscUUID);
        if (TscLogging.SYSTEM_LOGGER.isInfoEnabled()) {
            TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} sendRequest@timestampRequestBytes: {}", (Object)tscUUID, (Object)TscStrings.toBase64String(timestampRequestBytes));
        }
        long warningThresholdTime = tscCommonConf.getWarningThresholdTime();
        String authorization = this.buildBasicAuthorization(this.username, this.password);
        String tsaHttpURL = tscCommonConf.getHttpURL();
        HttpPost httpPost = new HttpPost(tsaHttpURL);
        httpPost.addHeader("CFCA-TSC-UUID", tscUUID);
        httpPost.addHeader("Content-Type", "application/timestamp-query");
        httpPost.addHeader("Accept", "application/timestamp-reply");
        if (authorization != null) {
            httpPost.addHeader("Authorization", authorization);
        }
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(timestampRequestBytes));
        String requestRecord = this.copyRequestBeforeForward(tscUUID, httpPost, timestampRequestBytes);
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("CFCA-TSC-UUID", (Object)tscUUID);
        byte[] responseBytes = null;
        CloseableHttpClient closeableHttpClient = null;
        CloseableHttpResponse response = null;
        long startTime = System.currentTimeMillis();
        int statusCode = -1;
        String httpError = null;
        HTTPRequestResult requestResult = null;
        try {
            TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} send {} starting\r\n{}", new Object[]{tscUUID, tsaHttpURL, requestRecord});
            if (tscCommonConf.getHttpProxyURL() != null) {
                TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} send proxy-{} starting", (Object)tscUUID, (Object)tscCommonConf.getHttpProxyURL());
            }
            HttpClientBuilder httpBuilder = TimestampHttpClientBuilder.build(tscCommonConf, tscLayeredConf, this.sslContext);
            closeableHttpClient = httpBuilder.build();
            response = closeableHttpClient.execute((HttpUriRequest)httpPost, (HttpContext)context);
            StatusLine statusLine = response.getStatusLine();
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpError = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
                responseBytes = httpError.getBytes("UTF8");
                throw new TSAException(TSAErrorCode.serverUrlSendReceivedHTTPFailure, String.format("url=%s, statusLine=%s", this.serverUrl, statusLine));
            }
            responseBytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            Header header = response.getLastHeader("Content-Type");
            if (header == null) {
                throw new TSAException(TSAErrorCode.serverUrlRecvInvalidPacket, String.format("url=%s, missing Content-Type", this.serverUrl));
            }
            if (!"application/timestamp-reply".equalsIgnoreCase(header.getValue())) {
                throw new TSAException(TSAErrorCode.serverUrlRecvInvalidPacket, String.format("url=%s, Content-Type=%s", this.serverUrl, header.getValue()));
            }
            requestResult = new HTTPRequestResult(requestRecord, statusLine, response.getAllHeaders(), responseBytes);
            long runTime2 = System.currentTimeMillis() - startTime;
            TscLogging.SYSTEM_LOGGER.info("CFCA-FEP-UUID={} sendRequest successfully, sendAndReceivedTime={}ms\r\n{}", new Object[]{tscUUID, runTime2, requestResult});
            if (runTime2 > warningThresholdTime) {
                Object localPort = context.getAttribute("ID_TSC_LOCAL_PORT");
                TscLogging.ERROR_LOGGER.warn("CFCA-FEP-UUID={} sendRequest successfully with localPort={}, sendAndReceivedTime={}ms, warningThresholdTime={}, serverUrl={}, \r\n############SendMessage########## \r\n{}\r\n############ReceivedMessage############\r\n{}", new Object[]{tscUUID, localPort, runTime2, warningThresholdTime, this.serverUrl, requestRecord, requestResult});
            }
        }
        catch (ClientProtocolException e) {
            try {
                long sendTime = System.currentTimeMillis() - startTime;
                this.loggingNetworkFailure(tscUUID, (HttpContext)context, requestRecord, sendTime, httpError, responseBytes, (Exception)((Object)e));
                throw new TSAException(TSAErrorCode.serverUrlSendReceivedHTTPFailure, this.serverUrl + " ClientProtocolError", (Throwable)e);
                catch (IOException e2) {
                    sendTime = System.currentTimeMillis() - startTime;
                    this.loggingNetworkFailure(tscUUID, (HttpContext)context, requestRecord, sendTime, httpError, responseBytes, e2);
                    throw new TSAException(TSAErrorCode.serverUrlSendReceivedHTTPFailure, this.serverUrl + " IOError", (Throwable)e2);
                }
                catch (Exception e3) {
                    sendTime = System.currentTimeMillis() - startTime;
                    this.loggingNetworkFailure(tscUUID, (HttpContext)context, requestRecord, sendTime, httpError, responseBytes, e3);
                    throw new TSAException(TSAErrorCode.serverUrlSendReceivedHTTPFailure, this.serverUrl + " UnknownError", (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                long runTime3;
                long sendTime;
                httpPost.releaseConnection();
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException e4) {
                        sendTime = System.currentTimeMillis() - startTime;
                        this.loggingNetworkClosedFailure(tscUUID, (HttpContext)context, requestRecord, sendTime, e4);
                    }
                }
                if (closeableHttpClient != null) {
                    try {
                        closeableHttpClient.close();
                    }
                    catch (IOException e5) {
                        sendTime = System.currentTimeMillis() - startTime;
                        this.loggingNetworkClosedFailure(tscUUID, (HttpContext)context, requestRecord, sendTime, e5);
                    }
                }
                if ((runTime3 = System.currentTimeMillis() - startTime) > warningThresholdTime) {
                    TscLogging.ERROR_LOGGER.warn("CFCA-TSC-UUID={} sendRequest@finished: longTime={}ms, statusCode={}", new Object[]{tscUUID, runTime3, statusCode});
                    throw throwable;
                }
                TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} sendRequest@finished: runTime={}ms,statusCode={}", new Object[]{tscUUID, runTime3, statusCode});
                throw throwable;
            }
        }
        httpPost.releaseConnection();
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException e) {
                long sendTime = System.currentTimeMillis() - startTime;
                this.loggingNetworkClosedFailure(tscUUID, (HttpContext)context, requestRecord, sendTime, e);
            }
        }
        if (closeableHttpClient != null) {
            try {
                closeableHttpClient.close();
            }
            catch (IOException e) {
                long sendTime = System.currentTimeMillis() - startTime;
                this.loggingNetworkClosedFailure(tscUUID, (HttpContext)context, requestRecord, sendTime, e);
            }
        }
        if ((runTime = System.currentTimeMillis() - startTime) > warningThresholdTime) {
            TscLogging.ERROR_LOGGER.warn("CFCA-TSC-UUID={} sendRequest@finished: longTime={}ms, statusCode={}", new Object[]{tscUUID, runTime, statusCode});
            return responseBytes;
        }
        TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} sendRequest@finished: runTime={}ms,statusCode={}", new Object[]{tscUUID, runTime, statusCode});
        return responseBytes;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte[] pingRequest(byte[] pingDataBytes, TscCommonConf tscCommonConf, TscLayeredConf tscLayeredConf, String tscUUID) throws TSAException {
        long runTime;
        Args.notNull((Object)tscCommonConf, (String)"tscCommonConf");
        Args.notNull((Object)tscLayeredConf, (String)"tscLayeredConf");
        Args.notNull((Object)tscUUID, (String)"tscUUID");
        if (pingDataBytes == null) {
            pingDataBytes = new byte[]{};
        }
        TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} pingRequest@running, pingDataLength={}", (Object)tscUUID, (Object)pingDataBytes.length);
        if (pingDataBytes.length > 1024) {
            throw new TSAException(TSAErrorCode.serverUrlSendReceivedHTTPFailure, "pingDataLength limited to 1024");
        }
        long warningThresholdTime = tscCommonConf.getWarningThresholdTime();
        String pingDataHex = TscStrings.toHexString(pingDataBytes);
        String tsaHttpURL = tscCommonConf.getHttpURL();
        if (pingDataBytes.length > 0) {
            tsaHttpURL = tsaHttpURL + "?data=" + pingDataHex;
        }
        HttpGet httpGet = new HttpGet(tsaHttpURL);
        httpGet.addHeader("CFCA-TSC-UUID", tscUUID);
        httpGet.addHeader("Content-Type", "text/plain;charset=utf-8");
        httpGet.addHeader("Accept", "text/plain;charset=utf-8");
        String requestRecord = this.copyRequestBeforeForward(tscUUID, httpGet);
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("CFCA-TSC-UUID", (Object)tscUUID);
        byte[] responseBytes = null;
        CloseableHttpClient closeableHttpClient = null;
        CloseableHttpResponse response = null;
        long startTime = System.currentTimeMillis();
        int statusCode = -1;
        String httpError = null;
        HTTPRequestResult requestResult = null;
        try {
            TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} ping {} starting\r\n{}", new Object[]{tscUUID, tsaHttpURL, requestRecord});
            if (tscCommonConf.getHttpProxyURL() != null) {
                TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} ping proxy-{} starting", (Object)tscUUID, (Object)tscCommonConf.getHttpProxyURL());
            }
            HttpClientBuilder httpBuilder = TimestampHttpClientBuilder.build(tscCommonConf, tscLayeredConf, this.sslContext);
            closeableHttpClient = httpBuilder.build();
            response = closeableHttpClient.execute((HttpUriRequest)httpGet, (HttpContext)context);
            StatusLine statusLine = response.getStatusLine();
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpError = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
                responseBytes = httpError.getBytes("UTF8");
                throw new TSAException(TSAErrorCode.serverUrlSendReceivedHTTPFailure, String.format("url=%s, statusLine=%s", this.serverUrl, statusLine));
            }
            responseBytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            requestResult = new HTTPRequestResult(requestRecord, statusLine, response.getAllHeaders(), responseBytes);
            long runTime2 = System.currentTimeMillis() - startTime;
            TscLogging.SYSTEM_LOGGER.info("CFCA-FEP-UUID={} ping successfully, sendAndReceivedTime={}ms\r\n{}", new Object[]{tscUUID, runTime2, requestResult});
            if (runTime2 > warningThresholdTime) {
                Object localPort = context.getAttribute("ID_TSC_LOCAL_PORT");
                TscLogging.ERROR_LOGGER.warn("CFCA-FEP-UUID={} ping successfully with localPort={}, sendAndReceivedTime={}ms, warningThresholdTime={},serverUrl={}, \r\n############SendMessage############\r\n{}\r\n############ReceivedMessage############\r\n{}", new Object[]{tscUUID, localPort, runTime2, warningThresholdTime, this.serverUrl, requestRecord, requestResult});
            }
        }
        catch (ClientProtocolException e) {
            try {
                long sendTime = System.currentTimeMillis() - startTime;
                this.loggingNetworkFailure(tscUUID, (HttpContext)context, requestRecord, sendTime, httpError, responseBytes, (Exception)((Object)e));
                throw new TSAException(TSAErrorCode.serverUrlSendReceivedHTTPFailure, this.serverUrl + " ClientProtocolError", (Throwable)e);
                catch (IOException e2) {
                    sendTime = System.currentTimeMillis() - startTime;
                    this.loggingNetworkFailure(tscUUID, (HttpContext)context, requestRecord, sendTime, httpError, responseBytes, e2);
                    throw new TSAException(TSAErrorCode.serverUrlSendReceivedHTTPFailure, this.serverUrl + " IOError", (Throwable)e2);
                }
                catch (Exception e3) {
                    sendTime = System.currentTimeMillis() - startTime;
                    this.loggingNetworkFailure(tscUUID, (HttpContext)context, requestRecord, sendTime, httpError, responseBytes, e3);
                    throw new TSAException(TSAErrorCode.serverUrlSendReceivedHTTPFailure, this.serverUrl + " UnknownError", (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                long runTime3;
                long sendTime;
                httpGet.releaseConnection();
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException e4) {
                        sendTime = System.currentTimeMillis() - startTime;
                        this.loggingNetworkClosedFailure(tscUUID, (HttpContext)context, requestRecord, sendTime, e4);
                    }
                }
                if (closeableHttpClient != null) {
                    try {
                        closeableHttpClient.close();
                    }
                    catch (IOException e5) {
                        sendTime = System.currentTimeMillis() - startTime;
                        this.loggingNetworkClosedFailure(tscUUID, (HttpContext)context, requestRecord, sendTime, e5);
                    }
                }
                if ((runTime3 = System.currentTimeMillis() - startTime) > warningThresholdTime) {
                    TscLogging.ERROR_LOGGER.warn("CFCA-TSC-UUID={} ping@finished: longTime={}ms, statusCode={}", new Object[]{tscUUID, runTime3, statusCode});
                    throw throwable;
                }
                TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} ping@finished: runTime={}ms,statusCode={}", new Object[]{tscUUID, runTime3, statusCode});
                throw throwable;
            }
        }
        httpGet.releaseConnection();
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException e) {
                long sendTime = System.currentTimeMillis() - startTime;
                this.loggingNetworkClosedFailure(tscUUID, (HttpContext)context, requestRecord, sendTime, e);
            }
        }
        if (closeableHttpClient != null) {
            try {
                closeableHttpClient.close();
            }
            catch (IOException e) {
                long sendTime = System.currentTimeMillis() - startTime;
                this.loggingNetworkClosedFailure(tscUUID, (HttpContext)context, requestRecord, sendTime, e);
            }
        }
        if ((runTime = System.currentTimeMillis() - startTime) > warningThresholdTime) {
            TscLogging.ERROR_LOGGER.warn("CFCA-TSC-UUID={} ping@finished: longTime={}ms, statusCode={}", new Object[]{tscUUID, runTime, statusCode});
            return responseBytes;
        }
        TscLogging.SYSTEM_LOGGER.info("CFCA-TSC-UUID={} ping@finished: runTime={}ms,statusCode={}", new Object[]{tscUUID, runTime, statusCode});
        return responseBytes;
    }

    final String copyRequestBeforeForward(String tscUUID, HttpGet httpGet) {
        Args.notNull((Object)tscUUID, (String)"fepUUID");
        Args.notNull((Object)httpGet, (String)"httpGet");
        StringBuilder stringBuilder = new StringBuilder(2048);
        Header[] headers = httpGet.getAllHeaders();
        if (headers != null) {
            for (Header header : headers) {
                if (header == null) continue;
                stringBuilder.append(header.getName()).append(": ").append(header.getValue()).append("\r\n");
            }
        }
        String messageReq = stringBuilder.toString();
        return messageReq;
    }

    final String copyRequestBeforeForward(String tscUUID, HttpPost httpPost, byte[] content) {
        Args.notNull((Object)tscUUID, (String)"fepUUID");
        Args.notNull((Object)httpPost, (String)"httpPost");
        Args.notNull((Object)content, (String)"content");
        StringBuilder stringBuilder = new StringBuilder(2048);
        Header[] headers = httpPost.getAllHeaders();
        if (headers != null) {
            for (Header header : headers) {
                if (header == null) continue;
                stringBuilder.append(header.getName()).append(": ").append(header.getValue()).append("\r\n");
            }
        }
        stringBuilder.append(TscStrings.toBase64String(content)).append("\r\n");
        String messageReq = stringBuilder.toString();
        return messageReq;
    }

    private void loggingNetworkFailure(String tscUUID, HttpContext context, String requestRecord, long sendTime, String httpError, byte[] responseBytes, Exception e) {
        String localPort = context == null ? "" : context.getAttribute("ID_TSC_LOCAL_PORT");
        StringBuilder builder = new StringBuilder(2048);
        builder.append("CFCA-TSC-UUID=").append(tscUUID).append(" send to ").append(this.serverUrl).append(" sendRequest failed with localPort=").append((Object)localPort);
        builder.append(", sendTime=").append(sendTime).append("ms");
        builder.append("\r\n");
        builder.append("\r\n################ SEND REQUEST ################");
        builder.append("\r\n").append(requestRecord);
        builder.append("\r\n################ SEND REQUEST ################");
        if (httpError != null) {
            builder.append("\r\n################ ERROR RESPONSE ###############");
            builder.append("\r\n").append(httpError);
            builder.append("\r\n################ ERROR RESPONSE ###############");
        }
        if (responseBytes != null) {
            builder.append("\r\n################ ERROR BYTES ###############");
            builder.append("\r\n").append(TscStrings.toUTF8String(responseBytes));
            builder.append("\r\n################ ERROR BYTES ###############");
        }
        String message = builder.toString();
        if (TscLogging.SYSTEM_LOGGER.isInfoEnabled()) {
            TscLogging.SYSTEM_LOGGER.error(message, (Throwable)e);
        }
        TscLogging.ERROR_LOGGER.error(message, (Throwable)e);
    }

    private void loggingNetworkClosedFailure(String tscUUID, HttpContext context, String requestRecord, long sendTime, Exception e) {
        String localPort = context == null ? "" : context.getAttribute("ID_TSC_LOCAL_PORT");
        StringBuilder builder = new StringBuilder(2048);
        builder.append("CFCA-TSC-UUID=").append(tscUUID).append(" send to ").append(this.serverUrl).append(" closed failure with localPort=").append((Object)localPort);
        builder.append(", sendTime=").append(sendTime).append("ms");
        builder.append("\r\n");
        builder.append("\r\n################ SEND REQUEST ################");
        builder.append("\r\n").append(requestRecord);
        builder.append("\r\n################ SEND REQUEST ################");
        String message = builder.toString();
        if (TscLogging.SYSTEM_LOGGER.isInfoEnabled()) {
            TscLogging.SYSTEM_LOGGER.error(message);
        }
        TscLogging.ERROR_LOGGER.error(message, (Throwable)e);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    final String buildBasicAuthorization(String username, String password) throws TSAException {
        String httpAuthData = null;
        if (!TscStrings.isEmpty(username) && !TscStrings.isEmpty(password)) {
            try {
                String userInfo = username + ":" + password;
                String authData = TscStrings.toBase64String(userInfo.getBytes("UTF8"));
                httpAuthData = "Basic " + authData;
            }
            catch (UnsupportedEncodingException e) {
                throw new TSAException(TSAErrorCode.serverUrlHTTPAddBasicAuthFailure, (Throwable)e);
            }
        }
        return httpAuthData;
    }
}

