/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk.annotationandattachment;

import cfca.com.itextpdf.text.DocumentException;
import cfca.com.itextpdf.text.Rectangle;
import cfca.com.itextpdf.text.pdf.PRStream;
import cfca.com.itextpdf.text.pdf.PdfAnnotation;
import cfca.com.itextpdf.text.pdf.PdfArray;
import cfca.com.itextpdf.text.pdf.PdfDictionary;
import cfca.com.itextpdf.text.pdf.PdfName;
import cfca.com.itextpdf.text.pdf.PdfReader;
import cfca.com.itextpdf.text.pdf.PdfStamper;
import cfca.com.itextpdf.text.pdf.PdfString;
import cfca.com.itextpdf.text.pdf.TextField;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfSealAnnotation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createHiddenTextField(InputStream is, OutputStream os, int page, String fieldName, String fieldValue) throws DocumentException, IOException {
        PdfReader pdfReader = new PdfReader(is);
        PdfStamper pdfStamper = new PdfStamper(pdfReader, os);
        try {
            Rectangle rectangle = new Rectangle(0.0f, 0.0f);
            TextField textField = new TextField(pdfStamper.getWriter(), rectangle, fieldName);
            textField.setText(fieldValue);
            pdfStamper.addAnnotation(textField.getTextField(), page);
        }
        finally {
            if (pdfStamper != null) {
                pdfStamper.close();
            }
        }
    }

    public void createHiddenTextField(String srcFilePath, String destFilePath, int page, String fieldName, String fieldValue) throws DocumentException, IOException {
        this.createHiddenTextField(new FileInputStream(srcFilePath), (OutputStream)new FileOutputStream(destFilePath), page, fieldName, fieldValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createHiddenTextField(PdfReader pdfReader, OutputStream os, int page, String fieldName, String fieldValue) throws DocumentException, IOException {
        PdfStamper pdfStamper = new PdfStamper(pdfReader, os);
        try {
            Rectangle rectangle = new Rectangle(0.0f, 0.0f);
            TextField textField = new TextField(pdfStamper.getWriter(), rectangle, fieldName);
            textField.setText(fieldValue);
            pdfStamper.addAnnotation(textField.getTextField(), page);
        }
        finally {
            if (pdfStamper != null) {
                pdfStamper.close();
            }
        }
    }

    public String readHiddenTextField(PdfReader pdfReader, String fieldName, int page) throws IOException, DocumentException {
        if (fieldName == null || fieldName.length() == 0) {
            throw new DocumentException("fieldName can not be null!!!");
        }
        ArrayList<HashMap<String, String>> allTextFields = this.readTextFields(pdfReader, fieldName, page);
        if (allTextFields != null && allTextFields.size() > 0) {
            return allTextFields.get(0).get(fieldName);
        }
        return null;
    }

    public String readHiddenTextField(InputStream inputStream, String fieldName, int page) throws IOException, DocumentException {
        PdfReader pdfReader = new PdfReader(inputStream);
        return this.readHiddenTextField(pdfReader, fieldName, page);
    }

    public String readHiddenTextField(String filePath, String fieldName, int page) throws IOException, DocumentException {
        return this.readHiddenTextField(new FileInputStream(filePath), fieldName, page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<HashMap<String, String>> readTextFields(PdfReader pdfReader, String fieldName, int page) throws IOException, DocumentException {
        try {
            ArrayList<HashMap<String, String>> textFieldList = new ArrayList<HashMap<String, String>>();
            int i = 1;
            int numOfPages = pdfReader.getNumberOfPages();
            if (page > 0) {
                i = page;
                numOfPages = page;
            } else if (-1 != page) {
                throw new DocumentException("page must be -1 or positive!");
            }
            while (i <= numOfPages) {
                PdfArray pdfArray = pdfReader.getPageN(i).getAsArray(PdfName.ANNOTS);
                if (pdfArray != null) {
                    int sizeOfAnnots = pdfArray.size();
                    for (int j = 0; j < sizeOfAnnots; ++j) {
                        HashMap<String, String> textFieldMap;
                        PdfDictionary pdfDictionary = pdfArray.getAsDict(j);
                        PdfString pdfFieldName = pdfDictionary.getAsString(PdfName.T);
                        PdfString pdffieldValue = pdfDictionary.getAsString(PdfName.V);
                        if (pdfFieldName == null) continue;
                        String key = pdfFieldName.toUnicodeString();
                        if (fieldName != null && fieldName.length() > 0 && fieldName.equals(key)) {
                            textFieldMap = new HashMap();
                            if (pdffieldValue != null) {
                                textFieldMap.put(key, pdffieldValue.toUnicodeString());
                            } else {
                                textFieldMap.put(key, null);
                            }
                            textFieldList.add(textFieldMap);
                            ArrayList<HashMap<String, String>> arrayList = textFieldList;
                            return arrayList;
                        }
                        textFieldMap = new HashMap<String, String>();
                        if (pdffieldValue != null) {
                            textFieldMap.put(key, pdffieldValue.toUnicodeString());
                        } else {
                            textFieldMap.put(key, null);
                        }
                        textFieldList.add(textFieldMap);
                    }
                }
                ++i;
            }
            ArrayList<HashMap<String, String>> arrayList = textFieldList;
            return arrayList;
        }
        finally {
            if (pdfReader != null) {
                pdfReader.close();
            }
        }
    }

    public ArrayList<HashMap<String, String>> readTextFields(InputStream is, String fieldName, int page) throws IOException, DocumentException {
        PdfReader pdfReader = new PdfReader(is);
        return this.readTextFields(pdfReader, fieldName, page);
    }

    public ArrayList<HashMap<String, String>> readTextFields(String filePath, String fieldName, int page) throws IOException, DocumentException {
        return this.readTextFields(new FileInputStream(filePath), fieldName, page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFileAttachmentAnnotation(PdfReader pdfReader, String attachFileCaption, int page) throws IOException, DocumentException {
        if (attachFileCaption == null || attachFileCaption.length() == 0) {
            throw new DocumentException("fieldName can not be null or empty string!");
        }
        try {
            int i = 1;
            int numOfPages = pdfReader.getNumberOfPages();
            if (page > 0) {
                i = page;
                numOfPages = page;
            } else if (-1 != page) {
                throw new DocumentException("page must be -1 or positive!");
            }
            while (i <= numOfPages) {
                PdfArray pdfArray = pdfReader.getPageN(i).getAsArray(PdfName.ANNOTS);
                if (pdfArray != null) {
                    int sizeOfAnnots = pdfArray.size();
                    for (int j = 0; j < sizeOfAnnots; ++j) {
                        String key;
                        PdfDictionary nameDictionary;
                        PdfDictionary pdfDictionary = pdfArray.getAsDict(j);
                        if (!PdfName.FILEATTACHMENT.equals(pdfDictionary.getAsName(PdfName.SUBTYPE)) || (nameDictionary = pdfDictionary.getAsDict(PdfName.FS)) == null || !attachFileCaption.equals(key = nameDictionary.getAsString(PdfName.UF).toUnicodeString())) continue;
                        PdfDictionary valueDictionary = nameDictionary.getAsDict(PdfName.EF);
                        if (valueDictionary != null) {
                            byte[] byArray = PdfReader.getStreamBytes((PRStream)valueDictionary.getAsStream(PdfName.UF));
                            return byArray;
                        }
                        byte[] byArray = null;
                        return byArray;
                    }
                }
                ++i;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (pdfReader != null) {
                pdfReader.close();
            }
        }
    }

    public byte[] readFileAttachmentAnnotation(InputStream inputStream, String attachFileCaption, int page) throws IOException, DocumentException {
        PdfReader pdfReader = new PdfReader(inputStream);
        return this.readFileAttachmentAnnotation(pdfReader, attachFileCaption, page);
    }

    public byte[] readFileAttachmentAnnotation(String filePath, String attachFileDisplay, int page) throws IOException, DocumentException {
        return this.readFileAttachmentAnnotation(new FileInputStream(filePath), attachFileDisplay, page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFileAttachmentAnnotation(InputStream is, OutputStream os, Rectangle rect, int page, String annotCommentString, byte[] attachContentBytes, String attachFilePath, String attachFileDisplay) throws DocumentException, IOException {
        PdfReader pdfReader = new PdfReader(is);
        PdfStamper pdfStamper = new PdfStamper(pdfReader, os);
        try {
            PdfAnnotation pdfAnnotation = PdfAnnotation.createFileAttachment(pdfStamper.getWriter(), rect, annotCommentString, attachContentBytes, attachFilePath, attachFileDisplay);
            pdfStamper.addAnnotation(pdfAnnotation, page);
        }
        finally {
            if (pdfStamper != null) {
                pdfStamper.close();
            }
        }
    }

    public void createFileAttachmentAnnotation(String srcFilePath, String destFilePath, Rectangle rect, int page, String annotCommentString, byte[] attachContentBytes, String attachFilePath, String attachFileDisplay) throws FileNotFoundException, DocumentException, IOException {
        this.createFileAttachmentAnnotation(new FileInputStream(srcFilePath), (OutputStream)new FileOutputStream(destFilePath), rect, page, annotCommentString, attachContentBytes, attachFilePath, attachFileDisplay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFileAttachmentAnnotation(PdfReader pdfReader, OutputStream os, Rectangle rect, int page, String annotCommentString, byte[] attachContentBytes, String attachFilePath, String attachFileDisplay) throws DocumentException, IOException {
        PdfStamper pdfStamper = new PdfStamper(pdfReader, os);
        try {
            PdfAnnotation pdfAnnotation = PdfAnnotation.createFileAttachment(pdfStamper.getWriter(), rect, annotCommentString, attachContentBytes, attachFilePath, attachFileDisplay);
            pdfStamper.addAnnotation(pdfAnnotation, page);
        }
        finally {
            if (pdfStamper != null) {
                pdfStamper.close();
            }
        }
    }
}

