/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.logback.util.LogbackInitializer;
import cfca.paperless.base.BaseConstants;
import cfca.paperless.base.util.IPUtils;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.recovery.ResilientFileOutputStream;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerInitializer {
    private static boolean initOKFlag = false;

    public static void initLogger(String configFilePath) throws Exception {
        try {
            File externalConfigFile = new File(configFilePath);
            if (!externalConfigFile.exists()) {
                throw new IOException("Logback External Config File Parameter does not reference a file that exists");
            }
            if (!externalConfigFile.isFile()) {
                throw new IOException("Logback External Config File Parameter exists, but does not reference a file");
            }
            if (!externalConfigFile.canRead()) {
                throw new IOException("Logback External Config File exists and is a file, but cannot be read.");
            }
            System.out.println("registe logback start.");
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            configurator.doConfigure(externalConfigFile);
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
            System.out.println("registe logback end.");
            boolean flag = false;
            block2: for (ch.qos.logback.classic.Logger logger : context.getLoggerList()) {
                if (flag) break;
                Iterator index = logger.iteratorForAppenders();
                while (index.hasNext()) {
                    String logbackPath;
                    Appender appender = (Appender)index.next();
                    if (!(appender instanceof FileAppender)) continue;
                    FileAppender fa = (FileAppender)appender;
                    ResilientFileOutputStream rfos = (ResilientFileOutputStream)fa.getOutputStream();
                    File file = rfos.getFile();
                    BaseConstants.logbackPath = logbackPath = file.getParentFile().getCanonicalPath();
                    flag = true;
                    continue block2;
                }
            }
            initOKFlag = true;
        }
        catch (Exception e) {
            throw new Exception("logger context init fail for " + configFilePath, e);
        }
    }

    public static boolean getInitOKFlag() {
        return initOKFlag;
    }

    public static void initCfcaLogger(Logger logger, String module, String configFilePath) throws Exception {
        logger.info("\u5f00\u59cb\u52a0\u8f7dCFCA\u4e13\u7528\u65e5\u5fd7\u7ec4\u4ef6[logback-cfca.xml].logbackFilePath={} moduleName={}", (Object)configFilePath, (Object)module);
        File externalConfigFile = new File(configFilePath);
        if (!externalConfigFile.exists()) {
            throw new IOException("Logback External Config File Parameter does not reference a file that exists");
        }
        if (!externalConfigFile.isFile()) {
            throw new IOException("Logback External Config File Parameter exists, but does not reference a file");
        }
        if (!externalConfigFile.canRead()) {
            throw new IOException("Logback External Config File exists and is a file, but cannot be read.");
        }
        String localIPString = "";
        try {
            List<String> localIPList = IPUtils.getLocalHostLANAddress();
            logger.info("\u83b7\u53d6\u670d\u52a1\u5668IP\u64cd\u4f5c\u6210\u529f.IP={}", localIPList);
            localIPString = localIPList.get(0);
        }
        catch (Exception e) {
            localIPString = "NOIP";
            logger.warn("\u83b7\u53d6\u670d\u52a1\u5668IP\u64cd\u4f5c\u5931\u8d25.", (Throwable)e);
        }
        String applicationName = "";
        try {
            applicationName = module + "-log-" + localIPString;
            LogbackInitializer.setLogback((String)configFilePath, (String)applicationName);
            logger.info("CFCA\u4e13\u7528\u65e5\u5fd7\u7ec4\u4ef6\u52a0\u8f7d\u6210\u529f[logback-cfca.xml].logbackFilePath={} applicationName={}", (Object)configFilePath, (Object)applicationName);
        }
        catch (Exception e) {
            throw new Exception("CFCA\u4e13\u7528\u65e5\u5fd7\u7ec4\u4ef6\u52a0\u8f7d\u5931\u8d25[logback-cfca.xml].logbackFilePath=" + configFilePath + " applicationName=" + applicationName, e);
        }
    }
}

