/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.io.font.otf.lookuptype6;

import cfca.sadk.com.itextpdf.io.font.otf.ContextualSubTable;
import cfca.sadk.com.itextpdf.io.font.otf.ContextualSubstRule;
import cfca.sadk.com.itextpdf.io.font.otf.Glyph;
import cfca.sadk.com.itextpdf.io.font.otf.GlyphLine;
import cfca.sadk.com.itextpdf.io.font.otf.OpenTableLookup;
import cfca.sadk.com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import java.util.List;

public abstract class SubTableLookup6
extends ContextualSubTable {
    private static final long serialVersionUID = -7471613803606544198L;

    protected SubTableLookup6(OpenTypeFontTableReader openReader, int lookupFlag) {
        super(openReader, lookupFlag);
    }

    @Override
    public ContextualSubstRule getMatchingContextRule(GlyphLine line) {
        if (line.idx >= line.end) {
            return null;
        }
        Glyph g = line.get(line.idx);
        List<ContextualSubstRule> rules = this.getSetOfRulesForStartGlyph(g.getCode());
        for (ContextualSubstRule rule : rules) {
            int lastGlyphIndex = this.checkIfContextMatch(line, rule);
            if (lastGlyphIndex == -1 || !this.checkIfLookaheadContextMatch(line, rule, lastGlyphIndex) || !this.checkIfBacktrackContextMatch(line, rule)) continue;
            line.start = line.idx;
            line.end = lastGlyphIndex + 1;
            return rule;
        }
        return null;
    }

    protected boolean checkIfLookaheadContextMatch(GlyphLine line, ContextualSubstRule rule, int startIdx) {
        int j;
        OpenTableLookup.GlyphIndexer gidx = new OpenTableLookup.GlyphIndexer();
        gidx.line = line;
        gidx.idx = startIdx;
        for (j = 0; j < rule.getLookaheadContextLength(); ++j) {
            gidx.nextGlyph(this.openReader, this.lookupFlag);
            if (gidx.glyph == null || !rule.isGlyphMatchesLookahead(gidx.glyph.getCode(), j)) break;
        }
        return j == rule.getLookaheadContextLength();
    }

    protected boolean checkIfBacktrackContextMatch(GlyphLine line, ContextualSubstRule rule) {
        int j;
        OpenTableLookup.GlyphIndexer gidx = new OpenTableLookup.GlyphIndexer();
        gidx.line = line;
        gidx.idx = line.idx;
        for (j = 0; j < rule.getBacktrackContextLength(); ++j) {
            gidx.previousGlyph(this.openReader, this.lookupFlag);
            if (gidx.glyph == null || !rule.isGlyphMatchesBacktrack(gidx.glyph.getCode(), j)) break;
        }
        return j == rule.getBacktrackContextLength();
    }
}

