/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.math.BigInteger;

public final class ECCHelper {
    public static byte[] encodeToStdAsn1(int rsLength, byte[] signData) throws CryptoException {
        if (signData == null) {
            throw new CryptoException("missing signature signData");
        }
        byte[] signValue = null;
        if (signData.length == 2 * rsLength) {
            byte[] rBytes = new byte[signData.length >> 1];
            byte[] sBytes = new byte[signData.length >> 1];
            System.arraycopy(signData, 0, rBytes, 0, rBytes.length);
            System.arraycopy(signData, sBytes.length, sBytes, 0, sBytes.length);
            BigInteger rInt = new BigInteger(1, rBytes);
            BigInteger sInt = new BigInteger(1, sBytes);
            try {
                ASN1EncodableVector v = new ASN1EncodableVector();
                v.add(new ASN1Integer(rInt));
                v.add(new ASN1Integer(sInt));
                signValue = new DERSequence(v).getEncoded("DER");
            }
            catch (IOException e) {
                throw new CryptoException("signature signData failed", e);
            }
        } else {
            signValue = signData;
        }
        return signValue;
    }

    public static byte[] decodeFromStdAsn1(int rsLength, byte[] signData) throws CryptoException {
        if (signData == null) {
            throw new CryptoException("missing signature signData");
        }
        byte[] signValue = null;
        if (signData.length != rsLength * 2) {
            BigInteger sInt;
            BigInteger rInt;
            try {
                ASN1Sequence seq = (ASN1Sequence)ASN1Primitive.fromByteArray(signData);
                rInt = ((ASN1Integer)seq.getObjectAt(0)).getPositiveValue();
                sInt = ((ASN1Integer)seq.getObjectAt(1)).getPositiveValue();
            }
            catch (IOException e) {
                throw new CryptoException("invalid signature signData", e);
            }
            signValue = new byte[rsLength * 2];
            int length = rsLength;
            System.arraycopy(BigIntegers.asUnsignedByteArray(length, rInt), 0, signValue, 0, length);
            System.arraycopy(BigIntegers.asUnsignedByteArray(length, sInt), 0, signValue, length, length);
        } else {
            signValue = signData;
        }
        return signValue;
    }
}

