/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.tool.xml.css.apply;

import cfca.com.itextpdf.tool.xml.Tag;
import cfca.com.itextpdf.tool.xml.css.CssUtils;
import cfca.com.itextpdf.tool.xml.css.FontSizeTranslator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MaxLeadingAndSize {
    private final CssUtils utils = CssUtils.getInstance();
    private final FontSizeTranslator fontSizeTranslator = FontSizeTranslator.getInstance();
    private float largestLeading;
    private float largestFont;

    public float getLargestLeading() {
        return this.largestLeading;
    }

    public float getLargestFont() {
        return this.largestFont;
    }

    public void setVariablesBasedOnChildren(Tag t) {
        float largestFontChildren;
        float fontSizeParent = this.fontSizeTranslator.getFontSize(t);
        this.largestFont = fontSizeParent > (largestFontChildren = this.getLargestFontFromChildren(t.getChildren())) ? fontSizeParent : largestFontChildren;
        float leadingParent = this.calculateLeading(t).floatValue();
        float largestLeadingChildren = this.getLargestLeadingFromChildren(t.getChildren());
        this.largestLeading = leadingParent > largestLeadingChildren ? leadingParent : largestLeadingChildren;
    }

    public void setLeading(Tag tag) {
        this.largestLeading = this.calculateLeading(tag).floatValue();
    }

    public float getLargestFontFromChildren(List<Tag> children) {
        float largestFont = 12.0f;
        for (Tag tag : children) {
            float fontSize = this.fontSizeTranslator.getFontSize(tag);
            if (!(fontSize > largestFont)) continue;
            largestFont = fontSize;
        }
        return largestFont;
    }

    private float getLargestLeadingFromChildren(List<Tag> children) {
        float leading = 0.0f;
        for (Tag tag : children) {
            Float calculatedLineHeight = this.calculateLeading(tag);
            if (calculatedLineHeight.floatValue() > leading) {
                leading = calculatedLineHeight.floatValue();
            }
            this.getLargestLeadingFromChildren(tag.getChildren());
        }
        return leading;
    }

    public Float calculateLeading(Tag t) {
        float leading = 0.0f;
        Map<String, String> css = t.getCSS();
        float fontSize = this.fontSizeTranslator.getFontSize(t);
        if (css.get("line-height") != null) {
            String value = css.get("line-height");
            if (this.utils.isNumericValue(value)) {
                leading = Float.parseFloat(value) * fontSize;
            } else if (this.utils.isRelativeValue(value)) {
                leading = this.utils.parseRelativeValue(value, fontSize);
            } else if (this.utils.isMetricValue(value)) {
                leading = this.utils.parsePxInCmMmPcToPt(value);
            }
            if (leading == 0.0f) {
                leading = fontSize * 1.5f;
            }
        } else {
            leading = fontSize * 1.5f;
        }
        return Float.valueOf(leading);
    }
}

