/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.sdk;

import cfca.paperless.base.util.ProofHashUtil;
import cfca.paperless.base.util.StringUtil;
import cfca.paperless.client.util.CheckPdfUtil;
import cfca.paperless.client.util.PdfCompoundUtil;
import cfca.paperless.dto.ResponseHead;
import cfca.paperless.dto.bean.MultiDataBean;
import cfca.paperless.dto.request.requestbody.tx10.SynthesizeMultiDataRequestBody;
import cfca.paperless.dto.request.tx10.SynthesizeMultiDataRequest;
import cfca.paperless.dto.response.responsebody.tx10.SynthesizeMultiDataResponseBody;
import cfca.paperless.dto.response.tx10.SynthesizeMultiDataResponse;
import cfca.sadk.seal.base.util.PDFUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynthesizeMultiDataProcess {
    private static final Logger logger = LoggerFactory.getLogger(SynthesizeMultiDataProcess.class);

    public SynthesizeMultiDataResponse process(SynthesizeMultiDataRequest requestBean) throws Exception {
        Object bais;
        int sigLen;
        long start = System.currentTimeMillis();
        logger.info("SynthesizeMultiDataProcess.process start.");
        SynthesizeMultiDataRequestBody requestBody = requestBean.getBody();
        byte[] pdfData = new byte[]{};
        if (!"1".equals(requestBody.getInputType()) && !"2".equals(requestBody.getInputType())) {
            throw new Exception("invalid inputType");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                throw new Exception("inputSource is null");
            }
            pdfData = FileUtils.readFileToByteArray((File)new File(requestBody.getInputSource()));
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getPdfData() == null) {
                throw new Exception("pdfData is null");
            }
            pdfData = requestBody.getPdfData();
        }
        CheckPdfUtil.checkPdfData(pdfData, false);
        int pageCount = PDFUtil.getPageNums((byte[])pdfData);
        logger.info("PDF\u6587\u4ef6\u9875\u6570\uff1a" + pageCount);
        List multiDataBeans = requestBody.getMultiDataBeans();
        if (multiDataBeans != null && multiDataBeans.size() > 0 && (sigLen = PDFUtil.getSignatureNum((InputStream)(bais = new ByteArrayInputStream(pdfData)))) > 0) {
            logger.error("pdf\u4e2d\u5df2\u7ecf\u5b58\u5728\u7b7e\u540d\u4e0d\u80fd\u7ee7\u7eed\u5408\u6210\u6570\u636e");
            throw new Exception("pdf\u4e2d\u5df2\u7ecf\u5b58\u5728\u7b7e\u540d\u4e0d\u80fd\u7ee7\u7eed\u5408\u6210\u6570\u636e ");
        }
        for (MultiDataBean mulitDataBean : multiDataBeans) {
            String fileName = mulitDataBean.getFileName();
            byte[] fileData = mulitDataBean.getFileDataByte();
            pdfData = PdfCompoundUtil.compoundPdfDataByAttachment(pdfData, fileData, fileName);
            logger.info("type=3\u591a\u5a92\u4f53\u4f5c\u4e3a\u5185\u5bb9\u5408\u6210\uff1a" + fileName);
        }
        String pdfFileDataHash = ProofHashUtil.digestAndHex((byte[])pdfData);
        ResponseHead head = new ResponseHead();
        head.setTransactionNo(requestBean.getHead().getTransactionNo());
        SynthesizeMultiDataResponseBody body = new SynthesizeMultiDataResponseBody();
        body.setPdf(pdfData);
        body.setPdfFileDataHash(pdfFileDataHash);
        SynthesizeMultiDataResponse responseBean = new SynthesizeMultiDataResponse();
        responseBean.setHead(head);
        responseBean.setBody(body);
        long end = System.currentTimeMillis();
        logger.info("SynthesizeMultiDataProcess.process end. time-taken={}ms", (Object)(end - start));
        return responseBean;
    }
}

