/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.svg.renderers.impl;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.color.ColorConstants;
import cfca.sadk.com.itextpdf.kernel.color.WebColors;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.geom.AffineTransform;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import cfca.sadk.com.itextpdf.layout.font.FontCharacteristics;
import cfca.sadk.com.itextpdf.layout.font.FontInfo;
import cfca.sadk.com.itextpdf.layout.font.FontProvider;
import cfca.sadk.com.itextpdf.layout.font.FontSet;
import cfca.sadk.com.itextpdf.styledxmlparser.css.util.CssUtils;
import cfca.sadk.com.itextpdf.svg.exceptions.SvgProcessingException;
import cfca.sadk.com.itextpdf.svg.renderers.ISvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.SvgDrawContext;
import cfca.sadk.com.itextpdf.svg.renderers.impl.ClipPathSvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.impl.TextSvgBranchRenderer;
import cfca.sadk.com.itextpdf.svg.utils.TransformUtils;
import cfca.sadk.seal.base.util.FontUtil;
import cfca.sadk.seal.base.util.FontsFactory;
import cfca.sadk.seal.base.util.PDFUtil;
import cfca.sadk.seal.base.util.UCS4FontUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractSvgNodeRenderer
implements ISvgNodeRenderer {
    private static Logger businessLog = LoggerFactory.getLogger(AbstractSvgNodeRenderer.class);
    protected Map<String, String> attributesAndStyles;
    boolean partOfClipPath;
    boolean doFill = false;
    boolean doStroke = false;
    private ISvgNodeRenderer parent;

    @Override
    public void setParent(ISvgNodeRenderer parent) {
        this.parent = parent;
    }

    @Override
    public ISvgNodeRenderer getParent() {
        return this.parent;
    }

    @Override
    public void setAttributesAndStyles(Map<String, String> attributesAndStyles) {
        this.attributesAndStyles = attributesAndStyles;
    }

    @Override
    public String getAttribute(String key) {
        return this.attributesAndStyles.get(key);
    }

    @Override
    public void setAttribute(String key, String value) {
        if (this.attributesAndStyles == null) {
            this.attributesAndStyles = new HashMap<String, String>();
        }
        this.attributesAndStyles.put(key, value);
    }

    @Override
    public Map<String, String> getAttributeMapCopy() {
        HashMap<String, String> copy = new HashMap<String, String>();
        if (this.attributesAndStyles == null) {
            return copy;
        }
        copy.putAll(this.attributesAndStyles);
        return copy;
    }

    @Override
    public final void draw(SvgDrawContext context) {
        PdfCanvas currentCanvas = context.getCurrentCanvas();
        if (this.attributesAndStyles != null) {
            AffineTransform transformation;
            String transformString = this.attributesAndStyles.get("transform");
            if (transformString != null && !transformString.isEmpty() && !(transformation = TransformUtils.parseTransform(transformString)).isIdentity()) {
                currentCanvas.concatMatrix(transformation);
            }
            if (this.attributesAndStyles.containsKey("id")) {
                context.addUsedId(this.attributesAndStyles.get("id"));
            }
        }
        if (!this.drawInClipPath(context)) {
            this.preDraw(context);
            this.doDraw(context);
            this.postDraw(context);
        }
        if (this.attributesAndStyles.containsKey("id")) {
            context.removeUsedId(this.attributesAndStyles.get("id"));
        }
    }

    protected boolean canElementFill() {
        return true;
    }

    public boolean canConstructViewPort() {
        return false;
    }

    protected void deepCopyAttributesAndStyles(ISvgNodeRenderer deepCopy) {
        HashMap<String, String> stylesDeepCopy = new HashMap<String, String>();
        if (this.attributesAndStyles != null) {
            stylesDeepCopy.putAll(this.attributesAndStyles);
            deepCopy.setAttributesAndStyles(stylesDeepCopy);
        }
    }

    protected abstract void doDraw(SvgDrawContext var1);

    static float getAlphaFromRGBA(String value) {
        try {
            return WebColors.getRGBAColor(value)[3];
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            return 1.0f;
        }
    }

    AffineTransform calculateViewPortTranslation(SvgDrawContext context) {
        Rectangle viewPort = context.getCurrentViewPort();
        AffineTransform transform = AffineTransform.getTranslateInstance(viewPort.getX(), viewPort.getY());
        return transform;
    }

    void postDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            if (this.partOfClipPath) {
                if ("evenodd".equalsIgnoreCase(this.getAttribute("clip-rule"))) {
                    currentCanvas.eoClip();
                } else {
                    currentCanvas.clip();
                }
                currentCanvas.endPath();
            } else if (this.doFill && this.canElementFill()) {
                String fillRuleRawValue = this.getAttribute("fill-rule");
                if ("evenodd".equalsIgnoreCase(fillRuleRawValue)) {
                    if (this.doStroke) {
                        currentCanvas.eoFillStroke();
                    } else {
                        currentCanvas.eoFill();
                    }
                } else if (this.doStroke) {
                    currentCanvas.fillStroke();
                } else {
                    currentCanvas.fill();
                }
            } else if (this.doStroke) {
                currentCanvas.stroke();
            } else if (!TextSvgBranchRenderer.class.isInstance(this)) {
                currentCanvas.endPath();
            }
        }
    }

    void setPartOfClipPath(boolean value) {
        this.partOfClipPath = value;
    }

    void preDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            float generalOpacity = this.getOpacity();
            this.attributesAndStyles.put("opacity", String.valueOf(generalOpacity));
            PdfExtGState opacityGraphicsState = new PdfExtGState();
            if (!this.partOfClipPath) {
                String strokeRawValue;
                Color rgbColor;
                String fillRawValue = this.getAttribute("fill");
                boolean bl = this.doFill = !"none".equalsIgnoreCase(fillRawValue);
                if (this.doFill && this.canElementFill()) {
                    rgbColor = ColorConstants.BLACK;
                    float fillOpacity = generalOpacity;
                    if (fillRawValue != null) {
                        rgbColor = WebColors.getRGBColor(fillRawValue);
                    }
                    if (!CssUtils.compareFloats(fillOpacity, 1.0f)) {
                        opacityGraphicsState.setFillOpacity(generalOpacity);
                    }
                    currentCanvas.setFillColor(rgbColor);
                }
                if (!"none".equalsIgnoreCase(strokeRawValue = this.getAttribute("stroke")) && strokeRawValue != null) {
                    rgbColor = WebColors.getRGBColor(strokeRawValue);
                    float strokeOpacity = generalOpacity;
                    if (!CssUtils.compareFloats(strokeOpacity, 1.0f)) {
                        opacityGraphicsState.setStrokeOpacity(generalOpacity);
                    }
                    currentCanvas.setStrokeColor(rgbColor);
                    String strokeWidthRawValue = this.getAttribute("stroke-width");
                    float strokeWidth = 1.0f;
                    if (strokeWidthRawValue != null) {
                        strokeWidth = CssUtils.parseAbsoluteLength(strokeWidthRawValue);
                    }
                    currentCanvas.setLineWidth(strokeWidth);
                    this.doStroke = true;
                }
                if (!((PdfDictionary)opacityGraphicsState.getPdfObject()).isEmpty()) {
                    currentCanvas.setExtGState(opacityGraphicsState);
                }
            }
        }
    }

    private boolean drawInClipPath(SvgDrawContext context) {
        String clipPathName;
        ISvgNodeRenderer template;
        if (this.attributesAndStyles.containsKey("clip-path") && (template = context.getNamedObject(this.normalizeClipPathName(clipPathName = this.attributesAndStyles.get("clip-path")))) instanceof ClipPathSvgNodeRenderer) {
            ClipPathSvgNodeRenderer clipPath = (ClipPathSvgNodeRenderer)template.createDeepCopy();
            clipPath.setClippedRenderer(this);
            clipPath.draw(context);
            return !clipPath.getChildren().isEmpty();
        }
        return false;
    }

    private String normalizeClipPathName(String name) {
        return name.replace("url(#", "").replace(")", "").trim();
    }

    protected String normalizeName(String name) {
        return name.replace("#", "").trim();
    }

    private float getOpacity() {
        float result = 1.0f;
        String opacityValue = this.getAttribute("opacity");
        if (opacityValue != null && !"none".equalsIgnoreCase(opacityValue)) {
            result = Float.valueOf(opacityValue).floatValue();
        }
        return result;
    }

    protected FontInfo resolveFontName(String fontFamily, String fontWeight, String fontStyle, FontProvider provider, FontSet tempFonts) {
        boolean isBold = fontWeight != null && fontWeight.equalsIgnoreCase("bold");
        boolean isItalic = fontStyle != null && fontStyle.equalsIgnoreCase("italic");
        FontCharacteristics fontCharacteristics = new FontCharacteristics();
        ArrayList<String> stringArrayList = new ArrayList<String>();
        stringArrayList.add(fontFamily);
        fontCharacteristics.setBoldFlag(isBold);
        fontCharacteristics.setItalicFlag(isItalic);
        return provider.getFontSelector(stringArrayList, fontCharacteristics, tempFonts).bestMatch();
    }

    protected PdfFont resolveFont(SvgDrawContext context) {
        return this.resolveFont(context, null);
    }

    protected PdfFont resolveFont(SvgDrawContext context, String text) {
        FontProvider provider = context.getFontProvider();
        FontSet tempFonts = context.getTempFonts();
        PdfFont font = null;
        String fontFamily = this.attributesAndStyles.get("font-family");
        String fontWeight = this.attributesAndStyles.get("font-weight");
        String fontStyle = this.attributesAndStyles.get("font-style");
        businessLog.info("text = " + text);
        businessLog.info("fontFamily = " + fontFamily);
        fontFamily = fontFamily.replaceAll(" ", "");
        businessLog.info("replacedFontFamily = " + fontFamily);
        businessLog.info("fontWeight = " + fontWeight);
        businessLog.info("fontStyle = " + fontStyle);
        if (null == font && null != fontFamily) {
            String fontName = fontFamily;
            businessLog.info("fontName=" + fontName);
            try {
                if (PDFUtil.containsUCS4Glyph(text)) {
                    font = UCS4FontUtil.getInstance().subsetFont(text);
                    businessLog.info("font instance is created by UCS4");
                } else {
                    font = FontsFactory.getInstance().getSubSetFont(fontName, text);
                    if (null != font) {
                        businessLog.info("font instance is created by " + fontName);
                    }
                }
            }
            catch (Exception e) {
                businessLog.error("resolveFont failed", (Throwable)e);
            }
        }
        try {
            if (null == font) {
                font = FontUtil.getInstance().subsetFont(text);
                businessLog.info("Font instance is created by default Font text=" + text);
            }
        }
        catch (Exception e) {
            businessLog.error("resolveFont failed text= " + text, (Throwable)e);
        }
        return font;
    }

    AffineTransform calculateTransformation(SvgDrawContext context) {
        Rectangle viewPort = context.getCurrentViewPort();
        float horizontal = viewPort.getX();
        float vertical = viewPort.getY() + viewPort.getHeight();
        AffineTransform transform = AffineTransform.getTranslateInstance(0.0, 0.0);
        transform.concatenate(AffineTransform.getTranslateInstance(horizontal, vertical));
        transform.concatenate(new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, 0.0));
        return transform;
    }

    String getNumFromStr(String num, String attribute) throws SvgProcessingException {
        if (null != num) {
            String numRegex = "((-?[1-9][0-9]*([.][0-9]+)?)|(-?0([.][0-9]+)?))";
            Pattern p = Pattern.compile(numRegex);
            Matcher m = p.matcher(num);
            String numStr = null;
            if (!m.find()) {
                throw new SvgProcessingException("unable to find num in attribute:" + attribute + ", attribute's value=" + num);
            }
            numStr = m.group();
            return numStr;
        }
        return "0";
    }
}

