/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.sdk;

import cfca.paperless.base.util.FileUtil;
import cfca.paperless.base.util.ProofHashUtil;
import cfca.paperless.base.util.StringUtil;
import cfca.paperless.client.util.CheckPdfUtil;
import cfca.paperless.dto.ResponseHead;
import cfca.paperless.dto.bean.PdfBean;
import cfca.paperless.dto.request.requestbody.tx10.ConcatPdfListRequestBody;
import cfca.paperless.dto.request.tx10.ConcatPdfListRequest;
import cfca.paperless.dto.response.responsebody.tx10.ConcatPdfListResponseBody;
import cfca.paperless.dto.response.tx10.ConcatPdfListResponse;
import cfca.sadk.seal.base.util.PDFUtil;
import cfca.sadk.seal.util.PDFMergeUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcatPdfListProcess {
    private static final Logger logger = LoggerFactory.getLogger(ConcatPdfListProcess.class);

    public ConcatPdfListResponse process(ConcatPdfListRequest requestBean) throws Exception {
        long start = System.currentTimeMillis();
        logger.info("ConcatPdfListProcess.process start.");
        ConcatPdfListRequestBody requestBody = requestBean.getBody();
        List pdfBeans = requestBody.getPdfBeans();
        for (PdfBean bean : pdfBeans) {
            byte[] pdfData = new byte[]{};
            if (!"1".equals(bean.getInputType()) && !"2".equals(bean.getInputType())) {
                throw new Exception("inputType");
            }
            if ("1".equals(bean.getInputType())) {
                if (StringUtil.isEmpty((String)bean.getInputSource())) {
                    throw new Exception(" inputSource is null");
                }
                pdfData = FileUtils.readFileToByteArray((File)new File(bean.getInputSource()));
                if (pdfData == null) {
                    throw new Exception(" pdfData is null");
                }
                bean.setPdfData(pdfData);
            } else if ("2".equals(bean.getInputType()) && (pdfData = bean.getPdfData()) == null) {
                throw new Exception(" pdfData is null");
            }
            CheckPdfUtil.checkPdfData(pdfData, false);
            int pageCount = PDFUtil.getPageNums((byte[])pdfData);
            logger.info("PDF\u6587\u4ef6\u9875\u6570\uff1a" + pageCount);
        }
        int pdfsNum = pdfBeans.size();
        logger.info("\u5f85\u5408\u6210pdf\u6587\u6863\u4e2a\u6570" + pdfsNum);
        String outputFolder = System.getProperty("java.io.tmpdir");
        ArrayList<Object> pdfList = new ArrayList<Object>();
        String tmpOutputPdfFile = outputFolder + File.separator + UUID.randomUUID().toString() + ".pdf";
        ArrayList<String> tmpFileList = new ArrayList<String>();
        for (int i = 0; i < pdfsNum; ++i) {
            try {
                PdfBean pdfBean = (PdfBean)pdfBeans.get(i);
                String tmpInputPdfFile = outputFolder + File.separator + UUID.randomUUID().toString() + ".pdf";
                FileUtil.saveDataToFile((byte[])pdfBean.getPdfData(), (String)tmpInputPdfFile);
                HashMap pdfMap = new HashMap();
                pdfMap.put("srcInputFilePath", tmpInputPdfFile);
                pdfList.add(pdfMap);
                tmpFileList.add(tmpInputPdfFile);
                continue;
            }
            catch (Exception e) {
                throw new Exception("\u7b2c" + (i + 1) + "\u4e2aPDF\u64cd\u4f5c\u5f02\u5e38", e);
            }
        }
        FileOutputStream outputStream = new FileOutputStream(tmpOutputPdfFile);
        PDFMergeUtil.mergeMultiPDF(pdfList, (OutputStream)outputStream);
        byte[] pdfData = new byte[]{};
        File pdfFile = new File(tmpOutputPdfFile);
        if (null != pdfFile && pdfFile.exists()) {
            pdfData = FileUtils.readFileToByteArray((File)pdfFile);
        }
        FileUtil.deleteSingleFile((String)tmpOutputPdfFile);
        for (String path : tmpFileList) {
            FileUtil.deleteSingleFile((String)path);
        }
        String pdfFileDataHash = ProofHashUtil.digestAndHex((byte[])pdfData);
        ResponseHead head = new ResponseHead();
        head.setTransactionNo(requestBean.getHead().getTransactionNo());
        ConcatPdfListResponseBody body = new ConcatPdfListResponseBody();
        body.setPdf(pdfData);
        body.setPdfFileDataHash(pdfFileDataHash);
        ConcatPdfListResponse responseBean = new ConcatPdfListResponse();
        responseBean.setHead(head);
        responseBean.setBody(body);
        long end = System.currentTimeMillis();
        logger.info("ConcatPdfListProcess.process end. time-taken={}ms", (Object)(end - start));
        return responseBean;
    }
}

