/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.svg.renderers;

import cfca.sadk.com.itextpdf.kernel.geom.AffineTransform;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.layout.font.FontProvider;
import cfca.sadk.com.itextpdf.layout.font.FontSet;
import cfca.sadk.com.itextpdf.styledxmlparser.resolver.font.BasicFontProvider;
import cfca.sadk.com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import cfca.sadk.com.itextpdf.svg.exceptions.SvgProcessingException;
import cfca.sadk.com.itextpdf.svg.renderers.ISvgNodeRenderer;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class SvgDrawContext {
    private final Map<String, ISvgNodeRenderer> namedObjects = new HashMap<String, ISvgNodeRenderer>();
    private final Stack<PdfCanvas> canvases = new Stack();
    private final Stack<Rectangle> viewports = new Stack();
    private final Stack<String> useIds = new Stack();
    private ResourceResolver resourceResolver;
    private FontProvider fontProvider;
    private FontSet tempFonts;
    private AffineTransform lastTextTransform = new AffineTransform();
    private float[] textMove = new float[]{0.0f, 0.0f};

    public SvgDrawContext(ResourceResolver resourceResolver, FontProvider fontProvider) {
        if (resourceResolver == null) {
            resourceResolver = new ResourceResolver("");
        }
        this.resourceResolver = resourceResolver;
        if (fontProvider == null) {
            fontProvider = new BasicFontProvider();
        }
        this.fontProvider = fontProvider;
    }

    public PdfCanvas getCurrentCanvas() {
        return this.canvases.peek();
    }

    public PdfCanvas popCanvas() {
        return this.canvases.pop();
    }

    public void pushCanvas(PdfCanvas canvas) {
        this.canvases.push(canvas);
    }

    public int size() {
        return this.canvases.size();
    }

    public void addViewPort(Rectangle viewPort) {
        this.viewports.push(viewPort);
    }

    public Rectangle getCurrentViewPort() {
        return this.viewports.peek();
    }

    public void removeCurrentViewPort() {
        if (this.viewports.size() > 0) {
            this.viewports.pop();
        }
    }

    public void addNamedObject(String name, ISvgNodeRenderer namedObject) {
        if (namedObject == null) {
            throw new SvgProcessingException("A named object can't be null.");
        }
        if (name == null || name.isEmpty()) {
            throw new SvgProcessingException("The name of the named object can't be null or empty.");
        }
        if (!this.namedObjects.containsKey(name)) {
            this.namedObjects.put(name, namedObject);
        }
    }

    public ISvgNodeRenderer getNamedObject(String name) {
        return this.namedObjects.get(name);
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void addNamedObjects(Map<String, ISvgNodeRenderer> namedObjects) {
        this.namedObjects.putAll(namedObjects);
    }

    public FontProvider getFontProvider() {
        return this.fontProvider;
    }

    public FontSet getTempFonts() {
        return this.tempFonts;
    }

    public void setTempFonts(FontSet tempFonts) {
        this.tempFonts = tempFonts;
    }

    public boolean isIdUsedByUseTagBefore(String elementId) {
        return this.useIds.contains(elementId);
    }

    public void addUsedId(String elementId) {
        this.useIds.push(elementId);
    }

    public void removeUsedId(String elementId) {
        this.useIds.pop();
    }

    public AffineTransform getLastTextTransform() {
        if (this.lastTextTransform == null) {
            this.lastTextTransform = new AffineTransform();
        }
        return this.lastTextTransform;
    }

    public void setLastTextTransform(AffineTransform newTransform) {
        this.lastTextTransform = newTransform;
    }

    public float[] getTextMove() {
        return this.textMove;
    }

    public void resetTextMove() {
        this.textMove = new float[]{0.0f, 0.0f};
    }

    public void addTextMove(float additionalMoveX, float additionalMoveY) {
        this.textMove[0] = this.textMove[0] + additionalMoveX;
        this.textMove[1] = this.textMove[1] + additionalMoveY;
    }
}

