/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.sadk.com.itextpdf.signatures.ITSAClient;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.cmp.PKIStatusInfo;
import cfca.sadk.org.bouncycastle.asn1.tsp.TimeStampResp;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.timestamp.client.TimestampFactory;
import cfca.sadk.timestamp.client.api.Timestamp;
import cfca.sadk.timestamp.client.api.TimestampClient;
import cfca.sadk.timestamp.client.api.TimestampConfig;
import cfca.sadk.timestamp.client.bean.HashAlgorithm;
import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Date;

public class CFCATSAClient
implements ITSAClient {
    private HashAlgorithm hashAlg;
    private TimestampClient client = null;
    private byte[] contentInfoBytes = null;
    private Date signTime = null;

    public CFCATSAClient(HashAlgorithm hashAlg, TimestampConfig config) throws TSAException {
        if (config == null) {
            throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalid, "TimestampConfig can not be null");
        }
        this.hashAlg = hashAlg;
        this.client = TimestampFactory.newTimestampClient((TimestampConfig)config);
    }

    @Override
    public MessageDigest getMessageDigest() throws GeneralSecurityException {
        return MessageDigest.getInstance(this.hashAlg.name, BouncyCastleProvider.getCFCAProviderName());
    }

    @Override
    public byte[] getTimeStampToken(byte[] imprint) throws Exception {
        TimeStampResp timestampResp;
        if (this.client == null) {
            throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalid, "TimestampClient can not be null");
        }
        Timestamp timestamp = this.client.requestTimestamp(this.hashAlg, imprint);
        try {
            timestampResp = TimeStampResp.getInstance((Object)timestamp.getTimestampResponseBytes());
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalid, "timestamp TSASignedData decode failure", (Throwable)e);
        }
        PKIStatusInfo statusInfo = timestampResp.getStatus();
        BigInteger statusCode = statusInfo.getStatus();
        if (statusCode.intValue() != 0) {
            DERBitString failInfo = statusInfo.getFailInfo();
            if (null != failInfo) {
                throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalid, new String(failInfo.getBytes(), "UTF8"));
            }
            throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalid, "timestamp statusCode is " + statusCode.intValue());
        }
        if (timestampResp.getTimeStampToken() == null) {
            throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalid, "TimeStampToken is null");
        }
        this.signTime = timestamp.getTimestampTime();
        this.contentInfoBytes = timestampResp.getTimeStampToken().getEncoded();
        return this.contentInfoBytes;
    }

    @Override
    public int getTokenSizeEstimate() {
        if (this.contentInfoBytes != null) {
            return this.contentInfoBytes.length + 32;
        }
        return 4096;
    }

    @Override
    public Date getSignTime() {
        return this.signTime;
    }
}

