/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature.rsa;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.parser.ASN1Node;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.jni.JNIDigest;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.Mechanisms;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RSAHashUtil {
    static final int fileBufferSize = 65536;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] calculateDigest(String digestAlgorithm, InputStream sourceFileStream, Session session) throws Exception {
        byte[] digest = null;
        if (sourceFileStream == null) {
            return null;
        }
        Digest engine = null;
        BufferedInputStream bfis = new BufferedInputStream(sourceFileStream);
        try {
            engine = RSAHashUtil.instanceDigestEngine(digestAlgorithm, session);
            int buffer_size = 65536;
            byte[] buffer = new byte[buffer_size];
            int readTotalLen = bfis.read(buffer);
            if (readTotalLen == -1) {
                throw new Exception("the source data is null!");
            }
            do {
                engine.update(buffer, 0, readTotalLen);
            } while ((readTotalLen = bfis.read(buffer)) != -1);
            digest = new byte[engine.getDigestSize()];
            engine.doFinal(digest, 0);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            JNIDigest.destroy(engine);
            if (bfis != null) {
                bfis.close();
            }
            throw throwable;
        }
        JNIDigest.destroy(engine);
        if (bfis != null) {
            bfis.close();
        }
        return digest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] calculateDigest(String digestAlgorithm, ASN1Node sourceNode, String generate_sourceFilePath, Session session) throws Exception {
        if (sourceNode == null) {
            return null;
        }
        long startPos = sourceNode.valueStartPos;
        long dataLength = sourceNode.valueLength;
        String signedFilePath = sourceNode.f.getAbsolutePath();
        RandomAccessFile bfis = null;
        FileOutputStream gen_fos = null;
        Digest engine = null;
        byte[] digest = null;
        try {
            engine = RSAHashUtil.instanceDigestEngine(digestAlgorithm, session);
            bfis = new RandomAccessFile(new File(signedFilePath), "r");
            bfis.seek(startPos);
            if (generate_sourceFilePath != null && !generate_sourceFilePath.trim().equals("")) {
                gen_fos = new FileOutputStream(generate_sourceFilePath);
            }
            if (dataLength > 65536L) {
                int readLen;
                byte[] buffer = new byte[65536];
                for (long readTotalLen = 0L; (readLen = bfis.read(buffer)) > 0 && readTotalLen < dataLength; readTotalLen += (long)readLen) {
                    if (readTotalLen + (long)readLen <= dataLength) {
                        engine.update(buffer, 0, readLen);
                        FileHelper.writeBytesToFile(buffer, 0, readLen, gen_fos);
                        continue;
                    }
                    int left = (int)(dataLength - readTotalLen);
                    engine.update(buffer, 0, left);
                    FileHelper.writeBytesToFile(buffer, 0, left, gen_fos);
                    break;
                }
            } else {
                byte[] buffer = new byte[(int)dataLength];
                int readLength = bfis.read(buffer);
                engine.update(buffer, 0, readLength);
                FileHelper.writeBytesToFile(buffer, 0, readLength, gen_fos);
            }
            digest = new byte[engine.getDigestSize()];
            engine.doFinal(digest, 0);
            Object var19_17 = null;
        }
        catch (Throwable throwable) {
            Object var19_18 = null;
            JNIDigest.destroy(engine);
            FileHelper.closedStream(gen_fos, "calculateDigest for " + signedFilePath);
            if (bfis != null) {
                bfis.close();
            }
            throw throwable;
        }
        JNIDigest.destroy(engine);
        FileHelper.closedStream(gen_fos, "calculateDigest for " + signedFilePath);
        if (bfis != null) {
            bfis.close();
        }
        return digest;
    }

    private static Digest instanceDigestEngine(String digestAlgorithm, Session session) throws PKIException {
        int hashID;
        if (digestAlgorithm == null) {
            throw new PKIException("InstanceDigestEngine failed: digestAlgorithm==null");
        }
        Mechanism mechanism = new Mechanism(digestAlgorithm);
        boolean jniFlag = session != null && session.useJniNativeOperation();
        Digest engine = null;
        if (jniFlag && (hashID = Mechanisms.getHashID(mechanism)) != 0) {
            engine = new JNIDigest(hashID);
        }
        if (engine == null && (engine = Mechanisms.getDigest(mechanism)) == null) {
            throw new PKIException("InstanceDigestEngine failed: do not support this algorithm:" + mechanism);
        }
        return engine;
    }
}

