/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.io.image;

import cfca.sadk.com.itextpdf.io.IOException;
import cfca.sadk.com.itextpdf.io.codec.CCITTG4Encoder;
import cfca.sadk.com.itextpdf.io.codec.TIFFFaxDecoder;
import cfca.sadk.com.itextpdf.io.image.AwtImageDataFactory;
import cfca.sadk.com.itextpdf.io.image.BmpImageData;
import cfca.sadk.com.itextpdf.io.image.BmpImageHelper;
import cfca.sadk.com.itextpdf.io.image.GifImageData;
import cfca.sadk.com.itextpdf.io.image.GifImageHelper;
import cfca.sadk.com.itextpdf.io.image.ImageData;
import cfca.sadk.com.itextpdf.io.image.ImageType;
import cfca.sadk.com.itextpdf.io.image.Jbig2ImageData;
import cfca.sadk.com.itextpdf.io.image.Jbig2ImageHelper;
import cfca.sadk.com.itextpdf.io.image.Jpeg2000ImageData;
import cfca.sadk.com.itextpdf.io.image.Jpeg2000ImageHelper;
import cfca.sadk.com.itextpdf.io.image.JpegImageData;
import cfca.sadk.com.itextpdf.io.image.JpegImageHelper;
import cfca.sadk.com.itextpdf.io.image.PngImageData;
import cfca.sadk.com.itextpdf.io.image.PngImageHelper;
import cfca.sadk.com.itextpdf.io.image.RawImageData;
import cfca.sadk.com.itextpdf.io.image.TiffImageData;
import cfca.sadk.com.itextpdf.io.image.TiffImageHelper;
import cfca.sadk.com.itextpdf.io.util.UrlUtil;
import java.awt.Color;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ImageDataFactory {
    private static final byte[] gif = new byte[]{71, 73, 70};
    private static final byte[] jpeg = new byte[]{-1, -40};
    private static final byte[] jpeg2000_1 = new byte[]{0, 0, 0, 12};
    private static final byte[] jpeg2000_2 = new byte[]{-1, 79, -1, 81};
    private static final byte[] png = new byte[]{-119, 80, 78, 71};
    private static final byte[] wmf = new byte[]{-41, -51};
    private static final byte[] bmp = new byte[]{66, 77};
    private static final byte[] tiff_1 = new byte[]{77, 77, 0, 42};
    private static final byte[] tiff_2 = new byte[]{73, 73, 42, 0};
    private static final byte[] jbig2 = new byte[]{-105, 74, 66, 50, 13, 10, 26, 10};

    private ImageDataFactory() {
    }

    public static ImageData create(byte[] bytes, boolean recoverImage) {
        return ImageDataFactory.createImageInstance(bytes, recoverImage);
    }

    public static ImageData create(byte[] bytes) {
        return ImageDataFactory.create(bytes, false);
    }

    public static ImageData create(URL url, boolean recoverImage) {
        return ImageDataFactory.createImageInstance(url, recoverImage);
    }

    public static ImageData create(URL url) {
        return ImageDataFactory.create(url, false);
    }

    public static ImageData create(String filename, boolean recoverImage) throws MalformedURLException {
        return ImageDataFactory.create(UrlUtil.toURL(filename), recoverImage);
    }

    public static ImageData create(String filename) throws MalformedURLException {
        return ImageDataFactory.create(filename, false);
    }

    public static ImageData create(int width, int height, boolean reverseBits, int typeCCITT, int parameters, byte[] data, int[] transparency) {
        if (transparency != null && transparency.length != 2) {
            throw new IOException("Transparency length must be equal to 2 with CCITT images");
        }
        if (typeCCITT != 256 && typeCCITT != 257 && typeCCITT != 258) {
            throw new IOException("CCITT compression type must be CCITTG4, CCITTG3_1D or CCITTG3_2D.");
        }
        if (reverseBits) {
            TIFFFaxDecoder.reverseBits(data);
        }
        RawImageData image = new RawImageData(data, ImageType.RAW);
        image.setTypeCcitt(typeCCITT);
        image.height = height;
        image.width = width;
        image.colorSpace = parameters;
        image.transparency = transparency;
        return image;
    }

    public static ImageData create(int width, int height, int components, int bpc, byte[] data, int[] transparency) {
        if (transparency != null && transparency.length != components * 2) {
            throw new IOException("Transparency length must be equal to 2 with CCITT images");
        }
        if (components == 1 && bpc == 1) {
            byte[] g4 = CCITTG4Encoder.compress(data, width, height);
            return ImageDataFactory.create(width, height, false, 256, 1, g4, transparency);
        }
        RawImageData image = new RawImageData(data, ImageType.RAW);
        image.height = height;
        image.width = width;
        if (components != 1 && components != 3 && components != 4) {
            throw new IOException("Components must be 1, 3 or 4.");
        }
        if (bpc != 1 && bpc != 2 && bpc != 4 && bpc != 8) {
            throw new IOException("Bits per component must be 1, 2, 4 or 8.");
        }
        image.colorSpace = components;
        image.bpc = bpc;
        image.data = data;
        image.transparency = transparency;
        return image;
    }

    public static ImageData create(Image image, Color color) throws java.io.IOException {
        return ImageDataFactory.create(image, color, false);
    }

    public static ImageData create(Image image, Color color, boolean forceBW) throws java.io.IOException {
        return AwtImageDataFactory.create(image, color, forceBW);
    }

    public static ImageData createBmp(URL url, boolean noHeader, int size) {
        byte[] imageType = ImageDataFactory.readImageType(url);
        if (ImageDataFactory.imageTypeIs(imageType, bmp)) {
            BmpImageData image = new BmpImageData(url, noHeader, size);
            BmpImageHelper.processImage(image);
            return image;
        }
        throw new IllegalArgumentException("BMP image expected.");
    }

    public static ImageData createBmp(byte[] bytes, boolean noHeader, int size) {
        byte[] imageType = ImageDataFactory.readImageType(bytes);
        if (noHeader || ImageDataFactory.imageTypeIs(imageType, bmp)) {
            BmpImageData image = new BmpImageData(bytes, noHeader, size);
            BmpImageHelper.processImage(image);
            return image;
        }
        throw new IllegalArgumentException("BMP image expected.");
    }

    public static GifImageData createGif(byte[] bytes) {
        byte[] imageType = ImageDataFactory.readImageType(bytes);
        if (ImageDataFactory.imageTypeIs(imageType, gif)) {
            GifImageData image = new GifImageData(bytes);
            GifImageHelper.processImage(image);
            return image;
        }
        throw new IllegalArgumentException("GIF image expected.");
    }

    public static ImageData createGifFrame(URL url, int frame) {
        byte[] imageType = ImageDataFactory.readImageType(url);
        if (ImageDataFactory.imageTypeIs(imageType, gif)) {
            GifImageData image = new GifImageData(url);
            GifImageHelper.processImage(image, frame - 1);
            return image.getFrames().get(frame - 1);
        }
        throw new IllegalArgumentException("GIF image expected.");
    }

    public static ImageData createGifFrame(byte[] bytes, int frame) {
        byte[] imageType = ImageDataFactory.readImageType(bytes);
        if (ImageDataFactory.imageTypeIs(imageType, gif)) {
            GifImageData image = new GifImageData(bytes);
            GifImageHelper.processImage(image, frame - 1);
            return image.getFrames().get(frame - 1);
        }
        throw new IllegalArgumentException("GIF image expected.");
    }

    public static List<ImageData> createGifFrames(byte[] bytes, int[] frameNumbers) {
        byte[] imageType = ImageDataFactory.readImageType(bytes);
        if (ImageDataFactory.imageTypeIs(imageType, gif)) {
            GifImageData image = new GifImageData(bytes);
            Arrays.sort(frameNumbers);
            GifImageHelper.processImage(image, frameNumbers[frameNumbers.length - 1] - 1);
            ArrayList<ImageData> frames = new ArrayList<ImageData>();
            for (int frame : frameNumbers) {
                frames.add(image.getFrames().get(frame - 1));
            }
            return frames;
        }
        throw new IllegalArgumentException("GIF image expected.");
    }

    public static List<ImageData> createGifFrames(URL url, int[] frameNumbers) {
        byte[] imageType = ImageDataFactory.readImageType(url);
        if (ImageDataFactory.imageTypeIs(imageType, gif)) {
            GifImageData image = new GifImageData(url);
            Arrays.sort(frameNumbers);
            GifImageHelper.processImage(image, frameNumbers[frameNumbers.length - 1] - 1);
            ArrayList<ImageData> frames = new ArrayList<ImageData>();
            for (int frame : frameNumbers) {
                frames.add(image.getFrames().get(frame - 1));
            }
            return frames;
        }
        throw new IllegalArgumentException("GIF image expected.");
    }

    public static List<ImageData> createGifFrames(byte[] bytes) {
        byte[] imageType = ImageDataFactory.readImageType(bytes);
        if (ImageDataFactory.imageTypeIs(imageType, gif)) {
            GifImageData image = new GifImageData(bytes);
            GifImageHelper.processImage(image);
            return image.getFrames();
        }
        throw new IllegalArgumentException("GIF image expected.");
    }

    public static List<ImageData> createGifFrames(URL url) {
        byte[] imageType = ImageDataFactory.readImageType(url);
        if (ImageDataFactory.imageTypeIs(imageType, gif)) {
            GifImageData image = new GifImageData(url);
            GifImageHelper.processImage(image);
            return image.getFrames();
        }
        throw new IllegalArgumentException("GIF image expected.");
    }

    public static ImageData createJbig2(URL url, int page) {
        if (page < 1) {
            throw new IllegalArgumentException("The page number must be greater than 0");
        }
        byte[] imageType = ImageDataFactory.readImageType(url);
        if (ImageDataFactory.imageTypeIs(imageType, jbig2)) {
            Jbig2ImageData image = new Jbig2ImageData(url, page);
            Jbig2ImageHelper.processImage(image);
            return image;
        }
        throw new IllegalArgumentException("JBIG2 image expected.");
    }

    public static ImageData createJbig2(byte[] bytes, int page) {
        if (page < 1) {
            throw new IllegalArgumentException("The page number must be greater than 0");
        }
        byte[] imageType = ImageDataFactory.readImageType(bytes);
        if (ImageDataFactory.imageTypeIs(imageType, jbig2)) {
            Jbig2ImageData image = new Jbig2ImageData(bytes, page);
            Jbig2ImageHelper.processImage(image);
            return image;
        }
        throw new IllegalArgumentException("JBIG2 image expected.");
    }

    public static ImageData createJpeg(URL url) {
        byte[] imageType = ImageDataFactory.readImageType(url);
        if (ImageDataFactory.imageTypeIs(imageType, jpeg)) {
            JpegImageData image = new JpegImageData(url);
            JpegImageHelper.processImage(image);
            return image;
        }
        throw new IllegalArgumentException("JPEG image expected.");
    }

    public static ImageData createJpeg(byte[] bytes) {
        byte[] imageType = ImageDataFactory.readImageType(bytes);
        if (ImageDataFactory.imageTypeIs(imageType, jpeg)) {
            JpegImageData image = new JpegImageData(bytes);
            JpegImageHelper.processImage(image);
            return image;
        }
        throw new IllegalArgumentException("JPEG image expected.");
    }

    public static ImageData createJpeg2000(URL url) {
        byte[] imageType = ImageDataFactory.readImageType(url);
        if (ImageDataFactory.imageTypeIs(imageType, jpeg2000_1) || ImageDataFactory.imageTypeIs(imageType, jpeg2000_2)) {
            Jpeg2000ImageData image = new Jpeg2000ImageData(url);
            Jpeg2000ImageHelper.processImage(image);
            return image;
        }
        throw new IllegalArgumentException("JPEG2000 image expected.");
    }

    public static ImageData createJpeg2000(byte[] bytes) {
        byte[] imageType = ImageDataFactory.readImageType(bytes);
        if (ImageDataFactory.imageTypeIs(imageType, jpeg2000_1) || ImageDataFactory.imageTypeIs(imageType, jpeg2000_2)) {
            Jpeg2000ImageData image = new Jpeg2000ImageData(bytes);
            Jpeg2000ImageHelper.processImage(image);
            return image;
        }
        throw new IllegalArgumentException("JPEG2000 image expected.");
    }

    public static ImageData createPng(URL url) {
        byte[] imageType = ImageDataFactory.readImageType(url);
        if (ImageDataFactory.imageTypeIs(imageType, png)) {
            PngImageData image = new PngImageData(url);
            PngImageHelper.processImage(image);
            return image;
        }
        throw new IllegalArgumentException("PNG image expected.");
    }

    public static ImageData createPng(byte[] bytes) {
        byte[] imageType = ImageDataFactory.readImageType(bytes);
        if (ImageDataFactory.imageTypeIs(imageType, png)) {
            PngImageData image = new PngImageData(bytes);
            PngImageHelper.processImage(image);
            return image;
        }
        throw new IllegalArgumentException("PNG image expected.");
    }

    public static ImageData createTiff(URL url, boolean recoverFromImageError, int page, boolean direct) {
        byte[] imageType = ImageDataFactory.readImageType(url);
        if (ImageDataFactory.imageTypeIs(imageType, tiff_1) || ImageDataFactory.imageTypeIs(imageType, tiff_2)) {
            TiffImageData image = new TiffImageData(url, recoverFromImageError, page, direct);
            TiffImageHelper.processImage(image);
            return image;
        }
        throw new IllegalArgumentException("TIFF image expected.");
    }

    public static ImageData createTiff(byte[] bytes, boolean recoverFromImageError, int page, boolean direct) {
        byte[] imageType = ImageDataFactory.readImageType(bytes);
        if (ImageDataFactory.imageTypeIs(imageType, tiff_1) || ImageDataFactory.imageTypeIs(imageType, tiff_2)) {
            TiffImageData image = new TiffImageData(bytes, recoverFromImageError, page, direct);
            TiffImageHelper.processImage(image);
            return image;
        }
        throw new IllegalArgumentException("TIFF image expected.");
    }

    public static ImageData createRawImage(byte[] bytes) {
        return new RawImageData(bytes, ImageType.RAW);
    }

    public static boolean isSupportedType(byte[] source) {
        if (source == null) {
            return false;
        }
        byte[] imageType = ImageDataFactory.readImageType(source);
        return ImageDataFactory.imageTypeIs(imageType, gif) || ImageDataFactory.imageTypeIs(imageType, jpeg) || ImageDataFactory.imageTypeIs(imageType, jpeg2000_1) || ImageDataFactory.imageTypeIs(imageType, jpeg2000_2) || ImageDataFactory.imageTypeIs(imageType, png) || ImageDataFactory.imageTypeIs(imageType, bmp) || ImageDataFactory.imageTypeIs(imageType, tiff_1) || ImageDataFactory.imageTypeIs(imageType, tiff_2) || ImageDataFactory.imageTypeIs(imageType, jbig2);
    }

    public static boolean isPNGType(byte[] source) {
        if (source == null) {
            return false;
        }
        byte[] imageType = ImageDataFactory.readImageType(source);
        return ImageDataFactory.imageTypeIs(imageType, png);
    }

    public static boolean isSupportedType(URL source) {
        if (source == null) {
            return false;
        }
        byte[] imageType = ImageDataFactory.readImageType(source);
        return ImageDataFactory.imageTypeIs(imageType, gif) || ImageDataFactory.imageTypeIs(imageType, jpeg) || ImageDataFactory.imageTypeIs(imageType, jpeg2000_1) || ImageDataFactory.imageTypeIs(imageType, jpeg2000_2) || ImageDataFactory.imageTypeIs(imageType, png) || ImageDataFactory.imageTypeIs(imageType, bmp) || ImageDataFactory.imageTypeIs(imageType, tiff_1) || ImageDataFactory.imageTypeIs(imageType, tiff_2) || ImageDataFactory.imageTypeIs(imageType, jbig2);
    }

    private static ImageData createImageInstance(URL source, boolean recoverImage) {
        byte[] imageType = ImageDataFactory.readImageType(source);
        if (ImageDataFactory.imageTypeIs(imageType, gif)) {
            GifImageData image = new GifImageData(source);
            GifImageHelper.processImage(image, 0);
            return image.getFrames().get(0);
        }
        if (ImageDataFactory.imageTypeIs(imageType, jpeg)) {
            JpegImageData image = new JpegImageData(source);
            JpegImageHelper.processImage(image);
            return image;
        }
        if (ImageDataFactory.imageTypeIs(imageType, jpeg2000_1) || ImageDataFactory.imageTypeIs(imageType, jpeg2000_2)) {
            Jpeg2000ImageData image = new Jpeg2000ImageData(source);
            Jpeg2000ImageHelper.processImage(image);
            return image;
        }
        if (ImageDataFactory.imageTypeIs(imageType, png)) {
            PngImageData image = new PngImageData(source);
            PngImageHelper.processImage(image);
            return image;
        }
        if (ImageDataFactory.imageTypeIs(imageType, bmp)) {
            BmpImageData image = new BmpImageData(source, false, 0);
            BmpImageHelper.processImage(image);
            return image;
        }
        if (ImageDataFactory.imageTypeIs(imageType, tiff_1) || ImageDataFactory.imageTypeIs(imageType, tiff_2)) {
            TiffImageData image = new TiffImageData(source, recoverImage, 1, false);
            TiffImageHelper.processImage(image);
            return image;
        }
        if (ImageDataFactory.imageTypeIs(imageType, jbig2)) {
            Jbig2ImageData image = new Jbig2ImageData(source, 1);
            Jbig2ImageHelper.processImage(image);
            return image;
        }
        throw new IOException("Image format cannot be recognized.");
    }

    private static ImageData createImageInstance(byte[] bytes, boolean recoverImage) {
        byte[] imageType = ImageDataFactory.readImageType(bytes);
        if (ImageDataFactory.imageTypeIs(imageType, gif)) {
            GifImageData image = new GifImageData(bytes);
            GifImageHelper.processImage(image, 0);
            return image.getFrames().get(0);
        }
        if (ImageDataFactory.imageTypeIs(imageType, jpeg)) {
            JpegImageData image = new JpegImageData(bytes);
            JpegImageHelper.processImage(image);
            return image;
        }
        if (ImageDataFactory.imageTypeIs(imageType, jpeg2000_1) || ImageDataFactory.imageTypeIs(imageType, jpeg2000_2)) {
            Jpeg2000ImageData image = new Jpeg2000ImageData(bytes);
            Jpeg2000ImageHelper.processImage(image);
            return image;
        }
        if (ImageDataFactory.imageTypeIs(imageType, png)) {
            PngImageData image = new PngImageData(bytes);
            PngImageHelper.processImage(image);
            return image;
        }
        if (ImageDataFactory.imageTypeIs(imageType, bmp)) {
            BmpImageData image = new BmpImageData(bytes, false, 0);
            BmpImageHelper.processImage(image);
            return image;
        }
        if (ImageDataFactory.imageTypeIs(imageType, tiff_1) || ImageDataFactory.imageTypeIs(imageType, tiff_2)) {
            TiffImageData image = new TiffImageData(bytes, recoverImage, 1, false);
            TiffImageHelper.processImage(image);
            return image;
        }
        if (ImageDataFactory.imageTypeIs(imageType, jbig2)) {
            Jbig2ImageData image = new Jbig2ImageData(bytes, 1);
            Jbig2ImageHelper.processImage(image);
            return image;
        }
        throw new IOException("Image format cannot be recognized.");
    }

    private static boolean imageTypeIs(byte[] imageType, byte[] compareWith) {
        for (int i = 0; i < compareWith.length; ++i) {
            if (imageType[i] == compareWith[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] readImageType(URL source) {
        InputStream stream = null;
        try {
            stream = UrlUtil.openStream(source);
            byte[] bytes = new byte[8];
            stream.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (java.io.IOException e) {
            throw new IOException("I/O exception.", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (java.io.IOException iOException) {}
            }
        }
    }

    private static byte[] readImageType(byte[] source) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(source);
            byte[] bytes = new byte[8];
            stream.read(bytes);
            return bytes;
        }
        catch (java.io.IOException e) {
            return null;
        }
    }
}

