/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.styledxmlparser.resolver.resource;

import cfca.sadk.com.itextpdf.styledxmlparser.exceptions.StyledXMLParserException;
import java.io.CharArrayWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.BitSet;

class UriEncodeUtil {
    private static BitSet unreservedAndReserved;
    private static final int caseDiff = 32;
    private static String dfltEncName;

    UriEncodeUtil() {
    }

    public static String encode(String s) {
        return UriEncodeUtil.encode(s, dfltEncName);
    }

    public static String encode(String s, String enc) {
        Charset charset;
        boolean needToChange = false;
        StringBuffer out = new StringBuffer(s.length());
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        if (enc == null) {
            throw new StyledXMLParserException("Unsupported encoding exception.");
        }
        try {
            charset = Charset.forName(enc);
        }
        catch (IllegalCharsetNameException e) {
            throw new StyledXMLParserException("Unsupported encoding exception.");
        }
        int i = 0;
        boolean firstHash = true;
        while (i < s.length()) {
            char c = s.charAt(i);
            if ('\\' == c) {
                out.append('/');
                needToChange = true;
                ++i;
                continue;
            }
            if ('%' == c) {
                int v = -1;
                if (i + 2 < s.length()) {
                    try {
                        v = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                    }
                    catch (NumberFormatException e) {
                        v = -1;
                    }
                    if (v >= 0) {
                        out.append(c);
                    }
                }
                if (v < 0) {
                    needToChange = true;
                    out.append("%25");
                }
                ++i;
                continue;
            }
            if ('#' == c) {
                if (firstHash) {
                    out.append(c);
                    firstHash = false;
                } else {
                    out.append("%23");
                    needToChange = true;
                }
                ++i;
                continue;
            }
            if (unreservedAndReserved.get(c)) {
                out.append(c);
                ++i;
                continue;
            }
            do {
                char d;
                charArrayWriter.write(c);
                if (c < '\ud800' || c > '\udbff' || i + 1 >= s.length() || (d = s.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                charArrayWriter.write(d);
                ++i;
            } while (++i < s.length() && !unreservedAndReserved.get(c = s.charAt(i)));
            charArrayWriter.flush();
            String str = new String(charArrayWriter.toCharArray());
            byte[] ba = str.getBytes(charset);
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            charArrayWriter.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : s;
    }

    static {
        int i;
        dfltEncName = "UTF-8";
        unreservedAndReserved = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            unreservedAndReserved.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            unreservedAndReserved.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            unreservedAndReserved.set(i);
        }
        unreservedAndReserved.set(45);
        unreservedAndReserved.set(95);
        unreservedAndReserved.set(46);
        unreservedAndReserved.set(126);
        unreservedAndReserved.set(58);
        unreservedAndReserved.set(47);
        unreservedAndReserved.set(63);
        unreservedAndReserved.set(35);
        unreservedAndReserved.set(91);
        unreservedAndReserved.set(93);
        unreservedAndReserved.set(64);
        unreservedAndReserved.set(33);
        unreservedAndReserved.set(36);
        unreservedAndReserved.set(38);
        unreservedAndReserved.set(39);
        unreservedAndReserved.set(92);
        unreservedAndReserved.set(40);
        unreservedAndReserved.set(41);
        unreservedAndReserved.set(42);
        unreservedAndReserved.set(43);
        unreservedAndReserved.set(44);
        unreservedAndReserved.set(59);
        unreservedAndReserved.set(61);
    }
}

