/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm;

import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.ASN1TaggedObject;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.DERTaggedObject;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x9.X962Parameters;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.gmt.GMTObjectIdentifiers;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPublicKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPrivateKey;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class GMTPrivateKey
implements ECPrivateKey,
GMTKey {
    private static final long serialVersionUID = -3613783346296166756L;
    private final ECParameterSpec sm2ParameterSpec = SM2Params.sm2ParameterSpec;
    private final BigInteger dInt;
    private final byte[] dBytes;
    private final byte[] zvalue;
    private GMTPublicKey pubKey = null;

    public static GMTPrivateKey getInstance(byte[] encoded) {
        return new GMTPrivateKey(encoded);
    }

    public GMTPrivateKey(byte[] encoding) {
        if (encoding == null) {
            throw new IllegalArgumentException("null not allowed for encoded");
        }
        switch (encoding.length) {
            case 32: {
                this.dInt = this.dIntegerFrom(encoding);
                break;
            }
            case 96: {
                this.dInt = this.dIntegerFrom(encoding);
                byte[] bPubX = new byte[32];
                byte[] bPubY = new byte[32];
                System.arraycopy(encoding, 32, bPubX, 0, 32);
                System.arraycopy(encoding, 64, bPubY, 0, 32);
                this.pubKey = new GMTPublicKey(bPubX, bPubY);
                break;
            }
            default: {
                this.dInt = this.dIntegerFrom(encoding);
            }
        }
        if (this.pubKey == null) {
            this.pubKey = GMTPrivateKey.buildPublicKey(this.dInt);
        }
        this.dBytes = BigIntegers.asUnsignedByteArray(32, this.dInt);
        this.zvalue = this.pubKey.getZvalue();
    }

    public GMTPrivateKey(byte[] dBytes, byte[] bPubX, byte[] bPubY) {
        if (dBytes == null) {
            throw new IllegalArgumentException("null not allowed for dBytes");
        }
        this.dInt = new BigInteger(1, dBytes);
        this.dBytes = dBytes;
        this.pubKey = bPubX != null && bPubY != null ? new GMTPublicKey(bPubX, bPubY) : GMTPrivateKey.buildPublicKey(this.dInt);
        this.zvalue = this.pubKey.getZvalue();
    }

    public GMTPrivateKey(BigInteger d, BigInteger iPubX, BigInteger iPubY) {
        if (d == null) {
            throw new IllegalArgumentException("null not allowed for d");
        }
        this.dInt = d;
        this.dBytes = BigIntegers.asUnsignedByteArray(32, d);
        this.pubKey = iPubX != null && iPubY != null ? new GMTPublicKey(iPubX, iPubY) : GMTPrivateKey.buildPublicKey(d);
        this.zvalue = this.pubKey.getZvalue();
    }

    public GMTPrivateKey(ECPrivateKeyParameters ecPrivateKeyParameters) {
        this(ecPrivateKeyParameters, null);
    }

    public GMTPrivateKey(ECPrivateKeyParameters ecPrivateKeyParameters, ECPublicKeyParameters ecPublicKeyParameters) {
        if (ecPrivateKeyParameters == null) {
            throw new IllegalArgumentException("null not allowed for ecPrivateKeyParameters");
        }
        if (!SM2Params.sm2DomainParameters.equals(ecPrivateKeyParameters.getParameters())) {
            throw new IllegalArgumentException("domainParameters not allowed for ecPrivateKeyParameters");
        }
        this.dInt = ecPrivateKeyParameters.getD();
        this.dBytes = BigIntegers.asUnsignedByteArray(32, this.dInt);
        if (ecPublicKeyParameters == null) {
            this.pubKey = GMTPrivateKey.buildPublicKey(this.dInt);
        } else {
            if (!SM2Params.sm2DomainParameters.equals(ecPublicKeyParameters.getParameters())) {
                throw new IllegalArgumentException("domainParameters not allowed for ecPublicKeyParameters");
            }
            this.pubKey = new GMTPublicKey(ecPublicKeyParameters);
        }
        this.zvalue = this.pubKey.getZvalue();
    }

    private final BigInteger dIntegerFrom(byte[] encoding) {
        BigInteger d = null;
        if (encoding.length == 32 || encoding.length == 96) {
            byte[] value = new byte[32];
            System.arraycopy(encoding, 0, value, 0, 32);
            d = new BigInteger(1, value);
        } else {
            try {
                byte[] value;
                ASN1Sequence seq = ASN1Sequence.getInstance(encoding);
                if (seq.size() < 3) {
                    throw new SecurityException("encoding not valid");
                }
                AlgorithmIdentifier aid = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
                if (!X9ObjectIdentifiers.id_ecPublicKey.equals(aid.getAlgorithm())) {
                    throw new SecurityException("encoding algorithm not valid");
                }
                ASN1Encodable param = aid.getParameters();
                if (param != null && !Arrays.equals(value = param.toASN1Primitive().getEncoded(), DERNull.INSTANCE.getEncoded()) && !Arrays.equals(value, GMTObjectIdentifiers.sm2.getEncoded())) {
                    throw new SecurityException("encoding parameters not valid");
                }
                ASN1Encodable context = seq.getObjectAt(2);
                if (!(context instanceof DEROctetString)) {
                    throw new RuntimeException("encoding context type not valid");
                }
                d = this.dIntegerFrom((DEROctetString)context);
            }
            catch (Exception e) {
                throw new RuntimeException("encoding not valid", e);
            }
        }
        return d;
    }

    private final BigInteger dIntegerFrom(DEROctetString encoding) {
        BigInteger d = null;
        ASN1Sequence seq = ASN1Sequence.getInstance(encoding.getOctets());
        if (seq.size() < 2) {
            throw new SecurityException("encoding context not valid");
        }
        ASN1Encodable value = seq.getObjectAt(1);
        if (value instanceof ASN1Integer) {
            d = ((ASN1Integer)value).getPositiveValue();
        } else if (value instanceof ASN1OctetString) {
            d = new BigInteger(1, ((ASN1OctetString)value).getOctets());
        } else {
            throw new SecurityException("encoding context#d not valid");
        }
        try {
            int size = seq.size();
            for (int i = 2; i < size; ++i) {
                ASN1TaggedObject tag;
                value = seq.getObjectAt(i);
                if (!(value instanceof ASN1TaggedObject) || (tag = (ASN1TaggedObject)value).getTagNo() != 1) continue;
                DERBitString k = DERBitString.getInstance(tag.getObject());
                this.pubKey = new GMTPublicKey(k.getBytes());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return d;
    }

    public byte[] getEncoded() {
        return this.getEncoded(false);
    }

    public byte[] getEncoded(boolean x962Format) {
        try {
            DERSequence value = null;
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new ASN1Integer(1L));
            if (x962Format) {
                v.add(new DEROctetString(BigIntegers.asUnsignedByteArray(32, this.dInt)));
            } else {
                v.add(new ASN1Integer(this.dInt));
            }
            if (this.pubKey != null) {
                byte[] encoding = new byte[65];
                encoding[0] = 4;
                System.arraycopy(this.pubKey.getPubX(), 0, encoding, 1, 32);
                System.arraycopy(this.pubKey.getPubY(), 0, encoding, 33, 32);
                v.add(new DERTaggedObject(true, 1, new DERBitString(encoding)));
            }
            value = new DERSequence(v);
            v = new ASN1EncodableVector();
            v.add(new ASN1Integer(0L));
            v.add(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, GMTObjectIdentifiers.sm2));
            v.add(new DEROctetString(value));
            return new DERSequence(v).getEncoded();
        }
        catch (IOException e) {
            throw new RuntimeException("SM2PrivateKey encoding failure ", e);
        }
    }

    public byte[] getEncoding() {
        try {
            X962Parameters params = new X962Parameters(DERNull.INSTANCE);
            cfca.sadk.org.bouncycastle.asn1.sec.ECPrivateKey keyStructure = new cfca.sadk.org.bouncycastle.asn1.sec.ECPrivateKey(this.getDByInt(), params);
            PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), keyStructure);
            return info.getEncoded("DER");
        }
        catch (Exception e) {
            throw new RuntimeException("SM2PrivateKey encoding failure ", e);
        }
    }

    public void setSM2PublicKey(GMTPublicKey pubKey) {
    }

    public GMTPublicKey getSM2PublicKey() {
        return this.pubKey;
    }

    public BigInteger getD() {
        return this.dInt;
    }

    public BigInteger getDByInt() {
        return this.dInt;
    }

    public byte[] getD_Bytes() {
        return (byte[])this.dBytes.clone();
    }

    public byte[] getDByBytes() {
        return (byte[])this.dBytes.clone();
    }

    public byte[] getDByBytesWithPublicKey() {
        byte[] encoded = null;
        if (this.pubKey != null) {
            encoded = new byte[96];
            System.arraycopy(this.getDByBytes(), 0, encoded, 0, 32);
            System.arraycopy(this.pubKey.getPubXByBytes(), 0, encoded, 32, 32);
            System.arraycopy(this.pubKey.getPubYByBytes(), 0, encoded, 64, 32);
        } else {
            encoded = new byte[32];
            System.arraycopy(this.getDByBytes(), 0, encoded, 0, 32);
        }
        return encoded;
    }

    public byte[] getZvalue() {
        return (byte[])this.zvalue.clone();
    }

    public ECParameterSpec getParams() {
        return this.sm2ParameterSpec;
    }

    public ECParameterSpec getParameters() {
        return this.sm2ParameterSpec;
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    private static GMTPublicKey buildPublicKey(BigInteger d) {
        ECDomainParameters params = SM2Params.sm2DomainParameters;
        FixedPointCombMultiplier multiplier = new FixedPointCombMultiplier();
        ECPoint Q = multiplier.multiply(params.getG(), d).normalize();
        return new GMTPublicKey(new ECPublicKeyParameters(Q, params));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dInt == null ? 0 : this.dInt.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GMTPrivateKey other = (GMTPrivateKey)obj;
        return !(this.dInt == null ? other.dInt != null : !this.dInt.equals(other.dInt));
    }

    public String toString() {
        String separator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("SM2 Private Key: ");
        buffer.append(separator);
        buffer.append("D:");
        if (this.dInt != null) {
            buffer.append(this.dInt.toString(16));
        }
        if (this.pubKey != null) {
            buffer.append(separator);
            buffer.append(this.pubKey);
        }
        return buffer.toString();
    }

    public final BigInteger dBigInteger() {
        return this.dInt;
    }

    public final byte[] getDefaultZ() {
        return (byte[])this.zvalue.clone();
    }
}

