/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.javax.net.ssl;

import cfca.sadk.tls.java.security.CFCAAlgorithmConstraints;
import cfca.sadk.tls.javax.net.ssl.CFCASSLParameters;
import cfca.sadk.tls.javax.net.ssl.CFCASSLTransfer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;

public abstract class CFCASSLEngine
extends SSLEngine
implements CFCASSLTransfer {
    private String peerHost = null;
    private int peerPort = -1;

    protected CFCASSLEngine() {
    }

    protected CFCASSLEngine(String peerHost, int peerPort) {
        this.peerHost = peerHost;
        this.peerPort = peerPort;
    }

    @Override
    public String getPeerHost() {
        return this.peerHost;
    }

    @Override
    public int getPeerPort() {
        return this.peerPort;
    }

    @Override
    public SSLSession getHandshakeSession() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CFCASSLParameters getCFCASSLParameters() {
        CFCASSLParameters params = new CFCASSLParameters();
        params.setCipherSuites(this.getEnabledCipherSuites());
        params.setProtocols(this.getEnabledProtocols());
        if (this.getNeedClientAuth()) {
            params.setNeedClientAuth(true);
        } else if (this.getWantClientAuth()) {
            params.setWantClientAuth(true);
        }
        return params;
    }

    @Override
    public void setCFCASSLParameters(CFCASSLParameters params) {
        String[] suit = params.getCipherSuites();
        if (suit != null) {
            this.setEnabledCipherSuites(suit);
        }
        if ((suit = params.getProtocols()) != null) {
            this.setEnabledProtocols(suit);
        }
        if (params.getNeedClientAuth()) {
            this.setNeedClientAuth(true);
        } else if (params.getWantClientAuth()) {
            this.setWantClientAuth(true);
        } else {
            this.setWantClientAuth(false);
        }
    }

    @Override
    public CFCAAlgorithmConstraints getAlgorithmConstraints() {
        return this.getCFCASSLParameters().getAlgorithmConstraints();
    }
}

