/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.httpframework.handler;

import cfca.paperless.base.transaction.bean.TransactionRequest;
import cfca.paperless.base.transaction.bean.TransactionResponse;
import cfca.paperless.base.util.JsonUtil;
import cfca.paperless.httpframework.bean.JSONRequest;
import cfca.paperless.httpframework.exception.HttpException;
import cfca.paperless.httpframework.http.HttpHeaders;
import cfca.paperless.httpframework.http.HttpRequest;
import cfca.paperless.httpframework.utils.CloseUtils;
import cfca.paperless.httpframework.utils.HttpIOUtils;
import cfca.paperless.httpframework.utils.HttpParamUtils;
import cfca.paperless.httpframework.utils.HttpRequestUtils;
import cfca.paperless.httpframework.utils.HttpResponseUtils;
import cfca.paperless.httpframework.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractHandler
implements Runnable {
    protected final Socket socket;
    private static final Logger logger = LoggerFactory.getLogger(AbstractHandler.class);

    public AbstractHandler(Socket socket) {
        this.socket = socket;
        logger.info("create handler, remote ip: " + socket.getRemoteSocketAddress().toString() + ", local port: " + socket.getLocalPort());
    }

    @Override
    public void run() {
        try {
            this.putMdcData();
            TransactionResponse transactionResponse = new TransactionResponse();
            try {
                HttpRequest httpRequest = this.getHttpRequest();
                this.modifyMdcData(httpRequest);
                TransactionRequest transactionRequest = this.convertHttpRequestToTransactionRequest(httpRequest);
                transactionResponse.setJSONRequestFlag(StringUtils.isNotEmpty(transactionRequest.getHeadJsonStr()));
                if (this.validateServletName(transactionRequest)) {
                    transactionResponse = this.handleByTx(transactionRequest);
                } else {
                    logger.debug("skip invalid request for servlet: {}", transactionRequest.getHttpHeaderParam("servletName"));
                }
                if (transactionResponse == null) {
                    throw new HttpException("HTTP_000001", "Http Transaction response is null!");
                }
            }
            catch (HttpException he) {
                logger.error("process error, errorCode: " + he.getCode() + ", errorMessage: " + he.getMessage(), (Throwable)he);
                transactionResponse.setErrorCode(he.getCode());
                transactionResponse.setErrorMessage(he.getMessage());
            }
            catch (Exception e) {
                logger.error("process error", (Throwable)e);
                transactionResponse.setErrorCode("HTTP_000000");
                String errorMessageInfo = "(" + e.getMessage() + ")";
                transactionResponse.setErrorMessage("Http request happen system error!" + errorMessageInfo);
            }
            catch (Throwable e) {
                logger.error("process error", e);
                transactionResponse.setErrorCode("HTTP_000000");
                String errorMessageInfo = "(" + e.getMessage() + ")";
                transactionResponse.setErrorMessage("Http request happen system error!" + errorMessageInfo);
            }
            this.sendTransactionResponse(transactionResponse);
        }
        finally {
            CloseUtils.closeQuietly(this.socket);
            this.clearMdcData();
        }
    }

    private void putMdcData() {
        String traceIdString = UUID.randomUUID().toString().replaceAll("-", "");
        String clientIpString = this.socket.getInetAddress().getHostAddress();
        String clientPortString = String.valueOf(this.socket.getPort());
        String serverIpString = this.socket.getLocalAddress().getHostAddress();
        String serverPortString = String.valueOf(this.socket.getLocalPort());
        String clientString = clientIpString + ":" + clientPortString;
        String serverString = serverIpString + ":" + serverPortString;
        MDC.put((String)"TraceId", (String)traceIdString);
        MDC.put((String)"ClientIp", (String)clientString);
        MDC.put((String)"ServerIp", (String)serverString);
        cfca.org.slf4j.MDC.put((String)"TraceId", (String)traceIdString);
        cfca.org.slf4j.MDC.put((String)"ClientIp", (String)clientString);
        cfca.org.slf4j.MDC.put((String)"ServerIp", (String)serverString);
    }

    private void modifyMdcData(HttpRequest httpRequest) throws IOException {
        String traceIdString = httpRequest.headers().getFirst("TraceId");
        logger.info("transactionNo={}", (Object)traceIdString);
        if (StringUtils.isNotEmptyAndNull(traceIdString)) {
            MDC.remove((String)"TraceId");
            MDC.put((String)"TraceId", (String)traceIdString);
            cfca.org.slf4j.MDC.remove((String)"TraceId");
            cfca.org.slf4j.MDC.put((String)"TraceId", (String)traceIdString);
        }
    }

    private void clearMdcData() {
        MDC.remove((String)"TraceId");
        MDC.remove((String)"ClientIp");
        MDC.remove((String)"ServerIp");
        cfca.org.slf4j.MDC.remove((String)"TraceId");
        cfca.org.slf4j.MDC.remove((String)"ClientIp");
        cfca.org.slf4j.MDC.remove((String)"ServerIp");
    }

    private HttpRequest getHttpRequest() throws Exception {
        logger.info("ready to parse http request.");
        InputStream inputStream = this.socket.getInputStream();
        HttpRequest httpRequest = new HttpRequest(inputStream);
        return httpRequest;
    }

    public void sendTransactionResponse(TransactionResponse transactionResponse) {
        try {
            try {
                byte[] result = transactionResponse.getResult();
                if (StringUtils.isNotEmpty(transactionResponse.getErrorCode()) && !"000000".equals(transactionResponse.getErrorCode())) {
                    if (transactionResponse.getJSONRequestFlag()) {
                        result = HttpResponseUtils.constructExceptionResponseJson(transactionResponse.getErrorCode(), transactionResponse.getErrorMessage(), transactionResponse.getTransactionNo());
                        transactionResponse.setJsonLength(String.valueOf(result.length));
                    } else {
                        result = HttpResponseUtils.constructExceptionResponseXML(transactionResponse.getErrorCode(), transactionResponse.getErrorMessage());
                    }
                }
                byte[] resultBytes = HttpResponseUtils.constructFakeResponse(result, transactionResponse.getContentTypeName(), this.getServerName(), transactionResponse.getJsonLength(), transactionResponse.getFileDataLength());
                HttpIOUtils.sendValue(this.socket.getOutputStream(), resultBytes);
            }
            catch (Exception e) {
                logger.error("http frame send response fail", (Throwable)e);
                CloseUtils.closeQuietly(this.socket);
            }
        }
        finally {
            CloseUtils.closeQuietly(this.socket);
        }
    }

    public boolean validateServletName(TransactionRequest transactionRequest) throws HttpException {
        return true;
    }

    public abstract String getServerName();

    public abstract TransactionResponse handleByTx(TransactionRequest var1) throws Exception;

    public TransactionRequest convertHttpRequestToTransactionRequest(HttpRequest httpRequest) throws Exception {
        TransactionRequest transactionRequest = new TransactionRequest();
        transactionRequest.getHttpHeader().putAll(httpRequest.headers().getHeadersMap());
        Map<String, Object> urlInfoMap = HttpRequestUtils.parseUrlInfo(httpRequest);
        String methodName = httpRequest.getMethod();
        String servletName = urlInfoMap.get("servletName").toString();
        String clientIP = HttpRequestUtils.getClientIP(httpRequest, this.socket);
        transactionRequest.setHttpHeaderParam("methodName", (Object)methodName);
        transactionRequest.setHttpHeaderParam("servletName", (Object)servletName);
        transactionRequest.setHttpHeaderParam("clientIP", (Object)clientIP);
        transactionRequest.setMethodName(methodName);
        transactionRequest.setServletName(servletName);
        transactionRequest.setClientIP(clientIP);
        this.setHttpBodyParamToTransactionRequest(httpRequest, transactionRequest);
        if (urlInfoMap.get("paramInUrl") != null) {
            transactionRequest.getParams().putAll((Map)urlInfoMap.get("paramInUrl"));
        }
        return transactionRequest;
    }

    public void setHttpBodyParamToTransactionRequest(HttpRequest httpRequest, TransactionRequest transactionRequest) throws Exception {
        byte[] httpBodyBytes = httpRequest.body();
        HttpHeaders headers = httpRequest.headers();
        String jsonLengthStr = headers.getFirst("jsonLength");
        if (StringUtils.isEmpty(jsonLengthStr)) {
            Map<String, String> httpRequestParams = HttpParamUtils.parseHttpRequestParams(httpBodyBytes);
            transactionRequest.getParams().putAll(httpRequestParams);
        } else {
            int jsonLength = Integer.parseInt(jsonLengthStr);
            if (jsonLength > 0) {
                String JSONRequestStr = new String(httpBodyBytes, 0, jsonLength, "UTF-8");
                logger.debug("get json request str:{}", (Object)JSONRequestStr);
                JSONRequest jsonRequest = (JSONRequest)JsonUtil.json2Obj((String)JSONRequestStr, JSONRequest.class);
                transactionRequest.setHeadJsonStr(JsonUtil.obj2Json((Object)jsonRequest.getHead()));
                logger.debug("get json request head:{}", jsonRequest.getHead());
                transactionRequest.setBodyJsonStr(JsonUtil.obj2Json((Object)jsonRequest.getBody()));
                logger.debug("get json request body:{}", jsonRequest.getBody());
                String fileDataLengthStrInfo = headers.getFirst("fileDataLength");
                logger.info("get file dataLength info:{}", (Object)fileDataLengthStrInfo);
                if (StringUtils.isNotEmpty(fileDataLengthStrInfo)) {
                    String[] fileDataLengthStrGroup = fileDataLengthStrInfo.split("\\|\\|");
                    logger.info("get file data list:{}", (Object)fileDataLengthStrGroup.length);
                    if (fileDataLengthStrGroup != null && fileDataLengthStrGroup.length > 0) {
                        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
                        int position = jsonLength;
                        String[] stringArray = fileDataLengthStrGroup;
                        int n = fileDataLengthStrGroup.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String fileDataLengthStr = stringArray[n2];
                            int fileDataLength = Integer.parseInt(fileDataLengthStr);
                            byte[] bodyBuffer = new byte[fileDataLength];
                            System.arraycopy(httpBodyBytes, position, bodyBuffer, 0, fileDataLength);
                            fileDataList.add(bodyBuffer);
                            position += fileDataLength;
                            ++n2;
                        }
                        transactionRequest.setFileDataList(fileDataList);
                    }
                }
            }
        }
    }
}

