/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.conf;

import cfca.sadk.timestamp.client.utils.TscPasswordTool;
import cfca.sadk.timestamp.client.utils.TscPropsUtil;
import cfca.sadk.timestamp.exception.TSAException;
import java.util.Properties;

public final class TscAuthInfoConf {
    private String httpAuthUsername;
    private String httpAuthPassword;
    private String businessTrustCertPath;
    private String businessTrustCRLPath;

    public TscAuthInfoConf() {
        this.businessTrustCertPath = null;
        this.businessTrustCRLPath = null;
        this.httpAuthUsername = null;
        this.httpAuthPassword = null;
    }

    public TscAuthInfoConf(Properties properties) throws TSAException {
        String httpAuthPassword = TscPropsUtil.getString(properties, "timestamp.http.auth.password", null);
        this.businessTrustCertPath = TscPropsUtil.getString(properties, "timestamp.business.trustCertPath", null);
        this.businessTrustCRLPath = TscPropsUtil.getString(properties, "timestamp.business.trustCRLPath", null);
        this.httpAuthUsername = TscPropsUtil.getString(properties, "timestamp.http.auth.username", null);
        this.httpAuthPassword = TscPasswordTool.readPassword(httpAuthPassword, "httpAuthPassword");
    }

    public String getHttpAuthUsername() {
        return this.httpAuthUsername;
    }

    public TscAuthInfoConf setHttpAuthUsername(String httpAuthUsername) {
        this.httpAuthUsername = httpAuthUsername;
        return this;
    }

    public String getHttpAuthPassword() {
        return this.httpAuthPassword;
    }

    public TscAuthInfoConf setHttpAuthPassword(String httpAuthPassword) {
        this.httpAuthPassword = httpAuthPassword;
        return this;
    }

    public String getBusinessTrustCertPath() {
        return this.businessTrustCertPath;
    }

    public TscAuthInfoConf setBusinessTrustCertPath(String businessTrustCertPath) {
        this.businessTrustCertPath = businessTrustCertPath;
        return this;
    }

    public String getBusinessTrustCRLPath() {
        return this.businessTrustCRLPath;
    }

    public TscAuthInfoConf setBusinessTrustCRLPath(String businessTrustCRLPath) {
        this.businessTrustCRLPath = businessTrustCRLPath;
        return this;
    }

    public final String toString() {
        return this.append(new StringBuilder(128), false).toString();
    }

    public final StringBuilder append(StringBuilder builder, boolean hidden) {
        if (builder != null) {
            builder.append("\n\t TssAuthInfoConf [");
            builder.append("\n\t\t businessTrustCertPath=").append(this.businessTrustCertPath);
            builder.append("\n\t\t businessTrustCRLPath=").append(this.businessTrustCRLPath);
            builder.append("\n\t\t httpAuthUsername=").append(this.httpAuthUsername);
            builder.append("\n\t\t httpAuthPassword=").append(hidden ? "******" : this.httpAuthPassword);
            builder.append("\n\t\t ]");
        }
        return builder;
    }
}

