/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table.opentype.contextsubst;

import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.com.google.typography.font.sfntly.table.SubTable;
import cfca.com.google.typography.font.sfntly.table.opentype.component.NumRecordList;
import cfca.com.google.typography.font.sfntly.table.opentype.component.SubstLookupRecordList;
import cfca.com.google.typography.font.sfntly.table.opentype.component.VisibleSubTable;

public class DoubleRecordTable
extends SubTable {
    public final NumRecordList inputGlyphs;
    public final SubstLookupRecordList lookupRecords;

    public DoubleRecordTable(ReadableFontData data, int base, boolean dataIsCanonical) {
        super(data);
        this.inputGlyphs = new NumRecordList(data, 1, base, base + 4);
        this.lookupRecords = new SubstLookupRecordList(data, base + 2, this.inputGlyphs.limit());
    }

    public DoubleRecordTable(ReadableFontData data, boolean dataIsCanonical) {
        this(data, 0, dataIsCanonical);
    }

    public static abstract class Builder<T extends DoubleRecordTable>
    extends VisibleSubTable.Builder<T> {
        protected NumRecordList inputGlyphIdsBuilder;
        protected SubstLookupRecordList substLookupRecordsBuilder;
        protected int serializedLength;

        public Builder() {
        }

        public Builder(DoubleRecordTable table) {
            this(table.readFontData(), 0, false);
        }

        public Builder(ReadableFontData data, int base, boolean dataIsCanonical) {
            super(data);
            if (!dataIsCanonical) {
                this.prepareToEdit();
            }
        }

        public Builder(Builder<T> other) {
            this.inputGlyphIdsBuilder = other.inputGlyphIdsBuilder;
            this.substLookupRecordsBuilder = other.substLookupRecordsBuilder;
        }

        @Override
        public int subDataSizeToSerialize() {
            if (this.substLookupRecordsBuilder != null) {
                this.serializedLength = this.substLookupRecordsBuilder.limit();
            } else {
                this.computeSizeFromData(this.internalReadData());
            }
            return this.serializedLength;
        }

        @Override
        public int subSerialize(WritableFontData newData) {
            if (this.serializedLength == 0) {
                return 0;
            }
            if (this.inputGlyphIdsBuilder == null || this.substLookupRecordsBuilder == null) {
                return this.serializeFromData(newData);
            }
            return this.inputGlyphIdsBuilder.writeTo(newData) + this.substLookupRecordsBuilder.writeTo(newData);
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }

        @Override
        public void subDataSet() {
            this.inputGlyphIdsBuilder = null;
            this.substLookupRecordsBuilder = null;
        }

        private void prepareToEdit() {
            this.initFromData(this.internalReadData());
            this.setModelChanged();
        }

        private void initFromData(ReadableFontData data) {
            if (this.inputGlyphIdsBuilder == null || this.substLookupRecordsBuilder == null) {
                this.inputGlyphIdsBuilder = new NumRecordList(data, 1, 0, 4);
                this.substLookupRecordsBuilder = new SubstLookupRecordList(data, 2, this.inputGlyphIdsBuilder.limit());
            }
        }

        private void computeSizeFromData(ReadableFontData data) {
            int len = 0;
            if (data != null) {
                len = data.length();
            }
            this.serializedLength = len;
        }

        private int serializeFromData(WritableFontData newData) {
            ReadableFontData data = this.internalReadData();
            data.copyTo(newData);
            return data.length();
        }
    }
}

