/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk.crosspage;

import cfca.com.itextpdf.text.DocumentException;
import cfca.com.itextpdf.text.Rectangle;
import cfca.com.itextpdf.text.pdf.ByteBuffer;
import cfca.com.itextpdf.text.pdf.PdfReader;
import cfca.seal.sadk.LocationInfo;
import cfca.seal.sadk.PrePdfReader;
import cfca.seal.sadk.PrePdfSeal;
import cfca.seal.sadk.PrePdfSealExtra;
import cfca.seal.sadk.SignatureLandscape;
import cfca.seal.sadk.crosspage.CroppedImageInfo;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;

public class CrossPageStrategy {
    private static final float INCH_TO_CM = 2.54f;
    private static final String IMAGE_FORMAT_NAME = "png";
    private static final float POUNDS_PER_INCH = 72.0f;
    private float accumulated;
    private int pageRangeOption = 0;

    public LocationInfo prepareImages(PrePdfSealExtra prePdfSealExtra, PrePdfReader prePdfReader, int crossPageStyle, int fromPage, int toPage, float startX, float startY) throws IOException, DocumentException {
        PrePdfSealExtra.ImageAppearance imageAppearance = prePdfSealExtra.getImageAppearance();
        PdfReader pdfReader = prePdfReader.getPdfReader();
        int numOfPages = pdfReader.getNumberOfPages();
        if (fromPage <= 0 || toPage <= 0) {
            if (fromPage == -1 && toPage == -1) {
                fromPage = 1;
                toPage = numOfPages;
            } else if (fromPage == -1 && toPage > 0) {
                fromPage = 1;
            } else if (fromPage > 0 && toPage == -1) {
                toPage = numOfPages;
            } else {
                throw new DocumentException("params fromPage and toPage must be positive or -1!");
            }
        }
        if (fromPage > toPage) {
            int temp = fromPage;
            fromPage = toPage;
            toPage = temp;
        }
        int crossPageSealNum = 0;
        int totalPages = 0;
        int step = 1;
        if (5 == crossPageStyle || 6 == crossPageStyle) {
            int pages = toPage - fromPage + 1;
            if (this.pageRangeOption != 0) {
                step = 2;
                int oddNum = 0;
                int evenNum = 0;
                if (this.pageRangeOption == 1) {
                    if (fromPage % 2 == 0) {
                        ++fromPage;
                    }
                } else if (this.pageRangeOption == 2 && fromPage % 2 != 0) {
                    ++fromPage;
                }
                for (int i = fromPage; i <= toPage; ++i) {
                    if (i % 2 == 0) {
                        ++evenNum;
                        continue;
                    }
                    ++oddNum;
                }
                if (this.pageRangeOption == 1) {
                    pages = oddNum;
                } else if (this.pageRangeOption == 2) {
                    pages = evenNum;
                }
            }
            crossPageSealNum = pages;
            totalPages = toPage;
        } else {
            totalPages = crossPageSealNum = (toPage - fromPage) * 2;
        }
        if (crossPageSealNum == 0) {
            throw new DocumentException("Do not sign cross page seal on the same page!");
        }
        LocationInfo locInfo = new LocationInfo();
        Rectangle pageRectDocument = pdfReader.getCropBox(fromPage);
        int rotation = pdfReader.getPageRotation(fromPage);
        if (90 == rotation) {
            pageRectDocument.setRotation(90);
        } else if (270 == rotation) {
            pageRectDocument.setRotation(270);
        }
        if (0 != imageAppearance.getImageCount()) {
            byte[] imageBytes = imageAppearance.getImageAsBytes(0);
            cfca.com.itextpdf.text.Image image = imageAppearance.getImage(0);
            float imageWidth = image.getWidth();
            float imageHeight = image.getHeight();
            float dpiX = image.getDpiX();
            float dpiY = image.getDpiY();
            float imageScale = imageAppearance.getImageScale();
            int nextPage = 1;
            this.accumulated = 0.0f;
            int i = 0;
            for (int j = 0; i < totalPages && j < crossPageSealNum; i += step, ++j) {
                CroppedImageInfo croppedImageInfo = this.prepareCroppedImage(imageBytes, imageWidth, imageHeight, dpiX, dpiY, imageScale, crossPageStyle, crossPageSealNum, j, pageRectDocument, startX, startY);
                int imageIndex = j + 1;
                if (5 == crossPageStyle) {
                    imageIndex = crossPageSealNum - j;
                }
                imageAppearance.addImage(croppedImageInfo.croppedImageBytes, imageIndex, crossPageStyle);
                int currentPage = 0;
                currentPage = 5 == crossPageStyle || 6 == crossPageStyle ? fromPage + i : fromPage + (i + 1) / 2;
                SignatureLandscape signatureLandscape = new SignatureLandscape(new Integer(currentPage), croppedImageInfo.croppedImageCoordinate, 0.0f, 0.0f, null);
                locInfo.addSignature(signatureLandscape);
                if (5 == crossPageStyle || 6 == crossPageStyle) {
                    nextPage = currentPage + 1;
                    if (nextPage <= toPage) {
                        pageRectDocument = pdfReader.getCropBox(nextPage);
                        rotation = pdfReader.getPageRotation(nextPage);
                        if (90 == rotation) {
                            pageRectDocument.setRotation(90);
                            continue;
                        }
                        if (270 != rotation) continue;
                        pageRectDocument.setRotation(270);
                        continue;
                    }
                    break;
                }
                if (0 == (i + 1) % 2) continue;
                nextPage = currentPage + 1;
                pageRectDocument = pdfReader.getCropBox(nextPage);
                rotation = pdfReader.getPageRotation(nextPage);
                if (90 == rotation) {
                    pageRectDocument.setRotation(90);
                    continue;
                }
                if (270 != rotation) continue;
                pageRectDocument.setRotation(270);
            }
        } else {
            throw new DocumentException("cross page seal requires an image!");
        }
        return locInfo;
    }

    private byte[] croppingImage(byte[] imageBytes, float imageWidth, float imageHeight, float dpiX, float dpiY, float topX, float topY, float croppedWidth, float croppedHeight) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(imageBytes);
        BufferedImage bufImage = ImageIO.read(bais);
        Image image = bufImage.getScaledInstance((int)imageWidth, (int)imageHeight, 1);
        CropImageFilter cropImageFilter = new CropImageFilter((int)topX, (int)topY, (int)(croppedWidth + 1.0f), (int)(croppedHeight + 1.0f));
        Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropImageFilter));
        BufferedImage tag = new BufferedImage((int)(croppedWidth + 1.0f), (int)(croppedHeight + 1.0f), 2);
        Graphics g = tag.getGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        ByteBuffer baos = new ByteBuffer();
        ImageIO.write((RenderedImage)tag, IMAGE_FORMAT_NAME, baos);
        byte[] croppedImageBytes0 = baos.toByteArray();
        byte[] croppedImageBytes = this.changeDPI(croppedImageBytes0, dpiX, dpiY);
        return croppedImageBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] changeDPI(byte[] inImageBytes, float dpiX, float dpiY) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(inImageBytes);
        BufferedImage bufferedImage = ImageIO.read(bais);
        Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName(IMAGE_FORMAT_NAME);
        while (iw.hasNext()) {
            ImageWriter writer = iw.next();
            ImageWriteParam writeParam = writer.getDefaultWriteParam();
            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(2);
            IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
            if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageOutputStream stream = null;
            try {
                this.setDPI(metadata, dpiX, dpiY);
                stream = ImageIO.createImageOutputStream(output);
                writer.setOutput(stream);
                writer.write(metadata, new IIOImage(bufferedImage, null, metadata), writeParam);
            }
            finally {
                if (null != stream) {
                    stream.close();
                }
            }
            return output.toByteArray();
        }
        return null;
    }

    private void setDPI(IIOMetadata metadata, float dpiX, float dpiY) throws IIOInvalidTreeException {
        if (0.0f == dpiX) {
            dpiX = 72.0f;
        }
        if (0.0f == dpiY) {
            dpiY = 72.0f;
        }
        float dotsXPerMilli = 1.0f * dpiX / 10.0f / 2.54f;
        float dotsYPerMilli = 1.0f * dpiX / 10.0f / 2.54f;
        IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
        horiz.setAttribute("value", Float.toString(dotsXPerMilli));
        IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
        vert.setAttribute("value", Float.toString(dotsYPerMilli));
        IIOMetadataNode dim = new IIOMetadataNode("Dimension");
        dim.appendChild(horiz);
        dim.appendChild(vert);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dim);
        metadata.mergeTree("javax_imageio_1.0", root);
    }

    private Rectangle locatingCroppedImage(Rectangle pageRectDocument, int crossPageStyle, int crossPageSealIndex, float dpiX, float dpiY, float croppedWidth, float croppedHeight, float imageScale, float startX, float startY) throws DocumentException {
        float llx = 0.0f;
        float lly = 0.0f;
        float urx = 0.0f;
        float ury = 0.0f;
        if (0.0f == dpiX) {
            dpiX = 72.0f;
        }
        if (0.0f == dpiY) {
            dpiY = 72.0f;
        }
        float scaledCroppedImageWidth = croppedWidth / dpiX * 72.0f * imageScale;
        float scaledCroppedImageHeight = croppedHeight / dpiY * 72.0f * imageScale;
        Rectangle pageRectViewer = null;
        int rotation = pageRectDocument.getRotation();
        pageRectViewer = 90 == rotation || 270 == rotation ? new Rectangle(pageRectDocument.getTop(), pageRectDocument.getRight()) : pageRectDocument;
        if (1 == crossPageStyle || 3 == crossPageStyle) {
            if (startX <= 0.0f && startX != -1.0f) {
                throw new DocumentException("startX must be positive or -1 in up-down-half or up-down-stripe style cross page seal!");
            }
            if ((double)Math.abs(startX + 1.0f) < 1.0E-4) {
                if (crossPageSealIndex % 2 == 0) {
                    llx = (pageRectViewer.getWidth() - scaledCroppedImageWidth) / 2.0f;
                    lly = 0.0f;
                } else if (0 != crossPageSealIndex % 2) {
                    llx = (pageRectViewer.getWidth() - scaledCroppedImageWidth) / 2.0f;
                    lly = pageRectViewer.getHeight() - scaledCroppedImageHeight;
                }
            } else if (crossPageSealIndex % 2 == 0) {
                llx = startX;
                lly = 0.0f;
            } else if (0 != crossPageSealIndex % 2) {
                llx = startX;
                lly = pageRectViewer.getHeight() - scaledCroppedImageHeight;
            }
        } else if (2 == crossPageStyle || 4 == crossPageStyle) {
            if (startY <= 0.0f && startY != -1.0f) {
                throw new DocumentException("startY must be positive or -1 in left-right-half or left-right-stripe style cross page seal!");
            }
            if ((double)Math.abs(startY + 1.0f) < 1.0E-4) {
                if (crossPageSealIndex % 2 == 0) {
                    llx = pageRectViewer.getWidth() - scaledCroppedImageWidth;
                    lly = (pageRectViewer.getHeight() - scaledCroppedImageHeight) / 2.0f;
                } else if (0 != crossPageSealIndex % 2) {
                    llx = 0.0f;
                    lly = (pageRectViewer.getHeight() - scaledCroppedImageHeight) / 2.0f;
                }
            } else if (crossPageSealIndex % 2 == 0) {
                llx = pageRectViewer.getWidth() - scaledCroppedImageWidth;
                lly = startY;
            } else if (0 != crossPageSealIndex % 2) {
                llx = 0.0f;
                lly = startY;
            }
        } else if (5 == crossPageStyle) {
            if ((double)Math.abs(startY + 1.0f) < 1.0E-4) {
                llx = 0.0f;
                lly = (pageRectViewer.getHeight() - scaledCroppedImageHeight) / 2.0f;
            } else {
                llx = 0.0f;
                lly = startY;
            }
        } else if (6 == crossPageStyle) {
            if ((double)Math.abs(startY + 1.0f) < 1.0E-4) {
                llx = pageRectViewer.getWidth() - scaledCroppedImageWidth;
                lly = (pageRectViewer.getHeight() - scaledCroppedImageHeight) / 2.0f;
            } else {
                llx = pageRectViewer.getWidth() - scaledCroppedImageWidth;
                lly = startY;
            }
        } else {
            throw new DocumentException("unsupported cross page style!");
        }
        return new Rectangle(llx, lly, urx, ury);
    }

    private CroppedImageInfo prepareCroppedImage(byte[] imageBytes, float imageWidth, float imageHeight, float dpiX, float dpiY, float imageScale, int crossPageStyle, int crossPageSealNum, int crossPageSealIndex, Rectangle pageRectDocument, float startX, float startY) throws IOException, DocumentException {
        CroppedImageInfo croppedImageInfo = new CroppedImageInfo();
        if (1 == crossPageStyle) {
            float croppedWidth = imageWidth;
            float croppedHeight = imageHeight / 2.0f;
            if (crossPageSealIndex == 0 || crossPageSealIndex == 1) {
                float topX = 0.0f;
                float topY = croppedHeight * (float)(crossPageSealIndex % 2);
                croppedImageInfo.croppedImageBytes = this.croppingImage(imageBytes, imageWidth, imageHeight, dpiX, dpiY, topX, topY, croppedWidth, croppedHeight);
            }
            croppedImageInfo.croppedImageCoordinate = this.locatingCroppedImage(pageRectDocument, crossPageStyle, crossPageSealIndex, dpiX, dpiY, croppedWidth, croppedHeight, imageScale, startX, startY);
            return croppedImageInfo;
        }
        if (crossPageStyle == 3) {
            float croppedWidth = imageWidth;
            float croppedHeight = imageHeight / (float)crossPageSealNum;
            float topX = 0.0f;
            float topY = 0.0f;
            this.accumulated += croppedHeight;
            if (0 < crossPageSealIndex) {
                topY = this.accumulated;
                topY -= croppedHeight;
            }
            croppedImageInfo.croppedImageBytes = this.croppingImage(imageBytes, imageWidth, imageHeight, dpiX, dpiY, topX, topY, croppedWidth, croppedHeight);
            croppedImageInfo.croppedImageCoordinate = this.locatingCroppedImage(pageRectDocument, crossPageStyle, crossPageSealIndex, dpiX, dpiY, croppedWidth, croppedHeight, imageScale, startX, startY);
            return croppedImageInfo;
        }
        if (crossPageStyle == 2) {
            float croppedWidth = imageWidth / 2.0f;
            float croppedHeight = imageHeight;
            if (crossPageSealIndex == 0 || crossPageSealIndex == 1) {
                float topX = croppedWidth * (float)(crossPageSealIndex % 2);
                float topY = 0.0f;
                croppedImageInfo.croppedImageBytes = this.croppingImage(imageBytes, imageWidth, imageHeight, dpiX, dpiY, topX, topY, croppedWidth, croppedHeight);
            }
            croppedImageInfo.croppedImageCoordinate = this.locatingCroppedImage(pageRectDocument, crossPageStyle, crossPageSealIndex, dpiX, dpiY, croppedWidth, croppedHeight, imageScale, startX, startY);
            return croppedImageInfo;
        }
        if (crossPageStyle == 4 || crossPageStyle == 5 || crossPageStyle == 6) {
            float croppedWidth = imageWidth / (float)crossPageSealNum;
            float croppedHeight = imageHeight;
            float topX = 0.0f;
            float topY = 0.0f;
            this.accumulated += croppedWidth;
            if (0 < crossPageSealIndex) {
                topX = this.accumulated;
                topX -= croppedWidth;
            }
            croppedImageInfo.croppedImageBytes = this.croppingImage(imageBytes, imageWidth, imageHeight, dpiX, dpiY, topX, topY, croppedWidth, croppedHeight);
            croppedImageInfo.croppedImageCoordinate = this.locatingCroppedImage(pageRectDocument, crossPageStyle, crossPageSealIndex, dpiX, dpiY, croppedWidth, croppedHeight, imageScale, startX, startY);
            return croppedImageInfo;
        }
        throw new DocumentException("unsupported cross page style!");
    }

    public LocationInfo prepareImages(PrePdfSeal prePdfSeal, PrePdfReader prePdfReader, int crossPageStyle, int fromPage, int toPage, float startX, float startY) throws IOException, DocumentException {
        PdfReader pdfReader = prePdfReader.getPdfReader();
        int numOfPages = pdfReader.getNumberOfPages();
        if (fromPage <= 0 || toPage <= 0) {
            if (fromPage == -1 && toPage == -1) {
                fromPage = 1;
                toPage = numOfPages;
            } else if (fromPage == -1 && toPage > 0) {
                fromPage = 1;
            } else if (fromPage > 0 && toPage == -1) {
                toPage = numOfPages;
            } else {
                throw new DocumentException("params fromPage and toPage must be positive or -1!");
            }
        }
        if (fromPage > toPage) {
            int temp = fromPage;
            fromPage = toPage;
            toPage = temp;
        }
        int crossPageSealNum = 0;
        int step = 1;
        if (5 == crossPageStyle || 6 == crossPageStyle) {
            int pages = toPage - fromPage + 1;
            if (this.pageRangeOption != 0) {
                step = 2;
                int oddNum = 0;
                int evenNum = 0;
                if (this.pageRangeOption == 1) {
                    if (fromPage % 2 == 0) {
                        ++fromPage;
                    }
                } else if (this.pageRangeOption == 2 && fromPage % 2 != 0) {
                    ++fromPage;
                }
                for (int i = fromPage; i <= toPage; ++i) {
                    if (i % 2 == 0) {
                        ++evenNum;
                        continue;
                    }
                    ++oddNum;
                }
                if (this.pageRangeOption == 1) {
                    pages = oddNum;
                } else if (this.pageRangeOption == 2) {
                    pages = evenNum;
                }
            }
            crossPageSealNum = pages;
        } else {
            crossPageSealNum = (toPage - fromPage) * 2;
        }
        if (crossPageSealNum == 0) {
            throw new DocumentException("Do not sign cross page seal on the same page!");
        }
        LocationInfo locInfo = new LocationInfo();
        Rectangle pageRectDocument = pdfReader.getCropBox(fromPage);
        int rotation = pdfReader.getPageRotation(fromPage);
        if (90 == rotation) {
            pageRectDocument.setRotation(90);
        } else if (270 == rotation) {
            pageRectDocument.setRotation(270);
        }
        if (0 != prePdfSeal.getImageCount()) {
            byte[] imageBytes = prePdfSeal.getImageAsBytes(0);
            float imageWidth = prePdfSeal.getImage(0).getWidth();
            float imageHeight = prePdfSeal.getImage(0).getHeight();
            float imageScale = prePdfSeal.getImageScale();
            float dpiX = prePdfSeal.getImage(0).getDpiX();
            float dpiY = prePdfSeal.getImage(0).getDpiY();
            int nextPage = 1;
            this.accumulated = 0.0f;
            for (int i = 0; i < crossPageSealNum; i += step) {
                CroppedImageInfo croppedImageInfo = this.prepareCroppedImage(imageBytes, imageWidth, imageHeight, dpiX, dpiY, imageScale, crossPageStyle, crossPageSealNum, i, pageRectDocument, startX, startY);
                prePdfSeal.addImage(croppedImageInfo.croppedImageBytes, i + 1, crossPageStyle);
                int currentPage = 0;
                currentPage = 5 == crossPageStyle || 6 == crossPageStyle ? fromPage + i : fromPage + (i + 1) / 2;
                SignatureLandscape signatureLandscape = new SignatureLandscape(new Integer(currentPage), croppedImageInfo.croppedImageCoordinate, 0.0f, 0.0f, null);
                locInfo.addSignature(signatureLandscape);
                if (5 == crossPageStyle || 6 == crossPageStyle) {
                    nextPage = currentPage + 1;
                    if (nextPage <= toPage) {
                        pageRectDocument = pdfReader.getCropBox(nextPage);
                        rotation = pdfReader.getPageRotation(nextPage);
                        if (90 == rotation) {
                            pageRectDocument.setRotation(90);
                            continue;
                        }
                        if (270 != rotation) continue;
                        pageRectDocument.setRotation(270);
                        continue;
                    }
                    break;
                }
                if (0 == (i + 1) % 2) continue;
                nextPage = currentPage + 1;
                pageRectDocument = pdfReader.getCropBox(nextPage);
                rotation = pdfReader.getPageRotation(nextPage);
                if (90 == rotation) {
                    pageRectDocument.setRotation(90);
                    continue;
                }
                if (270 != rotation) continue;
                pageRectDocument.setRotation(270);
            }
        } else {
            throw new DocumentException("cross page seal requires an image!");
        }
        return locInfo;
    }

    public void setPageRangeOption(int pageRangeOption) {
        this.pageRangeOption = pageRangeOption;
    }

    public static interface SubPageRangeOption {
        public static final int ALL = 0;
        public static final int ODD = 1;
        public static final int EVEN = 2;
    }
}

