/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.manager;

import cfca.sadk.tls.java.security.CFCAAlgorithmConstraints;
import cfca.sadk.tls.javax.net.ssl.CFCASNIServerName;
import cfca.sadk.tls.javax.net.ssl.CFCASSLEngine;
import cfca.sadk.tls.javax.net.ssl.CFCASSLSocket;
import cfca.sadk.tls.sun.security.provider.certpath.CFCAAlgorithmChecker;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.manager.CertCheckResult;
import cfca.sadk.tls.sun.security.ssl.manager.CertCheckType;
import cfca.sadk.tls.sun.security.ssl.manager.CertKeyCacheSizedMap;
import cfca.sadk.tls.sun.security.ssl.manager.CertKeyEntryStatus;
import cfca.sadk.tls.sun.security.ssl.manager.CertKeyType;
import cfca.sadk.tls.sun.security.util.CFCAAlgorithmConstraintsHelper;
import cfca.sadk.tls.sun.security.util.CFCASSLHelper;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

final class CFCAX509KeyManager
extends X509ExtendedKeyManager
implements X509KeyManager {
    private final List<KeyStore.Builder> builders;
    private final AtomicLong uidCounter;
    private final Map<String, Reference<KeyStore.PrivateKeyEntry>> entryCacheMap;

    CFCAX509KeyManager(KeyStore.Builder builder) {
        this(Collections.singletonList(builder));
    }

    CFCAX509KeyManager(List<KeyStore.Builder> builders) {
        this.builders = builders;
        this.uidCounter = new AtomicLong();
        this.entryCacheMap = Collections.synchronizedMap(new CertKeyCacheSizedMap());
    }

    @Override
    public final X509Certificate[] getCertificateChain(String alias) {
        KeyStore.PrivateKeyEntry entry = this.getEntry(alias);
        X509Certificate[] chain = null;
        if (entry != null) {
            chain = (X509Certificate[])entry.getCertificateChain();
        }
        return chain;
    }

    @Override
    public final PrivateKey getPrivateKey(String alias) {
        KeyStore.PrivateKeyEntry entry = this.getEntry(alias);
        PrivateKey privateKey = null;
        if (entry != null) {
            privateKey = entry.getPrivateKey();
        }
        return privateKey;
    }

    @Override
    public final String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        CFCAAlgorithmConstraints constraints = this.getAlgorithmConstraints(socket);
        return this.chooseBestAlias(keyTypes, issuers, CertCheckType.CLIENT, constraints, null, null);
    }

    @Override
    public final String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        CFCAAlgorithmConstraints constraints = this.getAlgorithmConstraints(engine);
        return this.chooseBestAlias(keyTypes, issuers, CertCheckType.CLIENT, constraints, null, null);
    }

    @Override
    public final String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        CFCAAlgorithmConstraints constraints = this.getAlgorithmConstraints(socket);
        List<CFCASNIServerName> sniList = CFCASSLHelper.getRequestedServerNames(socket);
        return this.chooseBestAlias(new String[]{keyType}, issuers, CertCheckType.SERVER, constraints, sniList, "HTTPS");
    }

    @Override
    public final String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        CFCAAlgorithmConstraints constraints = this.getAlgorithmConstraints(engine);
        List<CFCASNIServerName> sniList = CFCASSLHelper.getRequestedServerNames(engine);
        return this.chooseBestAlias(new String[]{keyType}, issuers, CertCheckType.SERVER, constraints, sniList, "HTTPS");
    }

    @Override
    public final String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.findAliases(new String[]{keyType}, issuers, CertCheckType.CLIENT, null);
    }

    @Override
    public final String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.findAliases(new String[]{keyType}, issuers, CertCheckType.SERVER, null);
    }

    private final CFCAAlgorithmConstraints getAlgorithmConstraints(Socket socket) {
        CFCASSLSocket transfer = null;
        if (socket != null && socket.isConnected() && socket instanceof CFCASSLSocket) {
            transfer = (CFCASSLSocket)socket;
        }
        return CFCAAlgorithmConstraintsHelper.createAlgorithmConstraintsKeyManager(transfer);
    }

    private final CFCAAlgorithmConstraints getAlgorithmConstraints(SSLEngine engine) {
        CFCASSLEngine transfer = null;
        if (engine instanceof CFCASSLEngine) {
            transfer = (CFCASSLEngine)engine;
        }
        return CFCAAlgorithmConstraintsHelper.createAlgorithmConstraintsKeyManager(transfer);
    }

    private final String makeAlias(CertKeyEntryStatus entry) {
        return this.uidCounter.incrementAndGet() + "." + entry.builderIndex + "." + entry.alias;
    }

    private final KeyStore.PrivateKeyEntry getEntry(String alias) {
        if (alias == null) {
            return null;
        }
        KeyStore.PrivateKeyEntry entryResult = this.findPrivateKeyEntryFromCache(alias);
        if (entryResult != null) {
            return entryResult;
        }
        Debugger.check.debug("Find the PrivateKeyEntry({}) from builders running...", (Object)alias);
        try {
            entryResult = this.findPrivateKeyEntryFromBuilders(this.builders, alias);
        }
        catch (KeyStoreException e) {
            Debugger.check.warn("Find the PrivateKeyEntry({}) from builders failure: {}", new Object[]{alias, e.getMessage(), e});
            throw new SecurityException("UnrecoverablePrivatekeyEntry with KeyStoreException", e);
        }
        catch (NoSuchAlgorithmException e) {
            Debugger.check.warn("Find the PrivateKeyEntry({}) from builders failure: {}", new Object[]{alias, e.getMessage(), e});
            throw new SecurityException("UnrecoverablePrivatekeyEntry with NoSuchAlgorithmException", e);
        }
        catch (UnrecoverableEntryException e) {
            Debugger.check.warn("Find the PrivateKeyEntry({}) from builders failure: {} (password invalid/jce-policy: illegal-key-size)", new Object[]{alias, e.getMessage(), e});
            throw new SecurityException("UnrecoverablePrivatekeyEntry with UnrecoverableEntryException(password invalid/jce-policy: illegal-key-size)", e);
        }
        Debugger.check.debug("Find the PrivateKeyEntry({}) from builders Finished.", (Object)alias);
        if (entryResult != null) {
            this.entryCacheMap.put(alias, new SoftReference<KeyStore.PrivateKeyEntry>(entryResult));
            if (Debugger.check.isDebugEnabled()) {
                Debugger.check.debug("Find the PrivateKeyEntry({}) from builders, and current caches is {}", (Object)alias, (Object)this.entryCacheMap.size());
            }
        }
        return entryResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final KeyStore.PrivateKeyEntry findPrivateKeyEntryFromCache(String alias) {
        Debugger.check.debug("Find the PrivateKeyEntry({}) from cache running...", (Object)alias);
        boolean findFlag = false;
        try {
            KeyStore.PrivateKeyEntry entryResult;
            if (alias == null) {
                KeyStore.PrivateKeyEntry privateKeyEntry = null;
                return privateKeyEntry;
            }
            Reference<KeyStore.PrivateKeyEntry> ref = this.entryCacheMap.get(alias);
            KeyStore.PrivateKeyEntry privateKeyEntry = entryResult = ref != null ? ref.get() : null;
            if (entryResult != null) {
                findFlag = true;
            }
            KeyStore.PrivateKeyEntry privateKeyEntry2 = entryResult;
            return privateKeyEntry2;
        }
        finally {
            Debugger.check.debug("Find the PrivateKeyEntry({}) from cache Finished findFlag={}", (Object)alias, (Object)findFlag);
        }
    }

    private final KeyStore.PrivateKeyEntry findPrivateKeyEntryFromBuilders(List<KeyStore.Builder> builders, String alias) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (builders == null || alias == null) {
            return null;
        }
        int firstDot = alias.indexOf(46);
        int secondDot = alias.indexOf(46, firstDot + 1);
        if (firstDot == -1 || secondDot == firstDot) {
            return null;
        }
        KeyStore.PrivateKeyEntry entryResult = null;
        int builderIndex = Integer.parseInt(alias.substring(firstDot + 1, secondDot));
        String keyStoreAlias = alias.substring(secondDot + 1);
        KeyStore.Builder builder = builders.get(builderIndex);
        KeyStore keystore = builder.getKeyStore();
        KeyStore.Entry entry = keystore.getEntry(keyStoreAlias, builder.getProtectionParameter(alias));
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            entryResult = (KeyStore.PrivateKeyEntry)entry;
        }
        return entryResult;
    }

    private final String chooseBestAlias(String[] keyTypes, Principal[] issuers, CertCheckType checkType, CFCAAlgorithmConstraints constraints, List<CFCASNIServerName> requestedServerNames, String idAlgorithm) {
        String alias = null;
        String[] aliases = this.findAliases(keyTypes, issuers, checkType, constraints, false, requestedServerNames, idAlgorithm, true);
        if (aliases != null && aliases.length > 0) {
            alias = aliases[0];
        }
        return alias;
    }

    private final String[] findAliases(String[] keyTypes, Principal[] issuers, CertCheckType checkType, CFCAAlgorithmConstraints constraints) {
        return this.findAliases(keyTypes, issuers, checkType, constraints, true, null, null, false);
    }

    private final String[] findAliases(String[] keyTypes, Principal[] issuers, CertCheckType checkType, CFCAAlgorithmConstraints constraints, boolean findAll, List<CFCASNIServerName> requestedServerNames, String idAlgorithm, boolean chooseBestFlag) {
        if (keyTypes == null || keyTypes.length == 0) {
            return null;
        }
        ArrayList<CertKeyType> keyTypeList = new ArrayList<CertKeyType>();
        if (keyTypes != null) {
            for (String keyType : keyTypes) {
                if (keyType == null) continue;
                keyTypeList.add(new CertKeyType(keyType));
            }
        }
        if (keyTypeList.size() == 0) {
            return null;
        }
        HashSet<Principal> issuerSet = new HashSet<Principal>();
        if (issuers != null && issuers.length > 0) {
            for (Principal issuer : issuers) {
                if (issuer == null) continue;
                issuerSet.add(issuer);
            }
        }
        ArrayList<CertKeyEntryStatus> allResults = new ArrayList<CertKeyEntryStatus>();
        List<CertKeyEntryStatus> results = null;
        CertKeyEntryStatus status = null;
        int builderNumber = this.builders.size();
        for (int builderIndex = 0; builderIndex < builderNumber; ++builderIndex) {
            try {
                results = this.getAliases(builderIndex, keyTypeList, issuerSet, findAll, checkType, constraints, requestedServerNames, idAlgorithm);
                if (results == null || results.size() <= 0) continue;
                if (chooseBestFlag) {
                    status = results.get(0);
                    if (status == null) continue;
                    if (status.checkResult == CertCheckResult.OK) {
                        Debugger.check.debug("KeyManager Find the best alias={}", (Object)status);
                        allResults.clear();
                        allResults.add(status);
                        break;
                    }
                    status = null;
                }
                allResults.addAll(results);
                continue;
            }
            catch (Exception e) {
                if (!Debugger.check.isDebugEnabled()) continue;
                Debugger.check.debug("KeyManager getAliases failure from build{}: {}", (Object)builderIndex, (Object)e.getMessage());
            }
        }
        String[] aliases = null;
        if (allResults.isEmpty()) {
            Debugger.check.debug("KeyManager no matching alias found");
        } else {
            Collections.sort(allResults);
            Debugger.check.debug("KeyManager: no good matching key found, returning best match out of: {}", allResults);
            aliases = this.toAliases(allResults);
        }
        return aliases;
    }

    private final String[] toAliases(List<CertKeyEntryStatus> results) {
        String[] aliases = null;
        if (results == null) {
            aliases = new String[]{};
        } else {
            aliases = new String[results.size()];
            int i = 0;
            for (CertKeyEntryStatus result : results) {
                aliases[i++] = this.makeAlias(result);
            }
        }
        return aliases;
    }

    private List<CertKeyEntryStatus> getAliases(int builderIndex, List<CertKeyType> keyTypes, Set<Principal> issuers, boolean findAll, CertCheckType checkType, CFCAAlgorithmConstraints constraints, List<CFCASNIServerName> requestedServerNames, String idAlgorithm) throws Exception {
        Date currentTime = new Date();
        KeyStore.Builder builder = this.builders.get(builderIndex);
        KeyStore keystore = builder.getKeyStore();
        ArrayList<CertKeyEntryStatus> results = null;
        boolean preferred = false;
        Certificate[] chain = null;
        String alias = null;
        Enumeration<String> e = keystore.aliases();
        while (e.hasMoreElements()) {
            alias = e.nextElement();
            if (!keystore.isKeyEntry(alias) || (chain = keystore.getCertificateChain(alias)) == null || chain.length == 0) continue;
            if (!this.conformsToX509Format(chain)) {
                Debugger.check.debug("Ignoring alias {}: chain does not match", (Object)alias);
                continue;
            }
            int keyIndex = this.conformsToKeyType(chain, keyTypes);
            if (keyIndex == -1) {
                Debugger.check.debug("Ignoring alias {}: key algorithm does not match", (Object)alias);
                continue;
            }
            if (!this.conformsToIssuers(chain, issuers)) {
                Debugger.check.debug("Ignoring alias {}: issuers does not match", (Object)alias);
                continue;
            }
            if (!this.conformsToAlgorithmConstraints(chain, constraints)) {
                Debugger.check.debug("Ignoring alias {}: ertificate list does not conform to algorithm constraints", (Object)alias);
                continue;
            }
            CertCheckResult checkResult = checkType.check((X509Certificate)chain[0], currentTime, requestedServerNames, idAlgorithm);
            CertKeyEntryStatus status = new CertKeyEntryStatus(builderIndex, keyIndex, alias, chain, checkResult);
            if (!preferred && checkResult == CertCheckResult.OK && keyIndex == 0) {
                preferred = true;
            }
            if (preferred && !findAll) {
                return Collections.singletonList(status);
            }
            if (results == null) {
                results = new ArrayList<CertKeyEntryStatus>();
            }
            results.add(status);
        }
        return results;
    }

    private final boolean conformsToX509Format(Certificate[] chain) {
        boolean valid = true;
        if (chain == null || chain.length == 0) {
            valid = false;
        } else {
            for (Certificate cert : chain) {
                if (cert != null && cert instanceof X509Certificate) continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    private final int conformsToKeyType(Certificate[] chain, List<CertKeyType> keyTypes) {
        int keyIndex = -1;
        int j = 0;
        for (CertKeyType keyType : keyTypes) {
            if (keyType.matches(chain)) {
                keyIndex = j;
                break;
            }
            ++j;
        }
        return keyIndex;
    }

    private final boolean conformsToIssuers(Certificate[] chain, Set<Principal> issuers) {
        boolean found = true;
        if (issuers == null || issuers.size() == 0) {
            found = true;
        } else {
            found = false;
            for (Certificate cert : chain) {
                if (cert == null || !issuers.contains(((X509Certificate)cert).getIssuerX500Principal())) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    private boolean conformsToAlgorithmConstraints(Certificate[] chain, CFCAAlgorithmConstraints constraints) {
        boolean valid = true;
        if (constraints == null) {
            valid = true;
        } else {
            CFCAAlgorithmChecker checker = new CFCAAlgorithmChecker(constraints);
            try {
                checker.init(false);
            }
            catch (CertPathValidatorException cpve) {
                valid = false;
            }
            if (valid) {
                for (int i = chain.length - 1; i >= 0; --i) {
                    Certificate cert = chain[i];
                    try {
                        checker.check(cert, Collections.<String>emptySet());
                        continue;
                    }
                    catch (CertPathValidatorException cpve) {
                        valid = false;
                        break;
                    }
                }
            }
        }
        return valid;
    }
}

