/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.sadk.timestamp.client.utils.TscStrings;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;

public final class TimestampUUID {
    public static final TimestampUUID UUID = new TimestampUUID();
    private static long autoIncrement = 100000000L;
    private final String randomCode;
    private AtomicLong autoIncrementCounter;

    public TimestampUUID() {
        byte[] randomCode = new byte[4];
        SecureRandom ng = new SecureRandom();
        ng.nextBytes(randomCode);
        this.randomCode = TscStrings.toHexString(randomCode).toLowerCase();
        this.autoIncrementCounter = new AtomicLong(0L);
    }

    public final String randomUUID() {
        long atomicLong = (int)(this.autoIncrementCounter.getAndIncrement() % autoIncrement);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
        StringBuilder builder = new StringBuilder();
        builder.append("TSC");
        builder.append(dateFormat.format(new Date()));
        builder.append("-");
        builder.append(this.randomCode);
        builder.append("-");
        builder.append(String.format("%08d", atomicLong));
        return builder.toString();
    }
}

