/*
 * Decompiled with CFR 0.152.
 */
package cfca.ch.qos.logback.core.rolling;

import cfca.ch.qos.logback.core.rolling.RolloverFailure;
import cfca.ch.qos.logback.core.rolling.helper.CompressionMode;
import cfca.ch.qos.logback.core.spi.ContextAwareBase;
import cfca.ch.qos.logback.core.status.ErrorStatus;
import cfca.ch.qos.logback.core.status.WarnStatus;
import cfca.ch.qos.logback.core.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

class AsyncArchivingFixedWindowCompressor
extends ContextAwareBase {
    private static final String SUFFIX_ZIP = ".zip";
    private static final String SUFFIX_GZ = ".gz";
    private final CompressionMode compressionMode;
    private static final int BUFFER_SIZE = 8192;

    AsyncArchivingFixedWindowCompressor(CompressionMode compressionMode) {
        this.compressionMode = compressionMode;
    }

    private void compress(String nameOfFile2Compress, String nameOfCompressedFile, String innerEntryName) {
        switch (this.compressionMode) {
            case GZ: {
                this.gzCompress(nameOfFile2Compress, nameOfCompressedFile);
                break;
            }
            case ZIP: {
                this.zipCompress(nameOfFile2Compress, nameOfCompressedFile, innerEntryName);
                break;
            }
            default: {
                throw new UnsupportedOperationException("compress method called in NONE compression mode");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipCompress(String nameOfFile2zip, String nameOfZippedFile, String innerEntryName) {
        File zippedFile;
        File file2zip = new File(nameOfFile2zip);
        if (!file2zip.exists()) {
            this.addStatus(new WarnStatus("The file to compress named [" + nameOfFile2zip + "] does not exist.", this));
            return;
        }
        if (innerEntryName == null) {
            this.addStatus(new WarnStatus("The innerEntryName parameter cannot be null", this));
            return;
        }
        if (!nameOfZippedFile.endsWith(SUFFIX_ZIP)) {
            nameOfZippedFile = nameOfZippedFile + SUFFIX_ZIP;
        }
        if ((zippedFile = new File(nameOfZippedFile)).exists()) {
            this.addStatus(new WarnStatus("The target compressed file named [" + nameOfZippedFile + "] exist already.", this));
            return;
        }
        this.addInfo("ZIP compressing [" + file2zip + "] as [" + zippedFile + "]");
        this.createMissingTargetDirsIfNecessary(zippedFile);
        BufferedInputStream bis = null;
        ZipOutputStream zos = null;
        try {
            int n;
            bis = new BufferedInputStream(new FileInputStream(nameOfFile2zip));
            zos = new ZipOutputStream(new FileOutputStream(nameOfZippedFile));
            ZipEntry zipEntry = this.computeZipEntry(innerEntryName);
            zos.putNextEntry(zipEntry);
            byte[] inbuf = new byte[8192];
            while ((n = bis.read(inbuf)) != -1 && !Thread.currentThread().isInterrupted()) {
                zos.write(inbuf, 0, n);
            }
            bis.close();
            bis = null;
            zos.close();
            zos = null;
        }
        catch (Exception e) {
            this.addStatus(new ErrorStatus("Error occurred while compressing [" + nameOfFile2zip + "] into [" + nameOfZippedFile + "].", this, e));
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ignore) {
                    this.addStatus(new ErrorStatus("Failed to close bis.", this, ignore));
                }
            }
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException ignore) {
                    this.addStatus(new ErrorStatus("Failed to close zos.", this, ignore));
                }
            }
            if (!file2zip.delete()) {
                this.addStatus(new WarnStatus("Could not delete [" + nameOfFile2zip + "].", this));
            }
        }
    }

    private ZipEntry computeZipEntry(String filename) {
        String nameOfFileNestedWithinArchive = AsyncArchivingFixedWindowCompressor.computeFileNameStrWithoutCompSuffix(filename, this.compressionMode);
        return new ZipEntry(nameOfFileNestedWithinArchive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gzCompress(String nameOfFile2gz, String nameOfgzedFile) {
        File gzedFile;
        File file2gz = new File(nameOfFile2gz);
        if (!file2gz.exists()) {
            this.addStatus(new WarnStatus("The file to compress named [" + nameOfFile2gz + "] does not exist.", this));
            return;
        }
        if (!nameOfgzedFile.endsWith(SUFFIX_GZ)) {
            nameOfgzedFile = nameOfgzedFile + SUFFIX_GZ;
        }
        if ((gzedFile = new File(nameOfgzedFile)).exists()) {
            this.addWarn("The target compressed file named [" + nameOfgzedFile + "] exist already. Aborting file compression.");
            return;
        }
        this.addInfo("GZ compressing [" + file2gz + "] as [" + gzedFile + "]");
        this.createMissingTargetDirsIfNecessary(gzedFile);
        BufferedInputStream bis = null;
        DeflaterOutputStream gzos = null;
        try {
            int n;
            bis = new BufferedInputStream(new FileInputStream(nameOfFile2gz));
            gzos = new GZIPOutputStream(new FileOutputStream(nameOfgzedFile));
            byte[] inbuf = new byte[8192];
            while ((n = bis.read(inbuf)) != -1 && !Thread.currentThread().isInterrupted()) {
                ((GZIPOutputStream)gzos).write(inbuf, 0, n);
            }
            bis.close();
            bis = null;
            gzos.close();
            gzos = null;
        }
        catch (Exception e) {
            this.addStatus(new ErrorStatus("Error occurred while compressing [" + nameOfFile2gz + "] into [" + nameOfgzedFile + "].", this, e));
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ignore) {
                    this.addStatus(new ErrorStatus("Failed to close bis.", this, ignore));
                }
            }
            if (gzos != null) {
                try {
                    gzos.close();
                }
                catch (IOException ignore) {
                    this.addStatus(new ErrorStatus("Failed to close zos.", this, ignore));
                }
            }
            if (!file2gz.delete()) {
                this.addStatus(new WarnStatus("Could not delete [" + nameOfFile2gz + "].", this));
            }
        }
    }

    static String computeFileNameStrWithoutCompSuffix(String fileNamePatternStr, CompressionMode compressionMode) {
        String result;
        int len = fileNamePatternStr.length();
        switch (compressionMode) {
            case GZ: {
                if (fileNamePatternStr.endsWith(SUFFIX_GZ)) {
                    result = fileNamePatternStr.substring(0, len - 3);
                    break;
                }
                result = fileNamePatternStr;
                break;
            }
            case ZIP: {
                if (fileNamePatternStr.endsWith(SUFFIX_ZIP)) {
                    result = fileNamePatternStr.substring(0, len - 4);
                    break;
                }
                result = fileNamePatternStr;
                break;
            }
            case NONE: {
                result = fileNamePatternStr;
                break;
            }
            default: {
                throw new IllegalStateException("Execution should not reach this point");
            }
        }
        return result;
    }

    private void createMissingTargetDirsIfNecessary(File file) {
        boolean result = FileUtil.createMissingParentDirectories(file);
        if (!result) {
            this.addError("Failed to create parent directories for [" + file.getAbsolutePath() + "]");
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    Future<?> asyncCompress(String nameOfFile2Compress, String nameOfCompressedFile, String innerEntryName) throws RolloverFailure {
        CompressionRunnable runnable = new CompressionRunnable(nameOfFile2Compress, nameOfCompressedFile, innerEntryName);
        ScheduledExecutorService executorService = this.context.getScheduledExecutorService();
        Future<?> future = executorService.submit(runnable);
        return future;
    }

    private class CompressionRunnable
    implements Runnable {
        final String nameOfFile2Compress;
        final String nameOfCompressedFile;
        final String innerEntryName;

        public CompressionRunnable(String nameOfFile2Compress, String nameOfCompressedFile, String innerEntryName) {
            this.nameOfFile2Compress = nameOfFile2Compress;
            this.nameOfCompressedFile = nameOfCompressedFile;
            this.innerEntryName = innerEntryName;
        }

        @Override
        public void run() {
            AsyncArchivingFixedWindowCompressor.this.compress(this.nameOfFile2Compress, this.nameOfCompressedFile, this.innerEntryName);
        }
    }
}

