/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.data;

import cfca.com.google.typography.font.sfntly.data.ByteArray;
import java.io.IOException;
import java.io.OutputStream;

final class GrowableMemoryByteArray
extends ByteArray<GrowableMemoryByteArray> {
    private static final int INITIAL_LENGTH = 256;
    private byte[] b = new byte[256];

    public GrowableMemoryByteArray() {
        super(0, Integer.MAX_VALUE, true);
    }

    @Override
    protected void internalPut(int index, byte b) {
        this.growTo(index + 1);
        this.b[index] = b;
    }

    @Override
    protected int internalPut(int index, byte[] b, int offset, int length) {
        this.growTo(index + length);
        System.arraycopy(b, offset, this.b, index, length);
        return length;
    }

    @Override
    protected int internalGet(int index) {
        return this.b[index];
    }

    @Override
    protected int internalGet(int index, byte[] b, int offset, int length) {
        System.arraycopy(this.b, index, b, offset, length);
        return length;
    }

    @Override
    public void close() {
        this.b = null;
    }

    @Override
    public int copyTo(OutputStream os, int offset, int length) throws IOException {
        os.write(this.b, offset, length);
        return length;
    }

    private void growTo(int newSize) {
        if (newSize <= this.b.length) {
            return;
        }
        newSize = Math.max(newSize, this.b.length * 2);
        byte[] newArray = new byte[newSize];
        System.arraycopy(this.b, 0, newArray, 0, this.b.length);
        this.b = newArray;
    }
}

