/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf;

import cfca.sadk.com.itextpdf.io.source.ByteUtils;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfIndirectReference;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPrimitiveObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfNumber
extends PdfPrimitiveObject {
    private static final long serialVersionUID = -250799718574024246L;
    private double value;
    private boolean isDouble;
    private boolean changed = false;

    public PdfNumber(double value) {
        this.setValue(value);
    }

    public PdfNumber(int value) {
        this.setValue(value);
    }

    public PdfNumber(byte[] content) {
        super(content);
        this.isDouble = true;
        this.value = Double.NaN;
    }

    private PdfNumber() {
    }

    @Override
    public byte getType() {
        return 8;
    }

    public double getValue() {
        if (Double.isNaN(this.value)) {
            this.generateValue();
        }
        return this.value;
    }

    public double doubleValue() {
        return this.getValue();
    }

    public float floatValue() {
        return (float)this.getValue();
    }

    public long longValue() {
        return (long)this.getValue();
    }

    public int intValue() {
        return (int)this.getValue();
    }

    public void setValue(int value) {
        this.value = value;
        this.isDouble = false;
        this.content = null;
        this.changed = true;
    }

    public void setValue(double value) {
        this.value = value;
        this.isDouble = true;
        this.content = null;
    }

    public void increment() {
        this.setValue(this.value += 1.0);
    }

    public void decrement() {
        this.setValue(this.value -= 1.0);
    }

    @Override
    public PdfNumber makeIndirect(PdfDocument document) {
        return (PdfNumber)super.makeIndirect(document);
    }

    @Override
    public PdfNumber makeIndirect(PdfDocument document, PdfIndirectReference reference) {
        return (PdfNumber)super.makeIndirect(document, reference);
    }

    @Override
    public PdfNumber copyTo(PdfDocument document) {
        return (PdfNumber)super.copyTo(document, true);
    }

    @Override
    public PdfNumber copyTo(PdfDocument document, boolean allowDuplicating) {
        return (PdfNumber)super.copyTo(document, allowDuplicating);
    }

    public String toString() {
        if (this.content != null) {
            return new String(this.content);
        }
        if (this.isDouble) {
            return new String(ByteUtils.getIsoBytes(this.getValue()));
        }
        return new String(ByteUtils.getIsoBytes(this.intValue()));
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && Double.compare(((PdfNumber)o).value, this.value) == 0;
    }

    public int hashCode() {
        if (this.changed) {
            Logger logger = LoggerFactory.getLogger(PdfReader.class);
            logger.warn("Calculate hashcode for modified PdfNumber.");
            this.changed = false;
        }
        long hash = Double.doubleToLongBits(this.value);
        return (int)(hash ^ hash >>> 32);
    }

    @Override
    protected PdfNumber newInstance() {
        return new PdfNumber();
    }

    protected boolean isDoubleNumber() {
        return this.isDouble;
    }

    @Override
    protected void generateContent() {
        this.content = this.isDouble ? ByteUtils.getIsoBytes(this.value) : ByteUtils.getIsoBytes((int)this.value);
    }

    protected void generateValue() {
        try {
            this.value = Double.parseDouble(new String(this.content));
        }
        catch (NumberFormatException e) {
            this.value = Double.NaN;
        }
        this.isDouble = true;
    }

    @Override
    protected void copyContent(PdfObject from, PdfDocument document) {
        super.copyContent(from, document);
        PdfNumber number = (PdfNumber)from;
        this.value = number.value;
        this.isDouble = number.isDouble;
    }
}

