/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk.refit;

import cfca.com.itextpdf.text.Document;
import cfca.com.itextpdf.text.DocumentException;
import cfca.com.itextpdf.text.pdf.AcroFields;
import cfca.com.itextpdf.text.pdf.BaseFont;
import cfca.com.itextpdf.text.pdf.PdfAnnotation;
import cfca.com.itextpdf.text.pdf.PdfReader;
import cfca.com.itextpdf.text.pdf.PdfStamper;
import cfca.com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfAcrofieldsRefit {
    private PdfReader reader;
    private OutputStream os;
    private PdfStamper pdfStamper;
    private AcroFields acrofields;
    private PdfWriter pdfWriter;
    private boolean appearance = false;
    private Document document;

    public PdfAcrofieldsRefit(PdfReader reader, OutputStream os) {
        this.reader = reader;
        this.os = os;
    }

    public void setAppend(boolean append) throws DocumentException, IOException {
        this.setAppendAndAppearance(append, this.appearance);
    }

    public void setAppendAndAppearance(boolean append, boolean appearance) throws DocumentException, IOException {
        if (null != this.reader) {
            this.pdfStamper = new PdfStamper(this.reader, this.os, '\u0000', append);
            this.pdfWriter = this.pdfStamper.getWriter();
            this.pdfWriter.getAcroForm().setNeedAppearances(appearance);
            this.acrofields = this.pdfStamper.getAcroFields();
        } else {
            this.document = new Document();
            this.pdfWriter = PdfWriter.getInstance(this.document, this.os);
            this.document.open();
            this.pdfWriter.getAcroForm().setNeedAppearances(appearance);
        }
    }

    public void setFormFlattening(boolean flattening) {
        this.pdfStamper.setFormFlattening(flattening);
    }

    public void setPartialFlattening(String[] partialFlattening) {
        for (int i = 0; i < partialFlattening.length; ++i) {
            this.pdfStamper.partialFormFlattening(partialFlattening[i]);
        }
    }

    public void setFieldMap(Map<String, String> fieldMap) throws IOException, DocumentException {
        for (String name : fieldMap.keySet()) {
            String value = fieldMap.get(name);
            this.acrofields.setField(name, value);
        }
    }

    public boolean setFieldProperty(String field, String name, Object value, int[] inst) {
        return this.acrofields.setFieldProperty(field, name, value, inst);
    }

    public boolean setFieldProperty(String field, String name, int value, int[] inst) {
        return this.acrofields.setFieldProperty(field, name, value, inst);
    }

    public void addSubstitutionFont(BaseFont font) {
        this.acrofields.addSubstitutionFont(font);
    }

    public void addAnnotation(PdfAnnotation annot, int page) throws DocumentException {
        this.pdfWriter.addAnnotation(annot, page);
    }

    public PdfWriter getWriter() {
        return this.pdfWriter;
    }

    public void close() throws DocumentException, IOException {
        if (null != this.pdfStamper) {
            this.pdfStamper.close();
        } else if (null != this.document) {
            this.document.close();
        }
    }
}

