/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.util;

import cfca.sadk.system.Environments;
import cfca.sadk.tls.util.TLSDeviceConf;
import cfca.sadk.tls.util.TLSLoggings;
import java.lang.management.ManagementFactory;
import java.util.List;

public final class TLSEnvironments {
    private static final String COMPANY_NAME = "China Financial Certification Authority";
    private static final String PRODUCT_NAME = "GMTLS Standard";
    public static final String VERSION = "v3.3.1.0-20181017";
    private static volatile TLSEnvironments environments;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TLSEnvironments environments() {
        if (environments != null) return environments;
        Class<TLSEnvironments> clazz = TLSEnvironments.class;
        synchronized (TLSEnvironments.class) {
            if (environments != null) return environments;
            TLSEnvironments env = new TLSEnvironments();
            TLSLoggings.ENVIRONMENT_LOGGER.info(env.buildEnvironments());
            environments = env;
            // ** MonitorExit[var0] (shouldn't be in output)
            return environments;
        }
    }

    public static void main(String[] args) {
        System.err.println(TLSEnvironments.environments().buildEnvironments());
    }

    final StringBuilder appendOS(StringBuilder builder) {
        builder.append("\n");
        builder.append("\n ===================OSx info===================");
        builder.append("\n \u64cd\u4f5c\u7cfb\u7edf\u540d\u79f0: " + System.getProperty("os.name"));
        builder.append("\n \u64cd\u4f5c\u7cfb\u7edf\u67b6\u6784: " + System.getProperty("os.arch"));
        builder.append("\n \u64cd\u4f5c\u7cfb\u7edf\u7248\u672c: " + System.getProperty("os.version"));
        builder.append("\n \u64cd\u4f5c\u7cfb\u7edf\u7528\u6237\u540d: " + System.getProperty("user.name"));
        builder.append("\n user.home: " + System.getProperty("user.home"));
        builder.append("\n user.dir: " + System.getProperty("user.dir"));
        builder.append("\n user.timezone: ").append(System.getProperty("user.timezone"));
        builder.append("\n user.language: ").append(System.getProperty("user.language"));
        return builder;
    }

    final StringBuilder appendJDK(StringBuilder builder) {
        builder.append("\n");
        builder.append("\n ===================JDK info===================");
        builder.append("\n JDK\u4e3b\u7248\u672c: " + System.getProperty("java.version"));
        builder.append("\n JDK\u4f9b\u5e94\u5546: " + System.getProperty("java.vendor"));
        builder.append("\n JDK\u4e3b\u76ee\u5f55: " + System.getProperty("java.home"));
        builder.append("\n JDK\u7c7b\u8def\u5f84: " + System.getProperty("java.class.path"));
        builder.append("\n JDK\u52a8\u6001\u5e93: " + System.getProperty("java.library.path"));
        return builder;
    }

    final StringBuilder appendJVM(StringBuilder builder) {
        builder.append("\n");
        builder.append("\n ===================JVM info===================");
        builder.append("\n java.vm.vendor=").append(System.getProperty("java.vm.vendor"));
        builder.append("\n java.vm.name=").append(System.getProperty("java.vm.name"));
        builder.append("\n java.vm.version=").append(System.getProperty("java.vm.version"));
        builder.append("\n java.home=").append(System.getProperty("java.home"));
        builder.append("\n java.class.path=").append(System.getProperty("java.class.path"));
        builder.append("\n java.class.version=").append(System.getProperty("java.class.version"));
        builder.append("\n java.runtime.name=").append(System.getProperty("java.runtime.name"));
        builder.append("\n java.runtime.version=").append(System.getProperty("java.runtime.version"));
        builder.append("\n java.library.path=").append(System.getProperty("java.library.path"));
        builder.append("\n java.version=").append(System.getProperty("java.version"));
        builder.append("\n sun.arch.data.model=").append(System.getProperty("sun.arch.data.model"));
        builder.append("\n sun.os.patch.level=").append(System.getProperty("sun.os.patch.level"));
        builder.append("\n ");
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        builder.append("\n JVM\u7248\u672c: " + System.getProperty("java.vm.version"));
        builder.append("\n JVM\u540d\u79f0: " + System.getProperty("java.vm.name"));
        builder.append("\n JVM\u53c2\u6570: " + inputArguments);
        return builder;
    }

    final StringBuilder appendME(StringBuilder builder) {
        builder.append("\n");
        builder.append("\n ===================DeviceTLS Standard info===================");
        builder.append("\n \u5e94\u7528\u5382\u5546: China Financial Certification Authority");
        builder.append("\n \u5e94\u7528\u540d\u79f0: GMTLS Standard");
        builder.append("\n \u5e94\u7528\u7248\u672c: v3.3.1.0-20181017");
        TLSDeviceConf.appendME(builder);
        builder.append("\n ===================DeviceTLS Standard info===================");
        return builder;
    }

    public final String buildEnvironments() {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append(Environments.environments().buildEnvironments());
        }
        catch (Throwable e) {
            builder.append("\n");
            builder.append("\n");
            this.appendOS(builder);
            this.appendJDK(builder);
            this.appendJVM(builder);
            builder.append("\n");
            builder.append("\n");
        }
        this.appendME(builder);
        builder.append("\n");
        builder.append("\n");
        return builder.toString();
    }
}

