/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.io.codec.brotli.dec;

import cfca.sadk.com.itextpdf.io.codec.brotli.dec.BitReader;
import cfca.sadk.com.itextpdf.io.codec.brotli.dec.BrotliRuntimeException;
import cfca.sadk.com.itextpdf.io.codec.brotli.dec.Context;
import cfca.sadk.com.itextpdf.io.codec.brotli.dec.Dictionary;
import cfca.sadk.com.itextpdf.io.codec.brotli.dec.Huffman;
import cfca.sadk.com.itextpdf.io.codec.brotli.dec.HuffmanTreeGroup;
import cfca.sadk.com.itextpdf.io.codec.brotli.dec.Prefix;
import cfca.sadk.com.itextpdf.io.codec.brotli.dec.State;
import cfca.sadk.com.itextpdf.io.codec.brotli.dec.Transform;
import cfca.sadk.com.itextpdf.io.codec.brotli.dec.Utils;

final class Decode {
    private static final int DEFAULT_CODE_LENGTH = 8;
    private static final int CODE_LENGTH_REPEAT_CODE = 16;
    private static final int NUM_LITERAL_CODES = 256;
    private static final int NUM_INSERT_AND_COPY_CODES = 704;
    private static final int NUM_BLOCK_LENGTH_CODES = 26;
    private static final int LITERAL_CONTEXT_BITS = 6;
    private static final int DISTANCE_CONTEXT_BITS = 2;
    private static final int HUFFMAN_TABLE_BITS = 8;
    private static final int HUFFMAN_TABLE_MASK = 255;
    private static final int CODE_LENGTH_CODES = 18;
    private static final int[] CODE_LENGTH_CODE_ORDER = new int[]{1, 2, 3, 4, 0, 5, 17, 6, 16, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int NUM_DISTANCE_SHORT_CODES = 16;
    private static final int[] DISTANCE_SHORT_CODE_INDEX_OFFSET = new int[]{3, 2, 1, 0, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2};
    private static final int[] DISTANCE_SHORT_CODE_VALUE_OFFSET = new int[]{0, 0, 0, 0, -1, 1, -2, 2, -3, 3, -1, 1, -2, 2, -3, 3};
    private static final int[] FIXED_TABLE = new int[]{131072, 131076, 131075, 196610, 131072, 131076, 131075, 262145, 131072, 131076, 131075, 196610, 131072, 131076, 131075, 262149};

    Decode() {
    }

    private static int decodeVarLenUnsignedByte(BitReader br) {
        if (BitReader.readBits(br, 1) != 0) {
            int n = BitReader.readBits(br, 3);
            if (n == 0) {
                return 1;
            }
            return BitReader.readBits(br, n) + (1 << n);
        }
        return 0;
    }

    private static void decodeMetaBlockLength(BitReader br, State state) {
        state.inputEnd = BitReader.readBits(br, 1) == 1;
        state.metaBlockLength = 0;
        state.isUncompressed = false;
        state.isMetadata = false;
        if (state.inputEnd && BitReader.readBits(br, 1) != 0) {
            return;
        }
        int sizeNibbles = BitReader.readBits(br, 2) + 4;
        if (sizeNibbles == 7) {
            state.isMetadata = true;
            if (BitReader.readBits(br, 1) != 0) {
                throw new BrotliRuntimeException("Corrupted reserved bit");
            }
            int sizeBytes = BitReader.readBits(br, 2);
            if (sizeBytes == 0) {
                return;
            }
            for (int i = 0; i < sizeBytes; ++i) {
                int bits = BitReader.readBits(br, 8);
                if (bits == 0 && i + 1 == sizeBytes && sizeBytes > 1) {
                    throw new BrotliRuntimeException("Exuberant nibble");
                }
                state.metaBlockLength |= bits << i * 8;
            }
        } else {
            for (int i = 0; i < sizeNibbles; ++i) {
                int bits = BitReader.readBits(br, 4);
                if (bits == 0 && i + 1 == sizeNibbles && sizeNibbles > 4) {
                    throw new BrotliRuntimeException("Exuberant nibble");
                }
                state.metaBlockLength |= bits << i * 4;
            }
        }
        ++state.metaBlockLength;
        if (!state.inputEnd) {
            state.isUncompressed = BitReader.readBits(br, 1) == 1;
        }
    }

    private static int readSymbol(int[] table, int offset, BitReader br) {
        int val = (int)(br.accumulator >>> br.bitOffset);
        int bits = table[offset += val & 0xFF] >> 16;
        int sym = table[offset] & 0xFFFF;
        if (bits <= 8) {
            br.bitOffset += bits;
            return sym;
        }
        offset += sym;
        int mask = (1 << bits) - 1;
        br.bitOffset += (table[offset += (val & mask) >>> 8] >> 16) + 8;
        return table[offset] & 0xFFFF;
    }

    private static int readBlockLength(int[] table, int offset, BitReader br) {
        BitReader.fillBitWindow(br);
        int code = Decode.readSymbol(table, offset, br);
        int n = Prefix.BLOCK_LENGTH_N_BITS[code];
        return Prefix.BLOCK_LENGTH_OFFSET[code] + BitReader.readBits(br, n);
    }

    private static int translateShortCodes(int code, int[] ringBuffer, int index) {
        if (code < 16) {
            index += DISTANCE_SHORT_CODE_INDEX_OFFSET[code];
            return ringBuffer[index &= 3] + DISTANCE_SHORT_CODE_VALUE_OFFSET[code];
        }
        return code - 16 + 1;
    }

    private static void moveToFront(int[] v, int index) {
        int value = v[index];
        while (index > 0) {
            v[index] = v[index - 1];
            --index;
        }
        v[0] = value;
    }

    private static void inverseMoveToFrontTransform(byte[] v, int vLen) {
        int i;
        int[] mtf = new int[256];
        for (i = 0; i < 256; ++i) {
            mtf[i] = i;
        }
        for (i = 0; i < vLen; ++i) {
            int index = v[i] & 0xFF;
            v[i] = (byte)mtf[index];
            if (index == 0) continue;
            Decode.moveToFront(mtf, index);
        }
    }

    private static void readHuffmanCodeLengths(int[] codeLengthCodeLengths, int numSymbols, int[] codeLengths, BitReader br) {
        int symbol = 0;
        int prevCodeLen = 8;
        int repeat = 0;
        int repeatCodeLen = 0;
        int space = 32768;
        int[] table = new int[32];
        Huffman.buildHuffmanTable(table, 0, 5, codeLengthCodeLengths, 18);
        while (symbol < numSymbols && space > 0) {
            int repeatDelta;
            BitReader.readMoreInput(br);
            BitReader.fillBitWindow(br);
            int p = (int)(br.accumulator >>> br.bitOffset) & 0x1F;
            br.bitOffset += table[p] >> 16;
            int codeLen = table[p] & 0xFFFF;
            if (codeLen < 16) {
                repeat = 0;
                codeLengths[symbol++] = codeLen;
                if (codeLen == 0) continue;
                prevCodeLen = codeLen;
                space -= 32768 >> codeLen;
                continue;
            }
            int extraBits = codeLen - 14;
            int newLen = 0;
            if (codeLen == 16) {
                newLen = prevCodeLen;
            }
            if (repeatCodeLen != newLen) {
                repeat = 0;
                repeatCodeLen = newLen;
            }
            int oldRepeat = repeat;
            if (repeat > 0) {
                repeat -= 2;
                repeat <<= extraBits;
            }
            if (symbol + (repeatDelta = (repeat += BitReader.readBits(br, extraBits) + 3) - oldRepeat) > numSymbols) {
                throw new BrotliRuntimeException("symbol + repeatDelta > numSymbols");
            }
            for (int i = 0; i < repeatDelta; ++i) {
                codeLengths[symbol++] = repeatCodeLen;
            }
            if (repeatCodeLen == 0) continue;
            space -= repeatDelta << 15 - repeatCodeLen;
        }
        if (space != 0) {
            throw new BrotliRuntimeException("Unused space");
        }
        Utils.fillWithZeroes(codeLengths, symbol, numSymbols - symbol);
    }

    static void readHuffmanCode(int alphabetSize, int[] table, int offset, BitReader br) {
        boolean ok = true;
        BitReader.readMoreInput(br);
        int[] codeLengths = new int[alphabetSize];
        int simpleCodeOrSkip = BitReader.readBits(br, 2);
        if (simpleCodeOrSkip == 1) {
            int maxBitsCounter = alphabetSize - 1;
            int maxBits = 0;
            int[] symbols = new int[4];
            int numSymbols = BitReader.readBits(br, 2) + 1;
            while (maxBitsCounter != 0) {
                maxBitsCounter >>= 1;
                ++maxBits;
            }
            for (int i = 0; i < numSymbols; ++i) {
                symbols[i] = BitReader.readBits(br, maxBits) % alphabetSize;
                codeLengths[symbols[i]] = 2;
            }
            codeLengths[symbols[0]] = 1;
            switch (numSymbols) {
                case 1: {
                    break;
                }
                case 2: {
                    ok = symbols[0] != symbols[1];
                    codeLengths[symbols[1]] = 1;
                    break;
                }
                case 3: {
                    ok = symbols[0] != symbols[1] && symbols[0] != symbols[2] && symbols[1] != symbols[2];
                    break;
                }
                default: {
                    boolean bl = ok = symbols[0] != symbols[1] && symbols[0] != symbols[2] && symbols[0] != symbols[3] && symbols[1] != symbols[2] && symbols[1] != symbols[3] && symbols[2] != symbols[3];
                    if (BitReader.readBits(br, 1) == 1) {
                        codeLengths[symbols[2]] = 3;
                        codeLengths[symbols[3]] = 3;
                        break;
                    }
                    codeLengths[symbols[0]] = 2;
                    break;
                }
            }
        } else {
            int[] codeLengthCodeLengths = new int[18];
            int space = 32;
            int numCodes = 0;
            for (int i = simpleCodeOrSkip; i < 18 && space > 0; ++i) {
                int v;
                int codeLenIdx = CODE_LENGTH_CODE_ORDER[i];
                BitReader.fillBitWindow(br);
                int p = (int)(br.accumulator >>> br.bitOffset) & 0xF;
                br.bitOffset += FIXED_TABLE[p] >> 16;
                codeLengthCodeLengths[codeLenIdx] = v = FIXED_TABLE[p] & 0xFFFF;
                if (v == 0) continue;
                space -= 32 >> v;
                ++numCodes;
            }
            ok = numCodes == 1 || space == 0;
            Decode.readHuffmanCodeLengths(codeLengthCodeLengths, alphabetSize, codeLengths, br);
        }
        if (!ok) {
            throw new BrotliRuntimeException("Can't readHuffmanCode");
        }
        Huffman.buildHuffmanTable(table, offset, 8, codeLengths, alphabetSize);
    }

    private static int decodeContextMap(int contextMapSize, byte[] contextMap, BitReader br) {
        BitReader.readMoreInput(br);
        int numTrees = Decode.decodeVarLenUnsignedByte(br) + 1;
        if (numTrees == 1) {
            Utils.fillWithZeroes(contextMap, 0, contextMapSize);
            return numTrees;
        }
        boolean useRleForZeros = BitReader.readBits(br, 1) == 1;
        int maxRunLengthPrefix = 0;
        if (useRleForZeros) {
            maxRunLengthPrefix = BitReader.readBits(br, 4) + 1;
        }
        int[] table = new int[1080];
        Decode.readHuffmanCode(numTrees + maxRunLengthPrefix, table, 0, br);
        int i = 0;
        while (i < contextMapSize) {
            BitReader.readMoreInput(br);
            BitReader.fillBitWindow(br);
            int code = Decode.readSymbol(table, 0, br);
            if (code == 0) {
                contextMap[i] = 0;
                ++i;
                continue;
            }
            if (code <= maxRunLengthPrefix) {
                for (int reps = (1 << code) + BitReader.readBits(br, code); reps != 0; --reps) {
                    if (i >= contextMapSize) {
                        throw new BrotliRuntimeException("Corrupted context map");
                    }
                    contextMap[i] = 0;
                    ++i;
                }
                continue;
            }
            contextMap[i] = (byte)(code - maxRunLengthPrefix);
            ++i;
        }
        if (BitReader.readBits(br, 1) == 1) {
            Decode.inverseMoveToFrontTransform(contextMap, contextMapSize);
        }
        return numTrees;
    }

    private static void decodeBlockTypeAndLength(State state, int treeType) {
        BitReader br = state.br;
        int[] ringBuffers = state.blockTypeRb;
        int offset = treeType * 2;
        BitReader.fillBitWindow(br);
        int blockType = Decode.readSymbol(state.blockTypeTrees, treeType * 1080, br);
        state.blockLength[treeType] = Decode.readBlockLength(state.blockLenTrees, treeType * 1080, br);
        blockType = blockType == 1 ? ringBuffers[offset + 1] + 1 : (blockType == 0 ? ringBuffers[offset] : (blockType -= 2));
        if (blockType >= state.numBlockTypes[treeType]) {
            blockType -= state.numBlockTypes[treeType];
        }
        ringBuffers[offset] = ringBuffers[offset + 1];
        ringBuffers[offset + 1] = blockType;
    }

    private static void decodeLiteralBlockSwitch(State state) {
        Decode.decodeBlockTypeAndLength(state, 0);
        int literalBlockType = state.blockTypeRb[1];
        state.contextMapSlice = literalBlockType << 6;
        state.literalTreeIndex = state.contextMap[state.contextMapSlice] & 0xFF;
        state.literalTree = state.hGroup0.trees[state.literalTreeIndex];
        byte contextMode = state.contextModes[literalBlockType];
        state.contextLookupOffset1 = Context.LOOKUP_OFFSETS[contextMode];
        state.contextLookupOffset2 = Context.LOOKUP_OFFSETS[contextMode + 1];
    }

    private static void decodeCommandBlockSwitch(State state) {
        Decode.decodeBlockTypeAndLength(state, 1);
        state.treeCommandOffset = state.hGroup1.trees[state.blockTypeRb[3]];
    }

    private static void decodeDistanceBlockSwitch(State state) {
        Decode.decodeBlockTypeAndLength(state, 2);
        state.distContextMapSlice = state.blockTypeRb[5] << 2;
    }

    private static void maybeReallocateRingBuffer(State state) {
        int newSize = state.maxRingBufferSize;
        if ((long)newSize > state.expectedTotalSize) {
            int minimalNewSize = (int)state.expectedTotalSize + state.customDictionary.length;
            while (newSize >> 1 > minimalNewSize) {
                newSize >>= 1;
            }
            if (!state.inputEnd && newSize < 16384 && state.maxRingBufferSize >= 16384) {
                newSize = 16384;
            }
        }
        if (newSize <= state.ringBufferSize) {
            return;
        }
        int ringBufferSizeWithSlack = newSize + 37;
        byte[] newBuffer = new byte[ringBufferSizeWithSlack];
        if (state.ringBuffer != null) {
            System.arraycopy(state.ringBuffer, 0, newBuffer, 0, state.ringBufferSize);
        } else if (state.customDictionary.length != 0) {
            int length = state.customDictionary.length;
            int offset = 0;
            if (length > state.maxBackwardDistance) {
                offset = length - state.maxBackwardDistance;
                length = state.maxBackwardDistance;
            }
            System.arraycopy(state.customDictionary, offset, newBuffer, 0, length);
            state.pos = length;
            state.bytesToIgnore = length;
        }
        state.ringBuffer = newBuffer;
        state.ringBufferSize = newSize;
    }

    private static void readMetablockInfo(State state) {
        BitReader br = state.br;
        if (state.inputEnd) {
            state.nextRunningState = 10;
            state.bytesToWrite = state.pos;
            state.bytesWritten = 0;
            state.runningState = 12;
            return;
        }
        state.hGroup0.codes = null;
        state.hGroup0.trees = null;
        state.hGroup1.codes = null;
        state.hGroup1.trees = null;
        state.hGroup2.codes = null;
        state.hGroup2.trees = null;
        BitReader.readMoreInput(br);
        Decode.decodeMetaBlockLength(br, state);
        if (state.metaBlockLength == 0 && !state.isMetadata) {
            return;
        }
        if (state.isUncompressed || state.isMetadata) {
            BitReader.jumpToByteBoundary(br);
            state.runningState = state.isMetadata ? 4 : 5;
        } else {
            state.runningState = 2;
        }
        if (state.isMetadata) {
            return;
        }
        state.expectedTotalSize += (long)state.metaBlockLength;
        if (state.ringBufferSize < state.maxRingBufferSize) {
            Decode.maybeReallocateRingBuffer(state);
        }
    }

    private static void readMetablockHuffmanCodesAndContextMaps(State state) {
        BitReader br = state.br;
        for (int i = 0; i < 3; ++i) {
            state.numBlockTypes[i] = Decode.decodeVarLenUnsignedByte(br) + 1;
            state.blockLength[i] = 0x10000000;
            if (state.numBlockTypes[i] <= 1) continue;
            Decode.readHuffmanCode(state.numBlockTypes[i] + 2, state.blockTypeTrees, i * 1080, br);
            Decode.readHuffmanCode(26, state.blockLenTrees, i * 1080, br);
            state.blockLength[i] = Decode.readBlockLength(state.blockLenTrees, i * 1080, br);
        }
        BitReader.readMoreInput(br);
        state.distancePostfixBits = BitReader.readBits(br, 2);
        state.numDirectDistanceCodes = 16 + (BitReader.readBits(br, 4) << state.distancePostfixBits);
        state.distancePostfixMask = (1 << state.distancePostfixBits) - 1;
        int numDistanceCodes = state.numDirectDistanceCodes + (48 << state.distancePostfixBits);
        state.contextModes = new byte[state.numBlockTypes[0]];
        int i = 0;
        while (i < state.numBlockTypes[0]) {
            int limit = Math.min(i + 96, state.numBlockTypes[0]);
            while (i < limit) {
                state.contextModes[i] = (byte)(BitReader.readBits(br, 2) << 1);
                ++i;
            }
            BitReader.readMoreInput(br);
        }
        state.contextMap = new byte[state.numBlockTypes[0] << 6];
        int numLiteralTrees = Decode.decodeContextMap(state.numBlockTypes[0] << 6, state.contextMap, br);
        state.trivialLiteralContext = true;
        for (int j = 0; j < state.numBlockTypes[0] << 6; ++j) {
            if (state.contextMap[j] == j >> 6) continue;
            state.trivialLiteralContext = false;
            break;
        }
        state.distContextMap = new byte[state.numBlockTypes[2] << 2];
        int numDistTrees = Decode.decodeContextMap(state.numBlockTypes[2] << 2, state.distContextMap, br);
        HuffmanTreeGroup.init(state.hGroup0, 256, numLiteralTrees);
        HuffmanTreeGroup.init(state.hGroup1, 704, state.numBlockTypes[1]);
        HuffmanTreeGroup.init(state.hGroup2, numDistanceCodes, numDistTrees);
        HuffmanTreeGroup.decode(state.hGroup0, br);
        HuffmanTreeGroup.decode(state.hGroup1, br);
        HuffmanTreeGroup.decode(state.hGroup2, br);
        state.contextMapSlice = 0;
        state.distContextMapSlice = 0;
        state.contextLookupOffset1 = Context.LOOKUP_OFFSETS[state.contextModes[0]];
        state.contextLookupOffset2 = Context.LOOKUP_OFFSETS[state.contextModes[0] + 1];
        state.literalTreeIndex = 0;
        state.literalTree = state.hGroup0.trees[0];
        state.treeCommandOffset = state.hGroup1.trees[0];
        state.blockTypeRb[4] = 1;
        state.blockTypeRb[2] = 1;
        state.blockTypeRb[0] = 1;
        state.blockTypeRb[5] = 0;
        state.blockTypeRb[3] = 0;
        state.blockTypeRb[1] = 0;
    }

    private static void copyUncompressedData(State state) {
        BitReader br = state.br;
        byte[] ringBuffer = state.ringBuffer;
        if (state.metaBlockLength <= 0) {
            BitReader.reload(br);
            state.runningState = 1;
            return;
        }
        int chunkLength = Math.min(state.ringBufferSize - state.pos, state.metaBlockLength);
        BitReader.copyBytes(br, ringBuffer, state.pos, chunkLength);
        state.metaBlockLength -= chunkLength;
        state.pos += chunkLength;
        if (state.pos == state.ringBufferSize) {
            state.nextRunningState = 5;
            state.bytesToWrite = state.ringBufferSize;
            state.bytesWritten = 0;
            state.runningState = 12;
            return;
        }
        BitReader.reload(br);
        state.runningState = 1;
    }

    private static boolean writeRingBuffer(State state) {
        int toWrite;
        if (state.bytesToIgnore != 0) {
            state.bytesWritten += state.bytesToIgnore;
            state.bytesToIgnore = 0;
        }
        if ((toWrite = Math.min(state.outputLength - state.outputUsed, state.bytesToWrite - state.bytesWritten)) != 0) {
            System.arraycopy(state.ringBuffer, state.bytesWritten, state.output, state.outputOffset + state.outputUsed, toWrite);
            state.outputUsed += toWrite;
            state.bytesWritten += toWrite;
        }
        return state.outputUsed < state.outputLength;
    }

    static void setCustomDictionary(State state, byte[] data) {
        state.customDictionary = data == null ? new byte[]{} : data;
    }

    /*
     * Unable to fully structure code
     */
    static void decompress(State state) {
        if (state.runningState == 0) {
            throw new IllegalStateException("Can't decompress until initialized");
        }
        if (state.runningState == 11) {
            throw new IllegalStateException("Can't decompress after close");
        }
        br = state.br;
        ringBufferMask = state.ringBufferSize - 1;
        ringBuffer = state.ringBuffer;
        block12: while (state.runningState != 10) {
            switch (state.runningState) {
                case 1: {
                    if (state.metaBlockLength < 0) {
                        throw new BrotliRuntimeException("Invalid metablock length");
                    }
                    Decode.readMetablockInfo(state);
                    ringBufferMask = state.ringBufferSize - 1;
                    ringBuffer = state.ringBuffer;
                    continue block12;
                }
                case 2: {
                    Decode.readMetablockHuffmanCodesAndContextMaps(state);
                    state.runningState = 3;
                }
                case 3: {
                    if (state.metaBlockLength <= 0) {
                        state.runningState = 1;
                        continue block12;
                    }
                    BitReader.readMoreInput(br);
                    if (state.blockLength[1] == 0) {
                        Decode.decodeCommandBlockSwitch(state);
                    }
                    state.blockLength[1] = state.blockLength[1] - 1;
                    BitReader.fillBitWindow(br);
                    cmdCode = Decode.readSymbol(state.hGroup1.codes, state.treeCommandOffset, br);
                    rangeIdx = cmdCode >>> 6;
                    state.distanceCode = 0;
                    if (rangeIdx >= 2) {
                        rangeIdx -= 2;
                        state.distanceCode = -1;
                    }
                    insertCode = Prefix.INSERT_RANGE_LUT[rangeIdx] + (cmdCode >>> 3 & 7);
                    copyCode = Prefix.COPY_RANGE_LUT[rangeIdx] + (cmdCode & 7);
                    state.insertLength = Prefix.INSERT_LENGTH_OFFSET[insertCode] + BitReader.readBits(br, Prefix.INSERT_LENGTH_N_BITS[insertCode]);
                    state.copyLength = Prefix.COPY_LENGTH_OFFSET[copyCode] + BitReader.readBits(br, Prefix.COPY_LENGTH_N_BITS[copyCode]);
                    state.j = 0;
                    state.runningState = 6;
                }
                case 6: {
                    if (!state.trivialLiteralContext) ** GOTO lbl58
                    while (state.j < state.insertLength) {
                        BitReader.readMoreInput(br);
                        if (state.blockLength[0] == 0) {
                            Decode.decodeLiteralBlockSwitch(state);
                        }
                        state.blockLength[0] = state.blockLength[0] - 1;
                        BitReader.fillBitWindow(br);
                        ringBuffer[state.pos] = (byte)Decode.readSymbol(state.hGroup0.codes, state.literalTree, br);
                        ++state.j;
                        if (state.pos++ != ringBufferMask) continue;
                        state.nextRunningState = 6;
                        state.bytesToWrite = state.ringBufferSize;
                        state.bytesWritten = 0;
                        state.runningState = 12;
                        ** GOTO lbl77
                    }
                    ** GOTO lbl77
lbl58:
                    // 1 sources

                    prevByte1 = ringBuffer[state.pos - 1 & ringBufferMask] & 255;
                    prevByte2 = ringBuffer[state.pos - 2 & ringBufferMask] & 255;
                    while (state.j < state.insertLength) {
                        BitReader.readMoreInput(br);
                        if (state.blockLength[0] == 0) {
                            Decode.decodeLiteralBlockSwitch(state);
                        }
                        literalTreeIndex = state.contextMap[state.contextMapSlice + (Context.LOOKUP[state.contextLookupOffset1 + prevByte1] | Context.LOOKUP[state.contextLookupOffset2 + prevByte2])] & 255;
                        state.blockLength[0] = state.blockLength[0] - 1;
                        prevByte2 = prevByte1;
                        BitReader.fillBitWindow(br);
                        prevByte1 = Decode.readSymbol(state.hGroup0.codes, state.hGroup0.trees[literalTreeIndex], br);
                        ringBuffer[state.pos] = (byte)prevByte1;
                        ++state.j;
                        if (state.pos++ != ringBufferMask) continue;
                        state.nextRunningState = 6;
                        state.bytesToWrite = state.ringBufferSize;
                        state.bytesWritten = 0;
                        state.runningState = 12;
                        break;
                    }
lbl77:
                    // 4 sources

                    if (state.runningState != 6) continue block12;
                    state.metaBlockLength -= state.insertLength;
                    if (state.metaBlockLength <= 0) {
                        state.runningState = 3;
                        continue block12;
                    }
                    if (state.distanceCode < 0) {
                        BitReader.readMoreInput(br);
                        if (state.blockLength[2] == 0) {
                            Decode.decodeDistanceBlockSwitch(state);
                        }
                        state.blockLength[2] = state.blockLength[2] - 1;
                        BitReader.fillBitWindow(br);
                        state.distanceCode = Decode.readSymbol(state.hGroup2.codes, state.hGroup2.trees[state.distContextMap[state.distContextMapSlice + (state.copyLength > 4 ? 3 : state.copyLength - 2)] & 255], br);
                        if (state.distanceCode >= state.numDirectDistanceCodes) {
                            state.distanceCode -= state.numDirectDistanceCodes;
                            postfix = state.distanceCode & state.distancePostfixMask;
                            state.distanceCode >>>= state.distancePostfixBits;
                            n = (state.distanceCode >>> 1) + 1;
                            offset = (2 + (state.distanceCode & 1) << n) - 4;
                            state.distanceCode = state.numDirectDistanceCodes + postfix + (offset + BitReader.readBits(br, n) << state.distancePostfixBits);
                        }
                    }
                    state.distance = Decode.translateShortCodes(state.distanceCode, state.distRb, state.distRbIdx);
                    if (state.distance < 0) {
                        throw new BrotliRuntimeException("Negative distance");
                    }
                    state.maxDistance = state.maxDistance != state.maxBackwardDistance && state.pos < state.maxBackwardDistance ? state.pos : state.maxBackwardDistance;
                    state.copyDst = state.pos;
                    if (state.distance > state.maxDistance) {
                        state.runningState = 9;
                        continue block12;
                    }
                    if (state.distanceCode > 0) {
                        state.distRb[state.distRbIdx & 3] = state.distance;
                        ++state.distRbIdx;
                    }
                    if (state.copyLength > state.metaBlockLength) {
                        throw new BrotliRuntimeException("Invalid backward reference");
                    }
                    state.j = 0;
                    state.runningState = 7;
                }
                case 7: {
                    src = state.pos - state.distance & ringBufferMask;
                    dst = state.pos;
                    copyLength = state.copyLength - state.j;
                    if (src + copyLength < ringBufferMask && dst + copyLength < ringBufferMask) {
                        for (k = 0; k < copyLength; ++k) {
                            ringBuffer[dst++] = ringBuffer[src++];
                        }
                        state.j += copyLength;
                        state.metaBlockLength -= copyLength;
                        state.pos += copyLength;
                    } else {
                        while (state.j < state.copyLength) {
                            ringBuffer[state.pos] = ringBuffer[state.pos - state.distance & ringBufferMask];
                            --state.metaBlockLength;
                            ++state.j;
                            if (state.pos++ != ringBufferMask) continue;
                            state.nextRunningState = 7;
                            state.bytesToWrite = state.ringBufferSize;
                            state.bytesWritten = 0;
                            state.runningState = 12;
                            break;
                        }
                    }
                    if (state.runningState != 7) continue block12;
                    state.runningState = 3;
                    continue block12;
                }
                case 9: {
                    if (state.copyLength < 4 || state.copyLength > 24) ** GOTO lbl158
                    offset = Dictionary.OFFSETS_BY_LENGTH[state.copyLength];
                    wordId = state.distance - state.maxDistance - 1;
                    shift = Dictionary.SIZE_BITS_BY_LENGTH[state.copyLength];
                    mask = (1 << shift) - 1;
                    wordIdx = wordId & mask;
                    transformIdx = wordId >>> shift;
                    offset += wordIdx * state.copyLength;
                    if (transformIdx < Transform.TRANSFORMS.length) {
                        len = Transform.transformDictionaryWord(ringBuffer, state.copyDst, Dictionary.getData(), offset, state.copyLength, Transform.TRANSFORMS[transformIdx]);
                        state.copyDst += len;
                        state.pos += len;
                        state.metaBlockLength -= len;
                        if (state.copyDst >= state.ringBufferSize) {
                            state.nextRunningState = 8;
                            state.bytesToWrite = state.ringBufferSize;
                            state.bytesWritten = 0;
                            state.runningState = 12;
                            continue block12;
                        }
                    } else {
                        throw new BrotliRuntimeException("Invalid backward reference");
lbl158:
                        // 1 sources

                        throw new BrotliRuntimeException("Invalid backward reference");
                    }
                    state.runningState = 3;
                    continue block12;
                }
                case 8: {
                    System.arraycopy(ringBuffer, state.ringBufferSize, ringBuffer, 0, state.copyDst - state.ringBufferSize);
                    state.runningState = 3;
                    continue block12;
                }
                case 4: {
                    while (state.metaBlockLength > 0) {
                        BitReader.readMoreInput(br);
                        BitReader.readBits(br, 8);
                        --state.metaBlockLength;
                    }
                    state.runningState = 1;
                    continue block12;
                }
                case 5: {
                    Decode.copyUncompressedData(state);
                    continue block12;
                }
                case 12: {
                    if (!Decode.writeRingBuffer(state)) {
                        return;
                    }
                    if (state.pos >= state.maxBackwardDistance) {
                        state.maxDistance = state.maxBackwardDistance;
                    }
                    state.pos &= ringBufferMask;
                    state.runningState = state.nextRunningState;
                    continue block12;
                }
            }
            throw new BrotliRuntimeException("Unexpected state " + state.runningState);
        }
        if (state.runningState == 10) {
            if (state.metaBlockLength < 0) {
                throw new BrotliRuntimeException("Invalid metablock length");
            }
            BitReader.jumpToByteBoundary(br);
            BitReader.checkHealth(state.br, true);
        }
    }
}

