/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz8W;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.zz9N;
import com.aspose.words.zzZ8C;
import com.aspose.words.zzZIP;
import com.aspose.words.zzZIT;
import com.aspose.words.zzZJ9;
import com.aspose.words.zzZRS;
import com.aspose.words.zzZRT;
import com.aspose.words.zzZS5;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzZRS,
Iterable<T> {
    private Node zz1j;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    boolean zznX() {
        return this.zznU() != null;
    }

    boolean zznW() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    boolean zznV() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof zzZS5)) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.getLastChild() != null ? this.getLastChild().zzZtr() : null;
    }

    public Node getLastChild() {
        return this.zz1j;
    }

    Node zznU() {
        return zzZIP.zzZ9(this.getFirstChild());
    }

    Node zznT() {
        return zzZIP.zzZ8(this.getLastChild());
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzZ(boolean bl, zzZRT zzZRT2) throws Exception {
        CompositeNode compositeNode = (CompositeNode)super.zzZ(bl, zzZRT2);
        compositeNode.zz1j = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzJ(node.zzZ(true, zzZRT2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = this.zznQ();
        zz8W.zzX(stringBuilder, this.zznS());
        return stringBuilder.toString();
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    @Deprecated
    public NodeCollection getChildNodes(int nodeType, boolean isDeep, boolean isLive) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzZIP.zzDB(nodeType);
            Node node2 = node = bl ? this.zznU() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzZtu() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zz9N.zzW(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zz9N.zzV(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZJ9(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzZ(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzZ(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new IllegalArgumentException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzZ(oldChild, this, null, 1);
        if (documentBase.zzZZO() && zzZ8C.zzYB(oldChild)) {
            return oldChild;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzZ(nodeChangingArgs);
        }
        if (oldChild == this.getFirstChild()) {
            if (this.getLastChild().zzZtr() == this.getLastChild()) {
                this.zz1j = null;
            } else {
                Node node = oldChild.zzZtr();
                this.getLastChild().zzZM(node);
                node.zzZL(this.getLastChild());
            }
        } else {
            Node node = oldChild.zzZtq();
            Node node2 = oldChild.zzZtr();
            node.zzZM(node2);
            node2.zzZL(node);
            if (oldChild == this.getLastChild()) {
                this.zz1j = node;
            }
        }
        oldChild.zzZM(null);
        oldChild.zzZL(null);
        oldChild.zzZK(null);
        if (nodeChangingArgs != null) {
            documentBase.zzY(nodeChangingArgs);
        }
        return oldChild;
    }

    public void removeAllChildren() {
        zzZIT.zzu(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    Node zzJ(Node node) {
        if (this.getLastChild() == null) {
            node.zzZL(node);
            node.zzZM(node);
        } else {
            Node node2 = this.getLastChild().zzZtr();
            node.zzZL(this.getLastChild());
            node.zzZM(node2);
            node2.zzZL(node);
            this.getLastChild().zzZM(node);
        }
        this.zz1j = node;
        node.zzZK(this);
        return node;
    }

    void zzZ(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    void zzY(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    int zzI(Node node) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (zzZIP.zzs(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zznS().length();
    }

    String zznS() {
        return "";
    }

    String zznR() {
        return this.zznQ().toString();
    }

    private StringBuilder zznQ() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            zz8W.zzX(stringBuilder, node.getText());
        }
        return stringBuilder;
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzZ(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzY(visitor));
    }

    abstract int zzZ(DocumentVisitor var1) throws Exception;

    abstract int zzY(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzP(Node var1);

    Node zzZ(Node node, Node node2, boolean bl) {
        NodeChangingArgs nodeChangingArgs;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzZJ(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 35 && !this.zzP(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        if (node.getParentNode() != null) {
            node.getParentNode().removeChild(node);
        }
        if ((nodeChangingArgs = documentBase.zzZ(node, null, this, 0)) != null) {
            documentBase.zzZ(nodeChangingArgs);
        }
        if (this.getLastChild() == null) {
            node.zzZL(node);
            node.zzZM(node);
            this.zz1j = node;
        } else if (bl) {
            if (node2 != null) {
                CompositeNode.zzX(node, node2);
                if (node2 == this.getLastChild()) {
                    this.zz1j = node;
                }
            } else {
                CompositeNode.zzX(node, this.getLastChild());
            }
        } else if (node2 != null) {
            Node node3 = node2.getPreviousSibling();
            if (node3 == null) {
                node3 = this.getLastChild();
            }
            CompositeNode.zzX(node, node3);
        } else {
            CompositeNode.zzX(node, this.getLastChild());
            this.zz1j = node;
        }
        node.zzZK(this);
        if (nodeChangingArgs != null) {
            documentBase.zzY(nodeChangingArgs);
        }
        if (documentBase.zzZZO()) {
            zzZ8C.zzYC(node);
        }
        return node;
    }

    private static void zzX(Node node, Node node2) {
        Node node3 = node2.zzZtr();
        node.zzZL(node2);
        node.zzZM(node3);
        node2.zzZM(node);
        node3.zzZL(node);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node[] curNode) {
        Node node = curNode[0];
        curNode[0] = curNode[0] == this ? this.getFirstChild() : curNode[0].getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

