/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk.keyword;

import cfca.com.itextpdf.text.pdf.PdfReader;
import cfca.seal.sadk.LocationInfo;
import cfca.seal.sadk.keyword.PdfKeywordExtractor;
import java.io.IOException;

public class PdfKeywordLocationImpl {
    private PdfReader pdfReader;
    private LocationInfo keywordLocationInfo = new LocationInfo();

    public PdfKeywordLocationImpl(PdfReader pdfReader, String keyword) throws IOException {
        this.pdfReader = pdfReader;
        this.keywordLocate(keyword);
    }

    public PdfKeywordLocationImpl(PdfReader pdfReader, String keyword, int pageNo) throws IOException {
        this.pdfReader = pdfReader;
        this.keywordLocate(keyword, pageNo);
    }

    public PdfKeywordLocationImpl(byte[] data, String keyword) throws IOException {
        this.pdfReader = new PdfReader(data);
        this.keywordLocate(keyword);
    }

    private void keywordLocate(String keyword) throws IOException {
        int numOfPages = this.pdfReader.getNumberOfPages();
        for (int i = 1; i <= numOfPages; ++i) {
            LocationInfo locInfo = PdfKeywordExtractor.getKeywordFromPage(this.pdfReader, i, keyword);
            this.keywordLocationInfo.addSignature(locInfo);
        }
    }

    private void keywordLocate(String keyword, int pageNo) throws IOException {
        LocationInfo locInfo = PdfKeywordExtractor.getKeywordFromPage(this.pdfReader, pageNo, keyword);
        this.keywordLocationInfo.addSignature(locInfo);
    }

    public LocationInfo getKeywordLocation() {
        return this.keywordLocationInfo;
    }
}

