/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.styledxmlparser.css.media;

import cfca.sadk.com.itextpdf.styledxmlparser.css.media.MediaDeviceDescription;
import cfca.sadk.com.itextpdf.styledxmlparser.css.util.CssUtils;

public class MediaExpression {
    private static final float DEFAULT_FONT_SIZE = 12.0f;
    private boolean minPrefix;
    private boolean maxPrefix;
    private String feature;
    private String value;

    MediaExpression(String feature, String value) {
        this.feature = feature.trim().toLowerCase();
        if (value != null) {
            this.value = value.trim().toLowerCase();
        }
        String minPref = "min-";
        String maxPref = "max-";
        this.minPrefix = feature.startsWith(minPref);
        if (this.minPrefix) {
            this.feature = feature.substring(minPref.length());
        }
        this.maxPrefix = feature.startsWith(maxPref);
        if (this.maxPrefix) {
            this.feature = feature.substring(maxPref.length());
        }
    }

    public boolean matches(MediaDeviceDescription deviceDescription) {
        if ("color".equals(this.feature)) {
            Integer val = CssUtils.parseInteger(this.value);
            if (this.minPrefix) {
                return val != null && deviceDescription.getBitsPerComponent() >= val;
            }
            if (this.maxPrefix) {
                return val != null && deviceDescription.getBitsPerComponent() <= val;
            }
            return val == null ? deviceDescription.getBitsPerComponent() != 0 : val.intValue() == deviceDescription.getBitsPerComponent();
        }
        if ("color-index".equals(this.feature)) {
            Integer val = CssUtils.parseInteger(this.value);
            if (this.minPrefix) {
                return val != null && deviceDescription.getColorIndex() >= val;
            }
            if (this.maxPrefix) {
                return val != null && deviceDescription.getColorIndex() <= val;
            }
            return val == null ? deviceDescription.getColorIndex() != 0 : val.intValue() == deviceDescription.getColorIndex();
        }
        if ("aspect-ratio".equals(this.feature)) {
            int[] aspectRatio = CssUtils.parseAspectRatio(this.value);
            if (this.minPrefix) {
                return aspectRatio != null && (float)aspectRatio[0] * deviceDescription.getHeight() >= (float)aspectRatio[1] * deviceDescription.getWidth();
            }
            if (this.maxPrefix) {
                return aspectRatio != null && (float)aspectRatio[0] * deviceDescription.getHeight() <= (float)aspectRatio[1] * deviceDescription.getWidth();
            }
            return aspectRatio != null && CssUtils.compareFloats((float)aspectRatio[0] * deviceDescription.getHeight(), (float)aspectRatio[1] * deviceDescription.getWidth());
        }
        if ("grid".equals(this.feature)) {
            Integer val = CssUtils.parseInteger(this.value);
            return val != null && val == 0 && !deviceDescription.isGrid() || deviceDescription.isGrid();
        }
        if ("scan".equals(this.feature)) {
            String tmp = deviceDescription.getScan();
            if (this.value == null && tmp == null) {
                return true;
            }
            if (this.value == null && tmp != null || this.value != null && tmp == null) {
                return false;
            }
            return this.value.equals(tmp);
        }
        if ("orientation".equals(this.feature)) {
            String tmp = deviceDescription.getOrientation();
            if (this.value == null && tmp == null) {
                return true;
            }
            if (this.value == null && tmp != null || this.value != null && tmp == null) {
                return false;
            }
            return this.value.equals(tmp);
        }
        if ("monochrome".equals(this.feature)) {
            Integer val = CssUtils.parseInteger(this.value);
            if (this.minPrefix) {
                return val != null && deviceDescription.getMonochrome() >= val;
            }
            if (this.maxPrefix) {
                return val != null && deviceDescription.getMonochrome() <= val;
            }
            return val == null ? deviceDescription.getMonochrome() > 0 : val.intValue() == deviceDescription.getMonochrome();
        }
        if ("height".equals(this.feature)) {
            float val = MediaExpression.parseAbsoluteLength(this.value);
            if (this.minPrefix) {
                return deviceDescription.getHeight() >= val;
            }
            if (this.maxPrefix) {
                return deviceDescription.getHeight() <= val;
            }
            return deviceDescription.getHeight() > 0.0f;
        }
        if ("width".equals(this.feature)) {
            float val = MediaExpression.parseAbsoluteLength(this.value);
            if (this.minPrefix) {
                return deviceDescription.getWidth() >= val;
            }
            if (this.maxPrefix) {
                return deviceDescription.getWidth() <= val;
            }
            return deviceDescription.getWidth() > 0.0f;
        }
        if ("resolution".equals(this.feature)) {
            float val = CssUtils.parseResolution(this.value);
            if (this.minPrefix) {
                return deviceDescription.getResolution() >= val;
            }
            if (this.maxPrefix) {
                return deviceDescription.getResolution() <= val;
            }
            return deviceDescription.getResolution() > 0.0f;
        }
        return false;
    }

    private static float parseAbsoluteLength(String value) {
        if (CssUtils.isRelativeValue(value)) {
            return CssUtils.parseRelativeValue(value, 12.0f);
        }
        return CssUtils.parseAbsoluteLength(value);
    }
}

