/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.signatures;

import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDate;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObjectWrapper;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;
import cfca.sadk.com.itextpdf.signatures.PdfSignatureBuildProperties;

public class PdfSignature
extends PdfObjectWrapper<PdfDictionary> {
    public PdfSignature() {
        super(new PdfDictionary());
        this.put(PdfName.Type, PdfName.Sig);
    }

    public PdfSignature(PdfName filter, PdfName subFilter) {
        this();
        this.put(PdfName.Filter, filter);
        this.put(PdfName.SubFilter, subFilter);
    }

    public PdfSignature(PdfDictionary sigDictionary) {
        super(sigDictionary);
        PdfString contents = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Contents);
        if (contents != null) {
            contents.markAsUnencryptedObject();
        }
    }

    public PdfName getSubFilter() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.SubFilter);
    }

    public void setByteRange(int[] range) {
        PdfArray array = new PdfArray();
        for (int k = 0; k < range.length; ++k) {
            array.add(new PdfNumber(range[k]));
        }
        this.put(PdfName.ByteRange, array);
    }

    public PdfArray getByteRange() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.ByteRange);
    }

    public void setContents(byte[] contents) {
        PdfString contentsString = new PdfString(contents).setHexWriting(true);
        contentsString.markAsUnencryptedObject();
        this.put(PdfName.Contents, contentsString);
    }

    public PdfString getContents() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Contents);
    }

    public void setCert(byte[] cert) {
        this.put(PdfName.Cert, new PdfString(cert));
    }

    public PdfString getCert() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Cert);
    }

    public void setName(String name) {
        this.put(PdfName.Name, new PdfString(name, "UnicodeBig"));
    }

    public String getName() {
        PdfString nameStr = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Name);
        PdfName nameName = ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.Name);
        if (nameStr != null) {
            return nameStr.toUnicodeString();
        }
        return nameName != null ? nameName.getValue() : null;
    }

    public void setDate(PdfDate date) {
        this.put(PdfName.M, (PdfObject)date.getPdfObject());
    }

    public PdfString getDate() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.M);
    }

    public void setLocation(String location) {
        this.put(PdfName.Location, new PdfString(location, "UnicodeBig"));
    }

    public String getLocation() {
        PdfString locationStr = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Location);
        return locationStr != null ? locationStr.toUnicodeString() : null;
    }

    public void setReason(String reason) {
        this.put(PdfName.Reason, new PdfString(reason, "UnicodeBig"));
    }

    public String getReason() {
        PdfString reasonStr = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Reason);
        return reasonStr != null ? reasonStr.toUnicodeString() : null;
    }

    public void setSignatureCreator(String signatureCreator) {
        if (signatureCreator != null) {
            this.getPdfSignatureBuildProperties().setSignatureCreator(signatureCreator);
        }
    }

    public void setContact(String contactInfo) {
        this.put(PdfName.ContactInfo, new PdfString(contactInfo, "UnicodeBig"));
    }

    public PdfSignature put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        this.setModified();
        return this;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    private PdfSignatureBuildProperties getPdfSignatureBuildProperties() {
        PdfDictionary buildPropDict = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Prop_Build);
        if (buildPropDict == null) {
            buildPropDict = new PdfDictionary();
            this.put(PdfName.Prop_Build, buildPropDict);
        }
        return new PdfSignatureBuildProperties(buildPropDict);
    }
}

