/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.seal.base.util.MethodTime;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class MethodCostTimeUtil {
    private static Logger businessLog = LoggerFactory.getLogger(MethodCostTimeUtil.class);
    private static ThreadLocal<Hashtable<String, MethodTime>> mts = new ThreadLocal();
    private static Hashtable<String, AtomicInteger> methodCallMap = new Hashtable();
    private static int MAX_SIZE = 1000;

    public static String recordStartTime(String methodName) {
        String uniid = null;
        try {
            MethodTime mt;
            if (!businessLog.isInfoEnabled()) {
                return uniid;
            }
            Hashtable<String, MethodTime> map = mts.get();
            if (map == null) {
                map = new Hashtable();
            }
            if (map.size() > MAX_SIZE) {
                map.clear();
                mts.remove();
                mts.set(map);
            }
            if ((mt = map.get(methodName)) == null) {
                AtomicInteger callTimes = methodCallMap.get(methodName);
                if (callTimes == null) {
                    callTimes = new AtomicInteger();
                    methodCallMap.put(methodName, callTimes);
                }
                mt = new MethodTime(methodName, callTimes.incrementAndGet());
                uniid = mt.getmethodName();
                map.put(uniid, mt);
                mts.set(map);
            }
            return uniid;
        }
        catch (Exception e) {
            businessLog.error("recordStartTime", (Throwable)e);
            return uniid;
        }
    }

    public static void recordEndTime(String methodName) {
        try {
            if (businessLog.isInfoEnabled()) {
                Hashtable<String, MethodTime> map = mts.get();
                if (map == null || map.size() == 0) {
                    return;
                }
                MethodTime mt = map.get(methodName);
                if (mt != null && mt.getmethodName().equals(methodName)) {
                    map.remove(methodName);
                    mts.set(map);
                    businessLog.info(methodName + " cost:" + (System.currentTimeMillis() - mt.getTime()) + " ms");
                }
            }
        }
        catch (Exception e) {
            businessLog.error("recordEndTime", (Throwable)e);
        }
    }

    public static void printMethodCallsInfo() {
        if (businessLog.isInfoEnabled()) {
            try {
                Set<String> set = methodCallMap.keySet();
                Iterator<String> iterator = set.iterator();
                StringBuilder builder = new StringBuilder();
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    builder.append(key + "\u65b9\u6cd5\u8c03\u7528\u6b21\u6570=" + methodCallMap.get(key));
                }
                businessLog.info(builder.toString());
            }
            catch (Exception e) {
                businessLog.error("printMethodCallsInfo", (Throwable)e);
            }
        }
    }
}

