/*
 * Decompiled with CFR 0.152.
 */
package cfca.integration.uarc.fn;

public class CoordTransformer {
    private int h;
    private int k;
    private double theta;

    public CoordTransformer(int h, int k, double theta) {
        this.h = h;
        this.k = k;
        this.theta = theta;
    }

    public int[][] translateFromDeviceToLogical(int[][] deviceCoordPoints) {
        int nPoints = deviceCoordPoints[0].length;
        int[][] points = new int[2][nPoints];
        for (int i = 0; i < nPoints; ++i) {
            points[0][i] = deviceCoordPoints[0][i] + this.h;
            points[1][i] = -deviceCoordPoints[1][i] + this.k;
        }
        return points;
    }

    public int[] translateFromDeviceToLogical(int[] deviceCoordPoint) {
        int[] point = new int[]{deviceCoordPoint[0] + this.h, -deviceCoordPoint[1] + this.k};
        return point;
    }

    public int[][] translateFromLogicalToDevice(int[][] logicalCoordPoints) {
        int nPoints = logicalCoordPoints[0].length;
        int[][] points = new int[2][nPoints];
        for (int i = 0; i < nPoints; ++i) {
            points[0][i] = logicalCoordPoints[0][i] - this.h;
            points[1][i] = -logicalCoordPoints[1][i] + this.k;
        }
        return points;
    }

    public int[] translateFromLogicalToDevice(int[] logicalCoordPoint) {
        int[] point = new int[]{logicalCoordPoint[0] - this.h, -logicalCoordPoint[1] + this.k};
        return point;
    }

    public int[][] rotateInLogical(int[][] oldCoordPoints) {
        int nPoints = oldCoordPoints[0].length;
        int[][] points = new int[2][nPoints];
        for (int i = 0; i < nPoints; ++i) {
            int oldx = oldCoordPoints[0][i];
            int oldy = oldCoordPoints[1][i];
            int newx = (int)((double)oldx * Math.cos(this.theta) + (double)oldy * Math.sin(this.theta) + 0.5);
            int newy = (int)((double)oldy * Math.cos(this.theta) - (double)oldx * Math.sin(this.theta) + 0.5);
            points[0][i] = newx;
            points[1][i] = newy;
        }
        return points;
    }

    public int[] rotateInLogical(int[] oldCoordPoint) {
        int[] point = new int[2];
        int oldx = oldCoordPoint[0];
        int oldy = oldCoordPoint[1];
        int newx = (int)((double)oldx * Math.cos(this.theta) + (double)oldy * Math.sin(this.theta) + 0.5);
        int newy = (int)((double)oldy * Math.cos(this.theta) - (double)oldx * Math.sin(this.theta) + 0.5);
        point[0] = newx;
        point[1] = newy;
        return point;
    }

    public int[][] translateFromLogicalToLogical(int[][] logicalCoordPoints) {
        int nPoints = logicalCoordPoints[0].length;
        int[][] points = new int[2][nPoints];
        for (int i = 0; i < nPoints; ++i) {
            points[0][i] = logicalCoordPoints[0][i] - this.h;
            points[1][i] = logicalCoordPoints[1][i] - this.k;
        }
        return points;
    }

    public int[] translateFromLogicalToLogical(int[] logicalCoordPoint) {
        int[] point = new int[]{logicalCoordPoint[0] - this.h, logicalCoordPoint[1] - this.k};
        return point;
    }
}

