/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table.core;

import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.com.google.typography.font.sfntly.table.core.CMap;
import cfca.com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CMapFormat0
extends CMap {
    protected CMapFormat0(ReadableFontData data, CMapTable.CMapId cmapId) {
        super(data, CMap.CMapFormat.Format0.value, cmapId);
    }

    @Override
    public int glyphId(int character) {
        if (character < 0 || character > 255) {
            return 0;
        }
        return this.data.readUByte(character + CMapTable.Offset.format0GlyphIdArray.offset);
    }

    @Override
    public int language() {
        return this.data.readUShort(CMapTable.Offset.format0Language.offset);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new CharacterIterator();
    }

    public static class Builder
    extends CMap.Builder<CMapFormat0> {
        protected Builder(WritableFontData data, int offset, CMapTable.CMapId cmapId) {
            super(data == null ? null : data.slice(offset, data.readUShort(offset + CMapTable.Offset.format0Length.offset)), CMap.CMapFormat.Format0, cmapId);
        }

        protected Builder(ReadableFontData data, int offset, CMapTable.CMapId cmapId) {
            super(data == null ? null : data.slice(offset, data.readUShort(offset + CMapTable.Offset.format0Length.offset)), CMap.CMapFormat.Format0, cmapId);
        }

        @Override
        protected CMapFormat0 subBuildTable(ReadableFontData data) {
            return new CMapFormat0(data, this.cmapId());
        }
    }

    private class CharacterIterator
    implements Iterator<Integer> {
        int character = 0;
        protected static final int MAX_CHARACTER = 255;

        private CharacterIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.character <= 255;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more characters to iterate.");
            }
            return this.character++;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove a character from cmap.");
        }
    }
}

