/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table.opentype.chaincontextsubst;

import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.com.google.typography.font.sfntly.table.SubTable;
import cfca.com.google.typography.font.sfntly.table.opentype.chaincontextsubst.CoverageArray;
import cfca.com.google.typography.font.sfntly.table.opentype.component.NumRecordList;
import cfca.com.google.typography.font.sfntly.table.opentype.component.SubstLookupRecordList;
import cfca.com.google.typography.font.sfntly.table.opentype.component.VisibleSubTable;

public class InnerArraysFmt3
extends SubTable {
    public final CoverageArray backtrackGlyphs;
    public final CoverageArray inputGlyphs;
    public final CoverageArray lookAheadGlyphs;
    public final SubstLookupRecordList lookupRecords;

    public InnerArraysFmt3(ReadableFontData data, int base, boolean dataIsCanonical) {
        super(data);
        NumRecordList records = new NumRecordList(data, 0, base);
        this.backtrackGlyphs = new CoverageArray(records);
        records = new NumRecordList(data, 0, records.limit());
        this.inputGlyphs = new CoverageArray(records);
        records = new NumRecordList(data, 0, records.limit());
        this.lookAheadGlyphs = new CoverageArray(records);
        this.lookupRecords = new SubstLookupRecordList(data, records.limit());
    }

    public static class Builder
    extends VisibleSubTable.Builder<InnerArraysFmt3> {
        private CoverageArray.Builder backtrackGlyphsBuilder;
        private CoverageArray.Builder inputGlyphsBuilder;
        private CoverageArray.Builder lookAheadGlyphsBuilder;
        private SubstLookupRecordList lookupRecordsBuilder;

        protected Builder() {
        }

        protected Builder(InnerArraysFmt3 table) {
            this(table.readFontData(), 0, false);
        }

        protected Builder(ReadableFontData data, int base, boolean dataIsCanonical) {
            super(data);
            if (!dataIsCanonical) {
                this.prepareToEdit();
            }
        }

        protected Builder(Builder other) {
            this.backtrackGlyphsBuilder = other.backtrackGlyphsBuilder;
            this.inputGlyphsBuilder = other.inputGlyphsBuilder;
            this.lookAheadGlyphsBuilder = other.lookAheadGlyphsBuilder;
            this.lookupRecordsBuilder = other.lookupRecordsBuilder;
        }

        @Override
        public int subDataSizeToSerialize() {
            if (this.lookupRecordsBuilder != null) {
                this.serializedLength = this.lookupRecordsBuilder.limit();
            } else {
                this.computeSizeFromData(this.internalReadData());
            }
            return this.serializedLength;
        }

        @Override
        public int subSerialize(WritableFontData newData) {
            if (this.serializedLength == 0) {
                return 0;
            }
            if (this.backtrackGlyphsBuilder == null || this.inputGlyphsBuilder == null || this.lookAheadGlyphsBuilder == null || this.lookupRecordsBuilder == null) {
                return this.serializeFromData(newData);
            }
            int tableOnlySize = 0;
            tableOnlySize += this.backtrackGlyphsBuilder.tableSizeToSerialize();
            tableOnlySize += this.inputGlyphsBuilder.tableSizeToSerialize();
            int subTableWriteOffset = (tableOnlySize += this.lookAheadGlyphsBuilder.tableSizeToSerialize()) + this.lookupRecordsBuilder.writeTo(newData.slice(tableOnlySize));
            this.backtrackGlyphsBuilder.subSerialize(newData, subTableWriteOffset);
            int tableWriteOffset = this.backtrackGlyphsBuilder.tableSizeToSerialize();
            this.inputGlyphsBuilder.subSerialize(newData.slice(tableWriteOffset), subTableWriteOffset += this.backtrackGlyphsBuilder.subTableSizeToSerialize());
            this.lookAheadGlyphsBuilder.subSerialize(newData.slice(tableWriteOffset += this.inputGlyphsBuilder.tableSizeToSerialize()), subTableWriteOffset += this.inputGlyphsBuilder.subTableSizeToSerialize());
            return subTableWriteOffset += this.lookAheadGlyphsBuilder.subTableSizeToSerialize();
        }

        @Override
        public InnerArraysFmt3 subBuildTable(ReadableFontData data) {
            return new InnerArraysFmt3(data, 0, true);
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }

        @Override
        public void subDataSet() {
            this.backtrackGlyphsBuilder = null;
            this.inputGlyphsBuilder = null;
            this.lookupRecordsBuilder = null;
            this.lookAheadGlyphsBuilder = null;
        }

        private void prepareToEdit() {
            this.initFromData(this.internalReadData());
            this.setModelChanged();
        }

        private void initFromData(ReadableFontData data) {
            if (this.backtrackGlyphsBuilder == null || this.inputGlyphsBuilder == null || this.lookAheadGlyphsBuilder == null || this.lookupRecordsBuilder == null) {
                NumRecordList records = new NumRecordList(data);
                this.backtrackGlyphsBuilder = new CoverageArray.Builder(records);
                records = new NumRecordList(data, 0, records.limit());
                this.inputGlyphsBuilder = new CoverageArray.Builder(records);
                records = new NumRecordList(data, 0, records.limit());
                this.lookAheadGlyphsBuilder = new CoverageArray.Builder(records);
                this.lookupRecordsBuilder = new SubstLookupRecordList(data, records.limit());
            }
        }

        private void computeSizeFromData(ReadableFontData data) {
            int len = 0;
            if (data != null) {
                len = data.length();
            }
            this.serializedLength = len;
        }

        private int serializeFromData(WritableFontData newData) {
            ReadableFontData data = this.internalReadData();
            data.copyTo(newData);
            return data.length();
        }
    }
}

