/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import cfca.sadk.seal.base.util.StringUtil;
import cfca.sadk.x509.certificate.X509CRLFile;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CrlManager {
    private static final Logger logger = LoggerFactory.getLogger(CrlManager.class);
    private static Map<String, X509CRLFile> crlCachePool = new ConcurrentHashMap<String, X509CRLFile>();
    private static final int maxLoop = 3;

    public static void init(String crlRootDir) throws SealException, IOException, PKIException {
        CrlManager.init(crlRootDir, 1);
        if (crlCachePool.isEmpty()) {
            throw new IllegalArgumentException(crlRootDir + " is empty,crl file is not loaded");
        }
    }

    private static void init(String crlRootDir, int loop) throws SealException, IOException, PKIException {
        long start = System.currentTimeMillis();
        logger.info("Crl manager init dir({}) start", (Object)crlRootDir);
        if (loop > 3) {
            logger.info("load crlRootDir,maxLoop is 3");
            return;
        }
        if (StringUtil.isEmpty(crlRootDir)) {
            throw new IllegalArgumentException("crlRootDir can not be empty");
        }
        File crlRootDirFile = new File(crlRootDir);
        if (!crlRootDirFile.exists()) {
            throw new SealException("the crlRootDir: " + crlRootDir + " is not exist");
        }
        File[] crlDirFileGroup = crlRootDirFile.listFiles();
        if (crlDirFileGroup != null && crlDirFileGroup.length > 0) {
            for (File crlDirFile : crlDirFileGroup) {
                if (crlDirFile.isDirectory()) {
                    CrlManager.init(crlDirFile.getAbsolutePath(), loop++);
                    continue;
                }
                String crlDirFilePath = crlDirFile.getAbsolutePath();
                if (crlDirFilePath.toLowerCase().endsWith(".crl")) {
                    X509CRLFile x509CRLFile = new X509CRLFile(crlDirFilePath, true);
                    String crlCacheKey = x509CRLFile.getIssuer() + "_" + crlDirFile.getName();
                    crlCachePool.put(crlCacheKey, x509CRLFile);
                    logger.info("Crl manager add crl(key:{})", (Object)crlCacheKey);
                    continue;
                }
                logger.warn("Crl manager add crl(but the file is not crl type, path:{})", (Object)crlDirFilePath);
            }
        }
        long end = System.currentTimeMillis();
        logger.info("Crl manager init dir({}) successfully,cost={}\n", (Object)crlRootDir, (Object)(end - start + "ms"));
    }

    public static boolean isRevoked(String issuerKey, String sn) throws SealException {
        String methodName = "CRL isRevoked";
        MethodCostTimeUtil.recordStartTime(methodName);
        Set<String> keySet = crlCachePool.keySet();
        Iterator<String> iterator = keySet.iterator();
        boolean certRevoked = false;
        boolean findCrlFile = false;
        while (iterator.hasNext()) {
            X509CRLFile x509CRLFile;
            String key = iterator.next();
            if (!key.contains(issuerKey) || (x509CRLFile = crlCachePool.get(key)) == null) continue;
            findCrlFile = true;
            boolean isRevoked = x509CRLFile.isRevoke(sn);
            if (!isRevoked) continue;
            certRevoked = isRevoked;
            break;
        }
        if (!findCrlFile) {
            throw new SealException("CRL file is not loaded,issuer is " + issuerKey);
        }
        MethodCostTimeUtil.recordEndTime(methodName);
        return certRevoked;
    }
}

